/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public final class Font
extends Resource {
    public long handle;

    Font(Device device) {
        super(device);
    }

    public Font(Device device, FontData fd) {
        super(device);
        if (fd == null) {
            SWT.error(4);
        }
        this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.string);
        this.init();
    }

    public Font(Device device, FontData[] fds) {
        super(device);
        if (fds == null) {
            SWT.error(4);
        }
        if (fds.length == 0) {
            SWT.error(5);
        }
        int i = 0;
        while (i < fds.length) {
            if (fds[i] == null) {
                SWT.error(5);
            }
            ++i;
        }
        FontData fd = fds[0];
        this.init(fd.getName(), fd.getHeightF(), fd.getStyle(), fd.string);
        this.init();
    }

    public Font(Device device, String name, int height, int style) {
        super(device);
        this.init(name, height, style, null);
        this.init();
    }

    Font(Device device, String name, float height, int style) {
        super(device);
        this.init(name, height, style, null);
        this.init();
    }

    @Override
    void destroy() {
        OS.pango_font_description_free(this.handle);
        this.handle = 0L;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Font)) {
            return false;
        }
        return this.handle == ((Font)object).handle;
    }

    public FontData[] getFontData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        long family = OS.pango_font_description_get_family(this.handle);
        int length = C.strlen(family);
        byte[] buffer = new byte[length];
        C.memmove(buffer, family, (long)length);
        String name = new String(Converter.mbcsToWcs(buffer));
        float height = (float)OS.pango_font_description_get_size(this.handle) / 1024.0f;
        Point dpi = this.device.dpi;
        Point screenDPI = this.device.getScreenDPI();
        float size = height * (float)screenDPI.y / (float)dpi.y;
        int pangoStyle = OS.pango_font_description_get_style(this.handle);
        int pangoWeight = OS.pango_font_description_get_weight(this.handle);
        int style = 0;
        if (pangoStyle == 2) {
            style |= 2;
        }
        if (pangoStyle == 1) {
            style |= 0x20;
        }
        if (pangoWeight >= 700) {
            style |= 1;
        }
        long fontString = OS.pango_font_description_to_string(this.handle);
        length = C.strlen(fontString);
        buffer = new byte[length + 1];
        C.memmove(buffer, fontString, (long)length);
        OS.g_free(fontString);
        FontData data = new FontData(name, size, style);
        data.string = buffer;
        return new FontData[]{data};
    }

    public static Font gtk_new(Device device, long handle) {
        Font font = new Font(device);
        font.handle = handle;
        font.ignoreNonDisposed();
        return font;
    }

    public int hashCode() {
        return (int)this.handle;
    }

    void init(String name, float height, int style, byte[] fontString) {
        if (name == null) {
            SWT.error(4);
        }
        if (height < 0.0f) {
            SWT.error(5);
        }
        Point dpi = this.device.dpi;
        Point screenDPI = this.device.getScreenDPI();
        float size = height * (float)dpi.y / (float)screenDPI.y;
        if (fontString != null) {
            this.handle = OS.pango_font_description_from_string(fontString);
            if (this.handle == 0L) {
                SWT.error(2);
            }
        } else {
            this.handle = OS.pango_font_description_new();
            if (this.handle == 0L) {
                SWT.error(2);
            }
            byte[] buffer = Converter.wcsToMbcs(name, true);
            OS.pango_font_description_set_family(this.handle, buffer);
            if (size > 0.0f) {
                OS.pango_font_description_set_size(this.handle, (int)(0.5f + size * 1024.0f));
            }
            OS.pango_font_description_set_stretch(this.handle, 4);
            int pangoStyle = 0;
            int pangoWeight = 400;
            if ((style & 2) != 0) {
                pangoStyle = 2;
            }
            if ((style & 0x20) != 0) {
                pangoStyle = 1;
            }
            if ((style & 1) != 0) {
                pangoWeight = 700;
            }
            OS.pango_font_description_set_style(this.handle, pangoStyle);
            OS.pango_font_description_set_weight(this.handle, pangoWeight);
        }
    }

    @Override
    public boolean isDisposed() {
        return this.handle == 0L;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Font {*DISPOSED*}";
        }
        return "Font {" + this.handle + "}";
    }
}

