/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.workbench.renderers.swt;

import java.lang.reflect.Method;
import javax.inject.Inject;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.services.log.Logger;
import org.eclipse.e4.ui.internal.workbench.Activator;
import org.eclipse.e4.ui.internal.workbench.swt.WorkbenchSWTActivator;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;

public class MenuManagerServiceFilter
implements Listener {
    public static final String NUL_MENU_ITEM = "(None Applicable)";
    private static final String TMP_ORIGINAL_CONTEXT = "MenuServiceFilter.original.context";
    private static Method aboutToShow;
    @Inject
    private Logger logger;
    @Inject
    EModelService modelService;

    private static void trace(String msg, Widget menu, MMenu menuModel) {
        WorkbenchSWTActivator.trace((String)"/trace/menus", (String)(msg + ": " + String.valueOf(menu) + ": " + String.valueOf(menuModel)), null);
    }

    public static Method getAboutToShow() {
        if (aboutToShow == null) {
            try {
                aboutToShow = MenuManager.class.getDeclaredMethod("handleAboutToShow", new Class[0]);
                aboutToShow.setAccessible(true);
            }
            catch (NoSuchMethodException | SecurityException e) {
                Activator.log((int)1, (String)e.getMessage(), (Throwable)e);
            }
        }
        return aboutToShow;
    }

    public void handleEvent(final Event event) {
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Error) {
                    throw (Error)e;
                }
                if (MenuManagerServiceFilter.this.logger != null) {
                    MenuManagerServiceFilter.this.logger.error(e);
                }
            }

            public void run() throws Exception {
                MenuManagerServiceFilter.this.safeHandleEvent(event);
            }
        });
    }

    private void safeHandleEvent(Event event) {
        Object obj;
        if (!(event.widget instanceof Menu)) {
            return;
        }
        Menu menu = (Menu)event.widget;
        if (event.type == 12) {
            MenuManagerServiceFilter.trace("handleMenu.Dispose", (Widget)menu, null);
            this.cleanUp(menu);
        }
        if ((obj = menu.getData("modelElement")) == null && menu.getParentItem() != null) {
            obj = menu.getParentItem().getData("modelElement");
        }
        if (obj instanceof MPopupMenu) {
            this.handleContextMenu(event, menu, (MPopupMenu)obj);
        } else if (obj instanceof MMenu) {
            this.handleMenu(event, menu, (MMenu)obj);
        }
    }

    private void handleMenu(Event event, Menu menu, MMenu menuModel) {
        if ((menu.getStyle() & 2) != 0) {
            return;
        }
        switch (event.type) {
            case 22: {
                this.cleanUp(menu);
                this.showMenu(event, menu, menuModel);
                break;
            }
        }
    }

    public void showMenu(Event event, Menu menu, MMenu menuModel) {
    }

    private void handleContextMenu(Event event, Menu menu, MPopupMenu menuModel) {
        switch (event.type) {
            case 22: {
                this.cleanUp(menu);
                this.showPopup(event, menu, menuModel);
                break;
            }
            case 23: {
                this.hidePopup(event, menu, menuModel);
            }
        }
    }

    public void hidePopup(Event event, Menu menu, MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext originalChild = (IEclipseContext)popupContext.get(TMP_ORIGINAL_CONTEXT);
        popupContext.remove(TMP_ORIGINAL_CONTEXT);
        if (!menu.isDisposed()) {
            menu.getDisplay().asyncExec(() -> {
                if (originalChild == null) {
                    popupContext.deactivate();
                } else {
                    originalChild.activate();
                }
            });
        }
    }

    public void showPopup(Event event, Menu menu, MPopupMenu menuModel) {
        IEclipseContext popupContext = menuModel.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        IEclipseContext originalChild = parentContext.getActiveChild();
        popupContext.activate();
        popupContext.set(TMP_ORIGINAL_CONTEXT, (Object)originalChild);
    }

    public void cleanUp(Menu menu) {
    }

    public void dispose() {
    }
}

