/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public final class PaintManager
implements KeyListener,
MouseListener,
ISelectionChangedListener,
ITextListener,
ITextInputListener {
    private List<IPainter> fPainters = new ArrayList<IPainter>(2);
    private PositionManager fManager;
    private ITextViewer fTextViewer;

    public PaintManager(ITextViewer textViewer) {
        this.fTextViewer = textViewer;
    }

    public void addPainter(IPainter painter) {
        if (!this.fPainters.contains(painter)) {
            this.fPainters.add(painter);
            if (this.fPainters.size() == 1) {
                this.install();
            }
            painter.setPositionManager(this.fManager);
            painter.paint(8);
        }
    }

    public void removePainter(IPainter painter) {
        if (this.fPainters.remove(painter)) {
            painter.deactivate(true);
            painter.setPositionManager(null);
        }
        if (this.fPainters.isEmpty()) {
            this.dispose();
        }
    }

    private void install() {
        this.fManager = new PositionManager();
        if (this.fTextViewer.getDocument() != null) {
            this.fManager.install(this.fTextViewer.getDocument());
            this.addListeners();
        }
        this.fTextViewer.addTextInputListener(this);
    }

    private void addListeners() {
        ISelectionProvider provider = this.fTextViewer.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fTextViewer.addTextListener(this);
        StyledText text = this.fTextViewer.getTextWidget();
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
    }

    public void dispose() {
        if (this.fManager != null) {
            this.fManager.dispose();
            this.fManager = null;
        }
        for (IPainter iPainter : this.fPainters) {
            iPainter.dispose();
        }
        this.fPainters.clear();
        this.fTextViewer.removeTextInputListener(this);
        this.removeListeners();
    }

    private void removeListeners() {
        ISelectionProvider provider = this.fTextViewer.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fTextViewer.removeTextListener(this);
        StyledText text = this.fTextViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.removeKeyListener((KeyListener)this);
            text.removeMouseListener((MouseListener)this);
        }
    }

    private void paint(int reason) {
        for (IPainter iPainter : this.fPainters) {
            iPainter.paint(reason);
        }
    }

    public void keyPressed(KeyEvent e) {
        this.paint(2);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.paint(4);
    }

    public void mouseUp(MouseEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.paint(0);
    }

    @Override
    public void textChanged(TextEvent event) {
        if (!event.getViewerRedrawState()) {
            return;
        }
        StyledText control = this.fTextViewer.getTextWidget();
        if (control != null) {
            control.getDisplay().asyncExec(() -> {
                if (this.fTextViewer != null) {
                    this.paint(1);
                }
            });
        }
    }

    @Override
    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            for (IPainter iPainter : this.fPainters) {
                iPainter.deactivate(false);
            }
            this.fManager.uninstall(oldInput);
            this.removeListeners();
        }
    }

    @Override
    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null && newInput != this.fManager.fDocument) {
            this.fManager.install(newInput);
            this.paint(1);
            this.addListeners();
        }
    }

    static class PaintPositionUpdater
    extends DefaultPositionUpdater {
        protected PaintPositionUpdater(String category) {
            super(category);
        }

        protected void adaptToInsert() {
            int yoursStart;
            int myStart = this.fPosition.offset;
            int myEnd = this.fPosition.offset + this.fPosition.length;
            if ((myEnd = Math.max(myStart, myEnd)) < (yoursStart = this.fOffset)) {
                return;
            }
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
    }

    static class PositionManager
    implements IPaintPositionManager {
        private IDocument fDocument;
        private IPositionUpdater fPositionUpdater;
        private String fCategory = this.getClass().getName() + this.hashCode();

        public PositionManager() {
            this.fPositionUpdater = new PaintPositionUpdater(this.fCategory);
        }

        public void install(IDocument document) {
            this.fDocument = document;
            this.fDocument.addPositionCategory(this.fCategory);
            this.fDocument.addPositionUpdater(this.fPositionUpdater);
        }

        public void dispose() {
            this.uninstall(this.fDocument);
        }

        public void uninstall(IDocument document) {
            if (document == this.fDocument && document != null) {
                try {
                    this.fDocument.removePositionUpdater(this.fPositionUpdater);
                    this.fDocument.removePositionCategory(this.fCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                this.fDocument = null;
            }
        }

        @Override
        public void managePosition(Position position) {
            if (this.fDocument == null) {
                return;
            }
            try {
                this.fDocument.addPosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        @Override
        public void unmanagePosition(Position position) {
            try {
                this.fDocument.removePosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }
}

