/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.undo;

import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.ui.ide.dialogs.UIResourceFilterDescription;
import org.eclipse.ui.ide.undo.ResourceDescription;
import org.eclipse.ui.internal.ide.undo.AbstractResourceDescription;
import org.eclipse.ui.internal.ide.undo.FileDescription;
import org.eclipse.ui.internal.ide.undo.FolderDescription;
import org.eclipse.ui.internal.ide.undo.ProjectDescription;
import org.eclipse.ui.internal.ide.undo.UndoMessages;

public abstract class ContainerDescription
extends AbstractResourceDescription {
    String name;
    URI location;
    UIResourceFilterDescription[] filters;
    String defaultCharSet;
    AbstractResourceDescription[] members;

    public static ContainerDescription fromContainer(IContainer container) {
        return ContainerDescription.fromContainer(container, false);
    }

    public static ContainerDescription fromVirtualFolderContainer(IContainer container) {
        return ContainerDescription.fromContainer(container, true);
    }

    protected static ContainerDescription fromContainer(IContainer container, boolean usingVirtualFolder) {
        IPath fullPath = container.getFullPath();
        ContainerDescription firstCreatedParent = null;
        ContainerDescription currentContainerDescription = null;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IContainer currentContainer = (IContainer)root.findMember(fullPath);
        if (currentContainer != null) {
            return (ContainerDescription)ResourceDescription.fromResource((IResource)container);
        }
        currentContainer = root;
        int i = 0;
        while (i < fullPath.segmentCount()) {
            String currentSegment = fullPath.segment(i);
            IResource resource = currentContainer.findMember(currentSegment);
            if (resource != null) {
                currentContainer = (IContainer)resource;
            } else if (i == 0) {
                currentContainerDescription = firstCreatedParent = new ProjectDescription(root.getProject(currentSegment));
            } else {
                IFolder folderHandle = currentContainer.getFolder(IPath.fromOSString((String)currentSegment));
                FolderDescription currentFolder = new FolderDescription(folderHandle, usingVirtualFolder);
                currentContainer = folderHandle;
                if (currentContainerDescription != null) {
                    currentContainerDescription.addMember(currentFolder);
                }
                currentContainerDescription = currentFolder;
                if (firstCreatedParent == null) {
                    firstCreatedParent = currentFolder;
                }
            }
            ++i;
        }
        return firstCreatedParent;
    }

    public ContainerDescription() {
    }

    public ContainerDescription(IContainer container) {
        super((IResource)container);
        this.name = container.getName();
        if (container.isLinked()) {
            this.location = container.getLocationURI();
        }
        try {
            if (container.isAccessible()) {
                this.defaultCharSet = container.getDefaultCharset(false);
                IResource[] resourceMembers = container.members();
                this.members = new AbstractResourceDescription[resourceMembers.length];
                int i = 0;
                while (i < resourceMembers.length) {
                    this.members[i] = (AbstractResourceDescription)ResourceDescription.fromResource(resourceMembers[i]);
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
    }

    protected final void createChildResources(IContainer parentHandle, IProgressMonitor monitor) throws CoreException {
        if (this.members != null && this.members.length > 0) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)this.members.length);
            AbstractResourceDescription[] abstractResourceDescriptionArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractResourceDescription member = abstractResourceDescriptionArray[n2];
                member.parent = parentHandle;
                member.createResource((IProgressMonitor)subMonitor.split(1));
                ++n2;
            }
        }
    }

    @Override
    public void recordStateFromHistory(IResource resource, IProgressMonitor mon) throws CoreException {
        if (this.members != null) {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)mon, (String)UndoMessages.FolderDescription_SavingUndoInfoProgress, (int)this.members.length);
            AbstractResourceDescription[] abstractResourceDescriptionArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractResourceDescription member = abstractResourceDescriptionArray[n2];
                SubMonitor iterationMonitor = subMonitor.split(1);
                if (member instanceof FileDescription) {
                    path = resource.getFullPath().append(((FileDescription)member).name);
                    IFile fileHandle = resource.getWorkspace().getRoot().getFile(path);
                    member.recordStateFromHistory((IResource)fileHandle, (IProgressMonitor)iterationMonitor);
                } else if (member instanceof FolderDescription) {
                    path = resource.getFullPath().append(((FolderDescription)member).name);
                    IFolder folderHandle = resource.getWorkspace().getRoot().getFolder(path);
                    member.recordStateFromHistory((IResource)folderHandle, (IProgressMonitor)iterationMonitor);
                }
                ++n2;
            }
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    public ContainerDescription getFirstLeafFolder() {
        if (this.members == null || this.members.length == 0) {
            return this;
        }
        AbstractResourceDescription[] abstractResourceDescriptionArray = this.members;
        int n = this.members.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractResourceDescription member = abstractResourceDescriptionArray[n2];
            if (member instanceof ContainerDescription) {
                return ((ContainerDescription)member).getFirstLeafFolder();
            }
            ++n2;
        }
        return this;
    }

    public void addMember(AbstractResourceDescription member) {
        if (this.members == null) {
            this.members = new AbstractResourceDescription[]{member};
        } else {
            AbstractResourceDescription[] expandedMembers = new AbstractResourceDescription[this.members.length + 1];
            System.arraycopy(this.members, 0, expandedMembers, 0, this.members.length);
            expandedMembers[this.members.length] = member;
            this.members = expandedMembers;
        }
    }

    @Override
    protected void restoreResourceAttributes(IResource resource) throws CoreException {
        super.restoreResourceAttributes(resource);
        Assert.isLegal((boolean)(resource instanceof IContainer));
        IContainer container = (IContainer)resource;
        if (this.defaultCharSet != null) {
            container.setDefaultCharset(this.defaultCharSet, null);
        }
    }

    public void setLocation(URI location) {
        this.location = location;
    }

    public void setFilters(UIResourceFilterDescription[] filters) {
        this.filters = filters;
    }

    @Override
    public boolean verifyExistence(boolean checkMembers) {
        boolean existence = super.verifyExistence(checkMembers);
        if (existence) {
            if (checkMembers && this.members != null && this.members.length > 0) {
                AbstractResourceDescription[] abstractResourceDescriptionArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractResourceDescription member = abstractResourceDescriptionArray[n2];
                    if (!member.verifyExistence(checkMembers)) {
                        return false;
                    }
                    ++n2;
                }
            }
            return true;
        }
        return false;
    }
}

