/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.legacy.crypto.sike;

import java.util.Properties;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.encoders.Hex;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class Internal {
    protected static final int RADIX = 64;
    protected static final int LOG2RADIX = 6;
    protected int CRYPTO_PUBLICKEYBYTES;
    protected int CRYPTO_CIPHERTEXTBYTES;
    protected int CRYPTO_BYTES;
    protected int CRYPTO_SECRETKEYBYTES;
    protected int NWORDS_FIELD;
    protected int PRIME_ZERO_WORDS;
    protected int NBITS_FIELD;
    protected int MAXBITS_FIELD;
    protected int MAXWORDS_FIELD;
    protected int NWORDS64_FIELD;
    protected int NBITS_ORDER;
    protected int NWORDS_ORDER;
    protected int NWORDS64_ORDER;
    protected int MAXBITS_ORDER;
    protected int ALICE;
    protected int BOB;
    protected int OALICE_BITS;
    protected int OBOB_BITS;
    protected int OBOB_EXPON;
    protected int MASK_ALICE;
    protected int MASK_BOB;
    protected int PARAM_A;
    protected int PARAM_C;
    protected int MAX_INT_POINTS_ALICE;
    protected int MAX_INT_POINTS_BOB;
    protected int MAX_Alice;
    protected int MAX_Bob;
    protected int MSG_BYTES;
    protected int SECRETKEY_A_BYTES;
    protected int SECRETKEY_B_BYTES;
    protected int FP2_ENCODED_BYTES;
    protected boolean COMPRESS;
    protected int MASK2_BOB;
    protected int MASK3_BOB;
    protected int ORDER_A_ENCODED_BYTES;
    protected int ORDER_B_ENCODED_BYTES;
    protected int PARTIALLY_COMPRESSED_CHUNK_CT;
    protected int COMPRESSED_CHUNK_CT;
    protected int UNCOMPRESSEDPK_BYTES;
    protected int TABLE_R_LEN;
    protected int TABLE_V_LEN;
    protected int TABLE_V3_LEN;
    protected int W_2;
    protected int W_3;
    protected int ELL2_W;
    protected int ELL3_W;
    protected int ELL2_EMODW;
    protected int ELL3_EMODW;
    protected int DLEN_2;
    protected int DLEN_3;
    protected int PLEN_2;
    protected int PLEN_3;
    protected long[] PRIME;
    protected long[] PRIMEx2;
    protected long[] PRIMEx4;
    protected long[] PRIMEp1;
    protected long[] PRIMEx16p;
    protected long[] PRIMEp1x64;
    protected long[] Alice_order;
    protected long[] Bob_order;
    protected long[] A_gen;
    protected long[] B_gen;
    protected long[] Montgomery_R2;
    protected long[] Montgomery_one;
    protected int[] strat_Alice;
    protected int[] strat_Bob;
    protected long[] XQB3;
    protected long[] A_basis_zero;
    protected long[] B_basis_zero;
    protected long[] B_gen_3_tors;
    protected long[] g_R_S_im;
    protected long[] g_phiR_phiS_re;
    protected long[] g_phiR_phiS_im;
    protected long[] Montgomery_R;
    protected long[] Montgomery_RB1;
    protected long[] Montgomery_RB2;
    protected long[] threeinv;
    protected int[] ph2_path;
    protected int[] ph3_path;
    protected long[] u_entang;
    protected long[] u0_entang;
    protected long[][] table_r_qr;
    protected long[][] table_r_qnr;
    protected long[][] table_v_qr;
    protected long[][] table_v_qnr;
    protected long[][][] v_3_torsion;
    protected long[] T_tate3;
    protected long[] T_tate2_firststep_P;
    protected long[] T_tate2_P;
    protected long[] T_tate2_firststep_Q;
    protected long[] T_tate2_Q;
    protected long[] ph2_T;
    protected long[] ph2_T1;
    protected long[] ph2_T2;
    protected long[] ph3_T;
    protected long[] ph3_T1;
    protected long[] ph3_T2;

    Internal() {
    }

    protected static int[] ReadIntsFromProperty(Properties properties, String string, int n) {
        int[] nArray = new int[n];
        String string2 = properties.getProperty(string);
        String[] stringArray = string2.split(",");
        for (int i = 0; i != stringArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    protected static long[] ReadFromProperty(Properties properties, String string, int n) {
        String string2 = properties.getProperty(string);
        string2 = string2.replaceAll(",", "");
        byte[] byArray = Hex.decode(string2);
        long[] lArray = new long[n];
        for (int i = 0; i < byArray.length / 8; ++i) {
            lArray[i] = Pack.bigEndianToLong(byArray, i * 8);
        }
        return lArray;
    }

    protected static long[][] ReadFromProperty(Properties properties, String string, int n, int n2) {
        String string2 = properties.getProperty(string);
        string2 = string2.replaceAll(",", "");
        byte[] byArray = Hex.decode(string2);
        long[][] lArray = new long[n][n2];
        for (int i = 0; i < byArray.length / 8; ++i) {
            int n3 = i / n2;
            int n4 = i % n2;
            lArray[n3][n4] = Pack.bigEndianToLong(byArray, i * 8);
        }
        return lArray;
    }

    protected static long[][][] ReadFromProperty(Properties properties, String string, int n, int n2, int n3) {
        String string2 = properties.getProperty(string);
        string2 = string2.replaceAll(",", "");
        byte[] byArray = Hex.decode(string2);
        long[][][] lArray = new long[n][n2][n3];
        for (int i = 0; i < byArray.length / 8; ++i) {
            int n4 = i / (n2 * n3);
            int n5 = i % (n2 * n3) / n3;
            int n6 = i % n3;
            lArray[n4][n5][n6] = Pack.bigEndianToLong(byArray, i * 8);
        }
        return lArray;
    }
}

