/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.base.util;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.util.StringUtil;

public final class EAnnotations {
    private static final String ANNOTATION_LABEL_PROVIDER = "http://www.eclipse.org/oomph/base/LabelProvider";
    private static final String KEY_IMAGE_BASE_URI = "imageBaseURI";
    private static final String KEY_IMAGE_URI = "imageURI";
    private static final String KEY_TEXT = "text";

    private EAnnotations() {
    }

    private static URI getImageBaseURI(EClass eClass) {
        EPackage ePackage = eClass.getEPackage();
        String uri = EcoreUtil.getAnnotation((EModelElement)ePackage, (String)ANNOTATION_LABEL_PROVIDER, (String)KEY_IMAGE_BASE_URI);
        if (!StringUtil.isEmpty((String)uri)) {
            return URI.createURI((String)uri);
        }
        return null;
    }

    public static URI getImageURI(EClass eClass) {
        String uri = EcoreUtil.getAnnotation((EModelElement)eClass, (String)ANNOTATION_LABEL_PROVIDER, (String)KEY_IMAGE_URI);
        if (!StringUtil.isEmpty((String)uri)) {
            URI imageBaseURI;
            URI imageURI = URI.createURI((String)uri);
            if (imageURI.isRelative() && (imageBaseURI = EAnnotations.getImageBaseURI(eClass)) != null) {
                return imageURI.resolve(imageBaseURI);
            }
            return imageURI;
        }
        URI imageBaseURI = EAnnotations.getImageBaseURI(eClass);
        if (imageBaseURI != null) {
            return imageBaseURI.appendSegment(String.valueOf(eClass.getName()) + ".gif");
        }
        return null;
    }

    public static String getText(EClass eClass) {
        return EcoreUtil.getAnnotation((EModelElement)eClass, (String)ANNOTATION_LABEL_PROVIDER, (String)KEY_TEXT);
    }
}

