/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.internal.WorkbenchMessages;

public class NewContentTypeDialog
extends TitleAreaDialog {
    private String name;
    private IContentTypeManager manager;
    private ControlDecoration decorator;

    protected NewContentTypeDialog(Shell parentShell, IContentTypeManager manager, IContentType parent) {
        super(parentShell);
        this.manager = manager;
        String baseName = this.name = WorkbenchMessages.ContentTypes_newContentTypeDialog_defaultNameNoParent;
        if (parent != null) {
            baseName = this.name = NLS.bind((String)WorkbenchMessages.ContentTypes_newContentTypeDialog_defaultNameWithParent, (Object)parent.getName());
        }
        int suffix = 2;
        while (manager.getContentType(this.name) != null) {
            this.name = String.valueOf(baseName) + " (" + suffix + ')';
            ++suffix;
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(WorkbenchMessages.ContentTypes_newContentTypeDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(parentComposite, 0);
        contents.setLayoutData((Object)new GridData(4, 4, true, true));
        Label nameLabel = new Label(contents, 16384);
        nameLabel.setText(WorkbenchMessages.ContentTypes_newContentTypeDialog_nameLabel);
        Text nameText = new Text(contents, 2052);
        nameText.setText(this.name);
        nameText.addModifyListener(event -> {
            this.name = nameText.getText();
            if (this.validateName()) {
                this.getButton(0).setEnabled(true);
                this.decorator.hide();
            } else {
                this.getButton(0).setEnabled(false);
                this.decorator.show();
            }
        });
        this.decorator = new ControlDecoration((Control)nameText, 16512);
        this.decorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.decorator.setDescriptionText(WorkbenchMessages.ContentTypes_newContentTypeDialog_invalidContentTypeName);
        this.decorator.hide();
        this.setTitle(WorkbenchMessages.ContentTypes_newContentTypeDialog_title);
        this.setMessage(WorkbenchMessages.ContentTypes_newContentTypeDialog_descritption);
        Dialog.applyDialogFont((Control)parentComposite);
        Point defaultMargins = LayoutConstants.getMargins();
        GridLayoutFactory.fillDefaults().numColumns(2).margins(defaultMargins.x, defaultMargins.y).generateLayout(contents);
        return contents;
    }

    private boolean validateName() {
        return this.name.length() > 0 && this.manager.getContentType(this.name) == null;
    }

    public String getName() {
        return this.name;
    }
}

