/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.oomph.internal.ui.AccessUtil;
import org.eclipse.oomph.internal.ui.FlatButton;
import org.eclipse.oomph.internal.ui.ImageHoverButton;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class SimpleInstallerMenuButton
extends Composite {
    public static final String ACCESS_KEY = "menuButton";
    private static final Cursor CURSOR_HAND = UIUtil.getDisplay().getSystemCursor(21);
    private static final int NOTIFICATION_X_OFFSET = 15;
    private static final int NOTIFICATION_Y_OFFSET = -9;
    private final Set<SelectionListener> selectionListeners = new HashSet<SelectionListener>();
    private final Label notificationOverlay;
    private boolean notificationVisible;
    private final FlatButton button;

    public SimpleInstallerMenuButton(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        Composite container = new Composite((Composite)this, 0);
        this.notificationOverlay = new Label(container, 0){

            protected void checkSubclass() {
            }
        };
        this.notificationOverlay.setCursor(CURSOR_HAND);
        Image overlayImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/notification_overlay.png");
        Rectangle overlayImageBounds = overlayImage.getBounds();
        this.notificationOverlay.setImage(overlayImage);
        this.notificationOverlay.addMouseListener((MouseListener)new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void mouseUp(MouseEvent e) {
                Set set = SimpleInstallerMenuButton.this.selectionListeners;
                synchronized (set) {
                    SimpleInstallerMenuButton.this.button.setFocus();
                    SimpleInstallerMenuButton.this.button.notifyListeners(4, new Event());
                }
            }
        });
        int overlayX = SimpleInstallerMenuButton.notNegative(15);
        int overlayY = SimpleInstallerMenuButton.notNegative(-9);
        this.notificationOverlay.setBounds(overlayX, overlayY, overlayImageBounds.width, overlayImageBounds.height);
        this.notificationOverlay.setVisible(false);
        Image buttonImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/menu.png");
        Image buttonHoverImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/menu_hover.png");
        Image buttonDisabledImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/menu_disabled.png");
        this.button = new ImageHoverButton(container, 8, buttonImage, buttonHoverImage, buttonDisabledImage);
        AccessUtil.setKey((Widget)this.button, (Object)ACCESS_KEY);
        this.button.setShowButtonDownState(false);
        int baseX = SimpleInstallerMenuButton.positive(15);
        int baseY = SimpleInstallerMenuButton.positive(-9);
        Rectangle baseBounds = buttonHoverImage.getBounds();
        this.button.setBounds(baseX, baseY, baseBounds.width, baseBounds.height);
        Rectangle unionBounds = this.notificationOverlay.getBounds().union(this.button.getBounds());
        container.setSize(unionBounds.width, unionBounds.height);
        this.setNotificationVisible(false);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.button.setEnabled(enabled);
        this.notificationOverlay.setEnabled(enabled);
    }

    public void setExtensionVisible(boolean visible) {
        if (visible) {
            Image overlayImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/extension_notification_overlay.png");
            this.notificationOverlay.setImage(overlayImage);
            this.notificationOverlay.setToolTipText(Messages.SimpleInstallerMenuButton_Applied_message);
            this.notificationOverlay.setVisible(true);
        } else {
            this.setNotificationVisible(this.notificationVisible);
        }
    }

    public void setNotificationVisible(boolean visible) {
        Image overlayImage = SetupInstallerPlugin.INSTANCE.getSWTImage("simple/notification_overlay.png");
        this.notificationOverlay.setImage(overlayImage);
        this.notificationOverlay.setToolTipText(Messages.SimpleInstallerMenuButton_UpdatesAvailable_message);
        this.notificationOverlay.setVisible(visible);
        this.notificationVisible = visible;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSelectionListener(SelectionListener listener) {
        Set<SelectionListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.add(listener);
        }
        this.button.addSelectionListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectionListener(SelectionListener listener) {
        this.button.removeSelectionListener(listener);
        Set<SelectionListener> set = this.selectionListeners;
        synchronized (set) {
            this.selectionListeners.remove(listener);
        }
    }

    private static int notNegative(int value) {
        return value >= 0 ? value : 0;
    }

    private static int positive(int value) {
        return value >= 0 ? 0 : -value;
    }
}

