/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgElement;
import org.eclipse.nebula.cwt.svg.SvgFragment;
import org.eclipse.nebula.cwt.svg.SvgLoader;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SvgDocument
extends SvgContainer {
    private Map<String, SvgFragment> fragmentMap = new HashMap<String, SvgFragment>(3);

    public static SvgDocument load(InputStream in) {
        return SvgLoader.load(in);
    }

    public static SvgDocument load(String src) {
        return SvgLoader.load(src);
    }

    SvgDocument() {
        super(null, null);
    }

    @Override
    void add(SvgElement element) {
        if (element instanceof SvgFragment) {
            this.elements.add(element);
            this.fragmentMap.put(element.getId(), (SvgFragment)element);
        }
    }

    public void apply(GC gc, Rectangle bounds) {
        for (SvgElement element : this.elements) {
            ((SvgFragment)element).apply(gc, bounds);
        }
    }

    @Override
    public String getDescription() {
        return this.elements.isEmpty() ? null : ((SvgFragment)this.elements.get(0)).getDescription();
    }

    @Override
    public SvgFragment getFragment() {
        return this.elements.isEmpty() ? null : (SvgFragment)this.elements.get(0);
    }

    public SvgFragment getFragment(String id) {
        return this.fragmentMap.get(id);
    }

    public SvgFragment[] getFragments() {
        return this.elements.toArray(new SvgFragment[this.elements.size()]);
    }

    @Override
    public String getTitle() {
        return this.elements.isEmpty() ? null : ((SvgFragment)this.elements.get(0)).getTitle();
    }

    public boolean hasFragment(String id) {
        return this.fragmentMap.containsKey(id);
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }
}

