/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.di.internal.extensions;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.di.extensions.Service;
import org.eclipse.e4.core.di.suppliers.ExtendedObjectSupplier;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import org.osgi.service.log.Logger;
import org.osgi.service.log.LoggerFactory;

@Component(service={ExtendedObjectSupplier.class, EventHandler.class}, property={"dependency.injection.annotation=org.eclipse.e4.core.di.extensions.Service", "event.topics=org/eclipse/e4/core/contexts/IEclipseContext/DISPOSE"})
public class ServiceSupplier
extends ExtendedObjectSupplier
implements EventHandler {
    LoggerFactory factory;
    Logger logger;
    Map<BundleContext, Map<Class<?>, ServiceHandler>> handlerList = new ConcurrentHashMap();

    public Object get(IObjectDescriptor descriptor, IRequestor requestor, boolean track, boolean group) {
        ParameterizedType t;
        Type desiredType = descriptor.getDesiredType();
        Bundle b = FrameworkUtil.getBundle((Class)requestor.getRequestingObjectClass());
        Service qualifier = (Service)descriptor.getQualifier(Service.class);
        if (desiredType instanceof ParameterizedType && ((t = (ParameterizedType)desiredType).getRawType() == Collections.class || t.getRawType() == List.class)) {
            return this.handleCollection(b, t.getActualTypeArguments()[0], requestor, track && qualifier.dynamic(), qualifier);
        }
        return this.handleSingle(b, desiredType, requestor, track && qualifier.dynamic(), qualifier);
    }

    private Object handleSingle(Bundle bundle, Type t, IRequestor requestor, boolean track, Service qualifier) {
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        Class cl = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        Object result = IInjector.NOT_A_VALUE;
        try {
            String filter = qualifier.filterExpression() != null && !qualifier.filterExpression().isEmpty() ? qualifier.filterExpression() : null;
            Object[] serviceReferences = context.getServiceReferences(cl.getName(), filter);
            if (serviceReferences != null) {
                Arrays.sort(serviceReferences);
                if (serviceReferences.length > 0) {
                    result = context.getService((ServiceReference)serviceReferences[serviceReferences.length - 1]);
                }
            }
        }
        catch (InvalidSyntaxException e) {
            this.logError("Invalid filter expression", e);
        }
        if (track) {
            this.trackService(context, cl, requestor);
        }
        return result;
    }

    private List<Object> handleCollection(Bundle bundle, Type t, IRequestor requestor, boolean track, Service qualifier) {
        ArrayList<Object> rv = new ArrayList<Object>();
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            context = FrameworkUtil.getBundle(((Object)((Object)this)).getClass()).getBundleContext();
        }
        Class cl = t instanceof ParameterizedType ? (Class)((ParameterizedType)t).getRawType() : (Class)t;
        try {
            String filter = qualifier.filterExpression() != null && !qualifier.filterExpression().isEmpty() ? qualifier.filterExpression() : null;
            Object[] serviceReferences = context.getServiceReferences(cl.getName(), filter);
            if (serviceReferences != null) {
                Arrays.sort(serviceReferences);
                Object[] objectArray = serviceReferences;
                int n = serviceReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    Object serviceReference = objectArray[n2];
                    rv.add(context.getService((ServiceReference)serviceReference));
                    ++n2;
                }
            }
            Collections.reverse(rv);
            if (track) {
                this.trackService(context, cl, requestor);
            }
        }
        catch (InvalidSyntaxException e) {
            this.logError("Invalid filter expression", e);
        }
        return rv;
    }

    private synchronized void trackService(BundleContext context, Class<?> serviceClass, IRequestor requestor) {
        Map map = this.handlerList.computeIfAbsent(context, k -> new ConcurrentHashMap());
        ServiceHandler handler = map.computeIfAbsent(serviceClass, cl -> {
            ServiceHandler h = new ServiceHandler(this, context, serviceClass);
            context.addServiceListener((ServiceListener)h);
            return h;
        });
        handler.requestors.add(requestor);
    }

    void logError(String message, Throwable e) {
        Logger log = this.logger;
        if (log != null) {
            log.error(message, (Object)e);
        } else {
            e.printStackTrace();
        }
    }

    public void handleEvent(Event event) {
        this.handlerList.forEach((bc, map) -> map.forEach((cl, sh) -> sh.cleanup()));
    }

    @Reference(cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC)
    void setLogger(LoggerFactory factory) {
        this.factory = factory;
        this.logger = factory.getLogger(((Object)((Object)this)).getClass());
    }

    void unsetLogger(LoggerFactory loggerFactory) {
        if (this.factory == loggerFactory) {
            this.factory = null;
            this.logger = null;
        }
    }

    static class ServiceHandler
    implements ServiceListener {
        private final ServiceSupplier supplier;
        final Set<IRequestor> requestors = new HashSet<IRequestor>();
        private final BundleContext bundleContext;
        private final Class<?> serviceType;

        public ServiceHandler(ServiceSupplier supplier, BundleContext bundleContext, Class<?> serviceType) {
            this.supplier = supplier;
            this.bundleContext = bundleContext;
            this.serviceType = serviceType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceChanged(ServiceEvent event) {
            this.cleanup();
            ServiceSupplier serviceSupplier = this.supplier;
            synchronized (serviceSupplier) {
                String[] data;
                String[] stringArray = data = (String[])event.getServiceReference().getProperty("objectClass");
                int n = data.length;
                int n2 = 0;
                while (n2 < n) {
                    String d = stringArray[n2];
                    if (this.serviceType.getName().equals(d)) {
                        this.requestors.forEach(r -> {
                            try {
                                r.resolveArguments(false);
                                r.execute();
                            }
                            catch (InjectionException e) {
                                this.supplier.logError("Injection failed", e);
                            }
                        });
                        break;
                    }
                    ++n2;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            ServiceSupplier serviceSupplier = this.supplier;
            synchronized (serviceSupplier) {
                Predicate<IRequestor> pr = IRequestor::isValid;
                this.requestors.removeIf(pr.negate());
                if (this.requestors.isEmpty()) {
                    Map<Class<?>, ServiceHandler> map = this.supplier.handlerList.get(this.bundleContext);
                    if (map != null) {
                        map.remove(this.serviceType);
                        if (map.isEmpty()) {
                            this.supplier.handlerList.remove(this.bundleContext);
                        }
                    }
                    this.bundleContext.removeServiceListener((ServiceListener)this);
                    return;
                }
            }
        }
    }
}

