/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.internal.core.P2Index;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.p2.internal.ui.RepositoryExplorer;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.SearchField;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public class RepositoryFinderDialog
extends DockableDialog
implements SearchField.FilterHandler,
LocationListener {
    private static final Object INPUT = new Object();
    private static final Object LOADING = new Object(){

        public String toString() {
            return "Loading...";
        }
    };
    private static final int DND_OPERATIONS = 7;
    private static final List<? extends OomphTransferDelegate> DND_DELEGATES = Collections.singletonList(new OomphTransferDelegate.TextTransferDelegate());
    private static final Transfer[] DND_TRANSFERS = new Transfer[]{DND_DELEGATES.get(0).getTransfer()};
    private SearchField searchField;
    private Label statsLabel;
    private TableViewer viewer;
    private P2Index.Repository[] repositories;
    private List<P2Index.Repository> filteredRepositories;
    private P2Index.Repository selectedRepository;

    public RepositoryFinderDialog(IWorkbenchWindow workbenchWindow) {
        super(workbenchWindow);
    }

    public P2Index.Repository getSelectedRepository() {
        return this.selectedRepository;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return P2UIPlugin.INSTANCE.getDialogSettings("RepositoryFinder");
    }

    protected Control createContents(Composite parent) {
        this.getShell().setImage(P2UIPlugin.INSTANCE.getSWTImage("full/obj16/RepositoryList"));
        this.getShell().setText("Eclipse Repository Finder");
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout();
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.widthHint = 800;
        layoutData.heightHint = 600;
        composite.setLayoutData((Object)layoutData);
        RepositoryFinderDialog.applyDialogFont((Control)composite);
        this.initializeDialogUnits((Control)composite);
        int columns = 3;
        Composite content = new Composite(composite, 0);
        content.setLayout((Layout)GridLayoutFactory.fillDefaults().extendedMargins(0, 0, LayoutConstants.getSpacing().y, 0).numColumns(columns).create());
        Label filterLabel = new Label(content, 0);
        filterLabel.setLayoutData((Object)GridDataFactory.fillDefaults().indent(LayoutConstants.getSpacing().x, 0).align(1, 0x1000000).create());
        filterLabel.setText("Filter:");
        this.searchField = new SearchField(content, this){

            protected void finishFilter() {
                if (RepositoryFinderDialog.this.repositories == null) {
                    RepositoryFinderDialog.this.viewer.setSelection((ISelection)new StructuredSelection(LOADING), true);
                } else if (RepositoryFinderDialog.this.filteredRepositories != null) {
                    if (RepositoryFinderDialog.this.filteredRepositories.isEmpty()) {
                        return;
                    }
                    RepositoryFinderDialog.this.viewer.setSelection((ISelection)new StructuredSelection(RepositoryFinderDialog.this.filteredRepositories.get(0)), true);
                } else if (RepositoryFinderDialog.this.filteredRepositories != null) {
                    if (RepositoryFinderDialog.this.repositories.length == 0) {
                        return;
                    }
                    RepositoryFinderDialog.this.viewer.setSelection((ISelection)new StructuredSelection((Object)RepositoryFinderDialog.this.repositories[0]), true);
                }
                RepositoryFinderDialog.this.viewer.getControl().setFocus();
            }
        };
        this.searchField.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.searchField.getFilterControl().setToolTipText("Filter text may use * to match any characters or ? to match one character");
        this.searchField.setFocus();
        this.searchField.setInitialText("");
        this.statsLabel = new Label(content, 0);
        this.statsLabel.setLayoutData((Object)GridDataFactory.fillDefaults().align(1, 0x1000000).create());
        this.statsLabel.setText("000000000 repositories");
        this.statsLabel.setVisible(false);
        Composite viewerComposite = new Composite(content, 0);
        viewerComposite.setLayoutData((Object)GridDataFactory.fillDefaults().span(columns, 1).grab(true, true).create());
        viewerComposite.setLayout((Layout)GridLayoutFactory.fillDefaults().spacing(0, 0).create());
        Label ruler = new Label(viewerComposite, 258);
        ruler.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        this.viewer = new TableViewer(viewerComposite, 0x10000002);
        this.viewer.getControl().setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        this.viewer.getControl().setEnabled(false);
        this.viewer.setUseHashlookup(true);
        this.viewer.setContentProvider((IContentProvider)new FinderContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new FinderLabelProvider());
        this.viewer.setInput(INPUT);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = event.getStructuredSelection();
                Object element = selection.getFirstElement();
                if (element instanceof P2Index.Repository) {
                    RepositoryFinderDialog.this.selectedRepository = (P2Index.Repository)element;
                } else {
                    RepositoryFinderDialog.this.selectedRepository = null;
                }
            }
        });
        GeneralDragAdapter dragAdapter = new GeneralDragAdapter((Viewer)this.viewer, new GeneralDragAdapter.DraggedObjectsFactory(){

            public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                ArrayList<Object> result = new ArrayList<Object>();
                Object[] objectArray = ((IStructuredSelection)selection).toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof P2Index.Repository) {
                        P2Index.Repository repository = (P2Index.Repository)object;
                        result.add(P2Factory.eINSTANCE.createRepository(repository.getLocation().toString()));
                    }
                    ++n2;
                }
                return result;
            }
        }, DND_DELEGATES);
        this.viewer.addDragSupport(7, DND_TRANSFERS, (DragSourceListener)dragAdapter);
        dragAdapter.getContextMenu().addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                String url = RepositoryFinderDialog.getURL(RepositoryFinderDialog.this.viewer.getSelection());
                if (url != null) {
                    manager.add((IAction)new ExplorerAction(url));
                }
            }
        });
        this.viewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                String url = RepositoryFinderDialog.getURL(event.getSelection());
                if (url != null) {
                    RepositoryExplorer.explore(url);
                }
            }
        });
        new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.viewer, (LocationListener)this);
        this.loadRepositories();
        return composite;
    }

    public void handleFilter(String filter) {
        if (this.repositories == null) {
            this.viewer.setItemCount(1);
        } else if (filter == null || filter.length() == 0) {
            this.filteredRepositories = null;
            this.setStats(this.repositories.length);
            this.viewer.setItemCount(this.repositories.length);
        } else {
            Pattern pattern = StringUtil.globPattern((String)filter);
            ArrayList<P2Index.Repository> list = new ArrayList<P2Index.Repository>();
            P2Index.Repository[] repositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository repository = repositoryArray[n2];
                String url = repository.getLocation().toString();
                if (pattern.matcher(url).find()) {
                    list.add(repository);
                }
                ++n2;
            }
            this.filteredRepositories = list;
            this.setStats(this.filteredRepositories.size());
            this.statsLabel.setText(String.valueOf(this.filteredRepositories.size()) + " repositories");
            this.viewer.setItemCount(this.filteredRepositories.size());
        }
        this.viewer.refresh();
    }

    public boolean handleWorkbenchPart(IWorkbenchPart part) {
        return true;
    }

    public void changing(LocationEvent event) {
        if (this.repositories != null) {
            P2Index.Repository[] repositoryArray = this.repositories;
            int n = this.repositories.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository repository = repositoryArray[n2];
                if (repository.getLocation().toString().equals(event.location)) {
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)repository), true);
                    this.viewer.getControl().setFocus();
                    break;
                }
                ++n2;
            }
        }
    }

    public void changed(LocationEvent event) {
    }

    private void loadRepositories() {
        new Job("Loading repositories"){

            protected IStatus run(IProgressMonitor monitor) {
                RepositoryFinderDialog.this.repositories = P2Index.INSTANCE.getRepositories();
                if (RepositoryFinderDialog.this.repositories == null) {
                    RepositoryFinderDialog.this.repositories = new P2Index.Repository[0];
                }
                Arrays.sort(RepositoryFinderDialog.this.repositories);
                UIUtil.asyncExec((Control)RepositoryFinderDialog.this.statsLabel, (Runnable)new Runnable(){

                    public void run() {
                        RepositoryFinderDialog.this.setStats(RepositoryFinderDialog.this.repositories.length);
                        RepositoryFinderDialog.this.viewer.setItemCount(RepositoryFinderDialog.this.repositories.length);
                        RepositoryFinderDialog.this.viewer.refresh();
                        RepositoryFinderDialog.this.viewer.getControl().setEnabled(true);
                    }
                });
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void setStats(int repositories) {
        this.statsLabel.setText(String.valueOf(repositories) + " repositories");
        this.statsLabel.setVisible(true);
    }

    private void appendToolTipText(P2Index.Repository repository, StringBuilder builder) {
        P2Index.Repository[] composites;
        int n;
        builder.append("<h3>");
        builder.append(repository.isComposed() ? "Composite" : "Simple");
        builder.append("&nbsp;Repository&nbsp;<span style=\"white-space: nowrap;\">");
        builder.append(repository);
        builder.append("</span></h3><ul>");
        builder.append("<li><span style=\"white-space: nowrap;\">");
        builder.append(new Date(repository.getTimestamp()));
        builder.append("</span>&nbsp;(");
        builder.append(repository.getTimestamp());
        builder.append(")");
        builder.append("<li>");
        builder.append(repository.getCapabilityCount());
        builder.append(repository.getCapabilityCount() == 1 ? "&nbsp;capability" : "&nbsp;capabilities");
        if (repository.getUnresolvedChildren() != 0) {
            builder.append("<li><font color=\"#ff0000\"><b>");
            builder.append(repository.getUnresolvedChildren());
            builder.append("&nbsp;unresolved&nbsp;");
            builder.append(repository.getUnresolvedChildren() == 1 ? "child" : "children");
            builder.append("!</b></font>");
        }
        if (repository.isCompressed()) {
            builder.append("<li>Compressed");
        }
        builder.append("</ul>");
        P2Index.Repository[] children = repository.getChildren();
        if (children != null && children.length != 0) {
            builder.append("<h3>Children</h3>");
            builder.append("<ul>");
            P2Index.Repository[] repositoryArray = children;
            n = children.length;
            int n2 = 0;
            while (n2 < n) {
                P2Index.Repository child = repositoryArray[n2];
                builder.append("<li><a href=\"");
                builder.append(child);
                builder.append("\"><span style=\"white-space: nowrap;\">");
                builder.append(child);
                builder.append("</span></a>");
                ++n2;
            }
            builder.append("</ul>");
        }
        if ((composites = repository.getComposites()) != null && composites.length != 0) {
            builder.append("<h3>Composites</h3>");
            builder.append("<ul>");
            P2Index.Repository[] repositoryArray = composites;
            int n3 = composites.length;
            n = 0;
            while (n < n3) {
                P2Index.Repository composite = repositoryArray[n];
                builder.append("<li><a href=\"");
                builder.append(composite);
                builder.append("\"><span style=\"white-space: nowrap;\">");
                builder.append(composite);
                builder.append("</span></a>");
                ++n;
            }
            builder.append("</ul>");
        }
    }

    private static String getURL(ISelection selection) {
        for (Object object : (IStructuredSelection)selection) {
            if (!(object instanceof P2Index.Repository)) continue;
            P2Index.Repository repository = (P2Index.Repository)object;
            return repository.getLocation().toString();
        }
        return null;
    }

    public static RepositoryFinderDialog getFor(IWorkbenchWindow workbenchWindow) {
        return (RepositoryFinderDialog)DockableDialog.getFor(RepositoryFinderDialog.class, (IWorkbenchWindow)workbenchWindow);
    }

    public static void closeFor(IWorkbenchWindow workbenchWindow) {
        DockableDialog.closeFor(RepositoryFinderDialog.class, (IWorkbenchWindow)workbenchWindow);
    }

    public static RepositoryFinderDialog openFor(IWorkbenchWindow workbenchWindow) {
        DockableDialog.Factory<RepositoryFinderDialog> factory = new DockableDialog.Factory<RepositoryFinderDialog>(){

            public RepositoryFinderDialog create(IWorkbenchWindow workbenchWindow) {
                return new RepositoryFinderDialog(workbenchWindow);
            }
        };
        return (RepositoryFinderDialog)DockableDialog.openFor(RepositoryFinderDialog.class, (DockableDialog.Factory)factory, (IWorkbenchWindow)workbenchWindow);
    }

    private final class ExplorerAction
    extends Action {
        private final String url;

        public ExplorerAction(String url) {
            super("Explore", P2UIPlugin.INSTANCE.getImageDescriptor("full/obj16/Repository"));
            this.url = url;
        }

        public void run() {
            RepositoryExplorer.explore(this.url);
        }
    }

    private final class FinderContentProvider
    implements ILazyContentProvider {
        public FinderContentProvider() {
            RepositoryFinderDialog.this.viewer.setItemCount(1);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void updateElement(int index) {
            if (RepositoryFinderDialog.this.filteredRepositories != null) {
                RepositoryFinderDialog.this.viewer.replace(RepositoryFinderDialog.this.filteredRepositories.get(index), index);
            } else if (RepositoryFinderDialog.this.repositories != null) {
                RepositoryFinderDialog.this.viewer.replace((Object)RepositoryFinderDialog.this.repositories[index], index);
            } else {
                RepositoryFinderDialog.this.viewer.replace(LOADING, index);
            }
        }

        public void dispose() {
        }
    }

    private final class FinderLabelProvider
    extends ColumnLabelProvider {
        private final Font baseFont;
        private final Font boldFont;
        private final Color redColor;
        private final Color grayColor;

        private FinderLabelProvider() {
            this.baseFont = RepositoryFinderDialog.this.viewer.getControl().getFont();
            this.boldFont = P2UIPlugin.getBoldFont((Font)this.baseFont);
            this.redColor = RepositoryFinderDialog.this.viewer.getControl().getDisplay().getSystemColor(3);
            this.grayColor = RepositoryFinderDialog.this.viewer.getControl().getDisplay().getSystemColor(15);
        }

        public Image getImage(Object element) {
            if (element instanceof P2Index.Repository) {
                P2Index.Repository repository = (P2Index.Repository)element;
                if (repository.isComposed()) {
                    return P2UIPlugin.INSTANCE.getSWTImage("obj16/compositeRepository.png");
                }
                return P2UIPlugin.INSTANCE.getSWTImage("full/obj16/Repository");
            }
            return super.getImage(element);
        }

        public Font getFont(Object element) {
            P2Index.Repository repository;
            if (element instanceof P2Index.Repository && (repository = (P2Index.Repository)element).isComposed()) {
                return this.boldFont;
            }
            return super.getFont(element);
        }

        public Color getForeground(Object element) {
            if (element instanceof P2Index.Repository) {
                P2Index.Repository repository = (P2Index.Repository)element;
                if (repository.getUnresolvedChildren() != 0) {
                    return this.redColor;
                }
                if (repository.getCapabilityCount() == 0) {
                    return this.grayColor;
                }
            }
            return super.getForeground(element);
        }

        public String getToolTipText(Object element) {
            if (element instanceof P2Index.Repository) {
                P2Index.Repository repository = (P2Index.Repository)element;
                StringBuilder builder = new StringBuilder();
                RepositoryFinderDialog.this.appendToolTipText(repository, builder);
                return builder.toString();
            }
            return null;
        }
    }
}

