/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.preferences.impl;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.preferences.PreferenceNode;
import org.eclipse.oomph.preferences.PreferencesPackage;
import org.eclipse.oomph.preferences.Property;
import org.eclipse.oomph.preferences.impl.PreferenceItemImpl;
import org.eclipse.oomph.preferences.util.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyImpl
extends PreferenceItemImpl
implements Property {
    protected static final String VALUE_EDEFAULT = null;
    protected String value = VALUE_EDEFAULT;
    protected static final boolean NON_DEFAULT_EDEFAULT = false;
    protected static final boolean SECURE_EDEFAULT = false;
    protected boolean secure = false;

    protected PropertyImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return PreferencesPackage.Literals.PROPERTY;
    }

    @Override
    public PreferenceNode getParent() {
        if (this.eContainerFeatureID() != 7) {
            return null;
        }
        return (PreferenceNode)this.eInternalContainer();
    }

    public NotificationChain basicSetParent(PreferenceNode newParent, NotificationChain msgs) {
        msgs = this.eBasicSetContainer((InternalEObject)newParent, 7, msgs);
        return msgs;
    }

    @Override
    public void setParent(PreferenceNode newParent) {
        if (newParent != this.eInternalContainer() || this.eContainerFeatureID() != 7 && newParent != null) {
            if (EcoreUtil.isAncestor((EObject)this, (EObject)newParent)) {
                throw new IllegalArgumentException("Recursive containment not allowed for " + this.toString());
            }
            NotificationChain msgs = null;
            if (this.eInternalContainer() != null) {
                msgs = this.eBasicRemoveFromContainer(msgs);
            }
            if (newParent != null) {
                msgs = ((InternalEObject)newParent).eInverseAdd((InternalEObject)this, 9, PreferenceNode.class, msgs);
            }
            if ((msgs = this.basicSetParent(newParent, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 7, (Object)newParent, (Object)newParent));
        }
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public String getSecureValue() {
        return this.isSecure() ? PreferencesUtil.decrypt(this.getValue()) : this.getValue();
    }

    @Override
    public void setValue(String newValue) {
        if (this.isSecure()) {
            newValue = PreferencesUtil.encrypt(newValue);
        }
        String oldValue = this.value;
        this.value = newValue;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldValue, (Object)this.value));
        }
    }

    @Override
    public boolean isNonDefault() {
        Property ancestor = this.getAncestor();
        if (ancestor != null) {
            String ancestorValue = ancestor.getValue();
            String value = this.getValue();
            return value == null ? ancestorValue != null : !value.equals(ancestorValue);
        }
        return true;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean newSecure) {
        boolean oldSecure = this.secure;
        this.secure = newSecure;
        if (oldSecure != newSecure) {
            String oldValue = this.value;
            String string = this.value = this.secure ? PreferencesUtil.encrypt(oldValue) : PreferencesUtil.decrypt(oldValue);
            if (this.eNotificationRequired()) {
                this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, (Object)oldValue, (Object)this.value));
            }
        }
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, oldSecure, this.secure));
        }
    }

    @Override
    public Property getAncestor() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        PreferenceNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        PreferenceNode preferenceNode = parent.getAncestor();
        while (preferenceNode != null) {
            Property property = preferenceNode.getProperty(name);
            if (property != null) {
                return property;
            }
            preferenceNode = preferenceNode.getAncestor();
        }
        return null;
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                if (this.eInternalContainer() != null) {
                    msgs = this.eBasicRemoveFromContainer(msgs);
                }
                return this.basicSetParent((PreferenceNode)otherEnd, msgs);
            }
        }
        return super.eInverseAdd(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 7: {
                return this.basicSetParent(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs) {
        switch (this.eContainerFeatureID()) {
            case 7: {
                return this.eInternalContainer().eInverseRemove((InternalEObject)this, 9, PreferenceNode.class, msgs);
            }
        }
        return super.eBasicRemoveFromContainerFeature(msgs);
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 7: {
                return this.getParent();
            }
            case 8: {
                return this.getValue();
            }
            case 9: {
                return this.isNonDefault();
            }
            case 10: {
                return this.isSecure();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 7: {
                this.setParent((PreferenceNode)newValue);
                return;
            }
            case 8: {
                this.setValue((String)newValue);
                return;
            }
            case 10: {
                this.setSecure((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 7: {
                this.setParent(null);
                return;
            }
            case 8: {
                this.setValue(VALUE_EDEFAULT);
                return;
            }
            case 10: {
                this.setSecure(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 7: {
                return this.getParent() != null;
            }
            case 8: {
                return VALUE_EDEFAULT == null ? this.value != null : !VALUE_EDEFAULT.equals(this.value);
            }
            case 9: {
                return this.isNonDefault();
            }
            case 10: {
                return this.secure;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 2: {
                return this.getAncestor();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (value: ");
        result.append(this.value);
        result.append(", secure: ");
        result.append(this.secure);
        result.append(')');
        return result.toString();
    }

    @Override
    public URI getAbsolutePath() {
        String name = this.getName();
        if (name == null) {
            return null;
        }
        PreferenceNode parent = this.getParent();
        if (parent == null) {
            return URI.createHierarchicalURI(null, null, null, (String[])new String[]{URI.encodeSegment((String)name, (boolean)false)}, null, null);
        }
        URI parentAbsolutePath = parent.getAbsolutePath();
        if (parentAbsolutePath == null) {
            return null;
        }
        return parentAbsolutePath.appendSegment(URI.encodeSegment((String)name, (boolean)false));
    }

    @Override
    public URI getRelativePath() {
        PreferenceNode parent = this.getParent();
        if (parent == null) {
            return null;
        }
        URI parentRelativePath = parent.getRelativePath();
        if (parentRelativePath == null) {
            return null;
        }
        return parentRelativePath.appendSegment(URI.encodeSegment((String)this.name, (boolean)false));
    }

    @Override
    public PreferenceNode getScope() {
        PreferenceNode parent = this.getParent();
        if (parent != null) {
            return parent.getScope();
        }
        return null;
    }
}

