/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.internal.views.markers.DescriptionConfigurationArea;
import org.eclipse.ui.internal.views.markers.SeverityAndDescriptionFieldFilter;
import org.eclipse.ui.views.markers.MarkerFieldFilter;
import org.eclipse.ui.views.markers.internal.MarkerMessages;

public class SeverityAndDescriptionConfigurationArea
extends DescriptionConfigurationArea {
    private int severities;
    private Button infoButton;
    private Button errorButton;
    private Button warningButton;
    private Label label;

    @Override
    public void apply(MarkerFieldFilter filter) {
        super.apply(filter);
        ((SeverityAndDescriptionFieldFilter)filter).selectedSeverities = this.severities;
    }

    Composite createSeverityGroup(Composite parent) {
        Composite severityComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(4, false);
        layout.horizontalSpacing = 4;
        severityComposite.setLayout((Layout)layout);
        severityComposite.setLayoutData((Object)new GridData(768));
        this.label = new Label(severityComposite, 0);
        this.label.setText(MarkerMessages.filtersDialog_severityLabel);
        this.errorButton = new Button(severityComposite, 32);
        this.errorButton.setText(MarkerMessages.filtersDialog_severityError);
        this.errorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(4, SeverityAndDescriptionConfigurationArea.this.errorButton.getSelection());
            }
        });
        GridData data = new GridData();
        data.horizontalIndent = 4;
        this.errorButton.setLayoutData((Object)data);
        this.warningButton = new Button(severityComposite, 32);
        this.warningButton.setText(MarkerMessages.filtersDialog_severityWarning);
        this.warningButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(2, SeverityAndDescriptionConfigurationArea.this.warningButton.getSelection());
            }
        });
        this.infoButton = new Button(severityComposite, 32);
        this.infoButton.setText(MarkerMessages.filtersDialog_severityInfo);
        this.infoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeverityAndDescriptionConfigurationArea.this.updateSeverities(1, SeverityAndDescriptionConfigurationArea.this.infoButton.getSelection());
            }
        });
        return severityComposite;
    }

    @Override
    public void initialize(MarkerFieldFilter filter) {
        super.initialize(filter);
        SeverityAndDescriptionFieldFilter sevFilter = (SeverityAndDescriptionFieldFilter)filter;
        this.severities = sevFilter.selectedSeverities;
        this.infoButton.setSelection((1 & this.severities) > 0);
        this.warningButton.setSelection((2 & this.severities) > 0);
        this.errorButton.setSelection((4 & this.severities) > 0);
    }

    private void updateSeverities(int constant, boolean enabled) {
        this.severities = enabled ? constant | this.severities : constant ^ this.severities;
    }

    void setSeverityButtonsEnabled(boolean enabled) {
        this.label.setEnabled(enabled);
        this.errorButton.setEnabled(enabled);
        this.infoButton.setEnabled(enabled);
        this.warningButton.setEnabled(enabled);
    }
}

