/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.internal.util.table;

import java.text.Format;
import java.util.Iterator;
import org.eclipse.oomph.internal.util.table.AbstractRange;
import org.eclipse.oomph.internal.util.table.Cell;
import org.eclipse.oomph.internal.util.table.Coordinate;
import org.eclipse.oomph.internal.util.table.Range;
import org.eclipse.oomph.internal.util.table.Table;
import org.eclipse.oomph.util.AbstractIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RectangularRange
extends AbstractRange {
    final Table table;
    Coordinate topLeft;
    Coordinate bottomRight;

    RectangularRange(Table table, Coordinate coordinate1, Coordinate coordinate2) {
        int col2;
        int col1;
        int row2;
        int row1;
        this.table = table;
        if (coordinate1.row <= coordinate2.row) {
            row1 = coordinate1.row;
            row2 = coordinate2.row;
        } else {
            row1 = coordinate2.row;
            row2 = coordinate1.row;
        }
        if (coordinate1.col <= coordinate2.col) {
            col1 = coordinate1.col;
            col2 = coordinate2.col;
        } else {
            col1 = coordinate2.col;
            col2 = coordinate1.col;
        }
        this.topLeft = new Coordinate(col1, row1);
        this.bottomRight = new Coordinate(col2, row2);
        if (table != null) {
            table.cell(this.bottomRight);
        }
    }

    @Override
    public Table table() {
        return this.table;
    }

    public Coordinate topLeft() {
        return this.topLeft;
    }

    public Coordinate bottomRight() {
        return this.bottomRight;
    }

    public int cols() {
        return this.bottomRight.col - this.topLeft.col + 1;
    }

    public int rows() {
        return this.bottomRight.row - this.topLeft.row + 1;
    }

    @Override
    public boolean contains(int col, int row) {
        return this.topLeft.col <= col && col <= this.bottomRight.col && this.topLeft.row <= row && row <= this.bottomRight.row;
    }

    @Override
    public boolean contains(Range range) {
        if (range instanceof RectangularRange) {
            RectangularRange rect = (RectangularRange)range;
            return this.topLeft.col <= rect.topLeft.col && rect.bottomRight.col <= this.bottomRight.col && this.topLeft.row <= rect.topLeft.row && rect.bottomRight.row <= this.bottomRight.row;
        }
        return super.contains(range);
    }

    @Override
    public Iterator<Cell> iterator() {
        return new CellIterator();
    }

    @Override
    public RectangularRange value(Object value) {
        return (RectangularRange)super.value(value);
    }

    @Override
    public RectangularRange format(Format format) {
        return (RectangularRange)super.format(format);
    }

    @Override
    public RectangularRange alignment(Range.Alignment alignment) {
        return (RectangularRange)super.alignment(alignment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CellIterator
    extends AbstractIterator<Cell> {
        private int col;
        private int row;

        private CellIterator() {
            this.col = RectangularRange.this.topLeft.col;
            this.row = RectangularRange.this.topLeft.row;
        }

        @Override
        protected Object computeNextElement() {
            try {
                if (this.col > RectangularRange.this.bottomRight.col) {
                    if (++this.row > RectangularRange.this.bottomRight.row) {
                        Object object = END_OF_DATA;
                        return object;
                    }
                    this.col = RectangularRange.this.topLeft.col;
                }
                Cell cell = RectangularRange.this.table().cell(this.col, this.row);
                return cell;
            }
            finally {
                ++this.col;
            }
        }
    }
}

