/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.filetransfer.retrieve;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.Map;
import org.eclipse.core.net.proxy.IProxyData;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.identity.IDFactory;
import org.eclipse.ecf.core.identity.Namespace;
import org.eclipse.ecf.core.security.IConnectContext;
import org.eclipse.ecf.core.util.Proxy;
import org.eclipse.ecf.filetransfer.FileTransferJob;
import org.eclipse.ecf.filetransfer.IFileRangeSpecification;
import org.eclipse.ecf.filetransfer.IFileTransfer;
import org.eclipse.ecf.filetransfer.IFileTransferListener;
import org.eclipse.ecf.filetransfer.IFileTransferPausable;
import org.eclipse.ecf.filetransfer.IFileTransferRunnable;
import org.eclipse.ecf.filetransfer.IIncomingFileTransfer;
import org.eclipse.ecf.filetransfer.IRetrieveFileTransferOptions;
import org.eclipse.ecf.filetransfer.IncomingFileTransferException;
import org.eclipse.ecf.filetransfer.UserCancelledException;
import org.eclipse.ecf.filetransfer.events.IFileTransferEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDataEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveDoneEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceivePausedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveResumedEvent;
import org.eclipse.ecf.filetransfer.events.IIncomingFileTransferReceiveStartEvent;
import org.eclipse.ecf.filetransfer.identity.IFileID;
import org.eclipse.ecf.filetransfer.service.IRetrieveFileTransfer;
import org.eclipse.ecf.internal.provider.filetransfer.Activator;
import org.eclipse.ecf.internal.provider.filetransfer.Messages;
import org.eclipse.ecf.provider.filetransfer.identity.FileTransferNamespace;
import org.eclipse.ecf.provider.filetransfer.util.PollingInputStream;
import org.eclipse.ecf.provider.filetransfer.util.ProxySetupHelper;
import org.eclipse.ecf.provider.filetransfer.util.TimeoutInputStream;
import org.eclipse.osgi.util.NLS;

public abstract class AbstractRetrieveFileTransfer
implements IIncomingFileTransfer,
IRetrieveFileTransfer,
IFileTransferPausable {
    public static final int DEFAULT_BUF_LENGTH = 4096;
    protected static final int POLLING_RETRY_ATTEMPTS = new Integer(System.getProperty("org.eclipse.ecf.provider.filetransfer.retrieve.retryAttempts", "30"));
    protected static final int TIMEOUT_INPUTSTREAM_BUFFER_SIZE = 8192;
    protected static final int READ_TIMEOUT = new Integer(System.getProperty("org.eclipse.ecf.provider.filetransfer.retrieve.readTimeout", "1000"));
    protected static final int CLOSE_TIMEOUT = new Integer(System.getProperty("org.eclipse.ecf.provider.filetransfer.retrieve.closeTimeout", "1000"));
    private static final String readTimeoutMessage = "Timeout while reading input stream.\nThe following system properties can be used to adjust the readTimeout, retryAttempts, and closeTimeout\n\torg.eclipse.ecf.provider.filetransfer.retrieve.readTimeout=<default:1000>\n\torg.eclipse.ecf.provider.filetransfer.retrieve.retryAttempts=<default:30>\n\torg.eclipse.ecf.provider.filetransfer.retrieve.closeTimeout=<default:1000>\n";
    private static final String closeTimeoutMessage = "Timeout while closing input stream.\nThe following system properties can be used to adjust the readTimeout, retryAttempts, and closeTimeout\n\torg.eclipse.ecf.provider.filetransfer.retrieve.readTimeout=<default:1000>\n\torg.eclipse.ecf.provider.filetransfer.retrieve.retryAttempts=<default:30>\n\torg.eclipse.ecf.provider.filetransfer.retrieve.closeTimeout=<default:1000>\n";
    protected Object jobLock = new Object();
    protected Job job;
    protected URL remoteFileURL;
    protected IFileID remoteFileID;
    protected IFileTransferListener listener;
    protected int buff_length = 4096;
    protected boolean done = false;
    protected volatile long bytesReceived = 0L;
    protected InputStream remoteFileContents;
    protected OutputStream localFileContents;
    protected boolean closeOutputStream = true;
    protected Exception exception;
    protected long fileLength = -1L;
    protected long lastModifiedTime = 0L;
    protected Map options = null;
    protected boolean paused = false;
    protected IFileRangeSpecification rangeSpecification = null;
    protected Proxy proxy;
    protected IConnectContext connectContext;
    protected long transferStartTime;
    protected double downloadRateBytesPerSecond = 0.0;
    protected Map responseHeaders;
    private IFileTransferRunnable fileTransferRunnable = new IFileTransferRunnable(){

        public IStatus performFileTransfer(IProgressMonitor monitor) {
            block32: {
                Activator a;
                block35: {
                    AbstractRetrieveFileTransfer.this.transferStartTime = System.currentTimeMillis();
                    byte[] buf = new byte[AbstractRetrieveFileTransfer.this.buff_length];
                    long totalWork = AbstractRetrieveFileTransfer.this.fileLength == -1L ? 100L : AbstractRetrieveFileTransfer.this.fileLength;
                    double factor = totalWork > Integer.MAX_VALUE ? 2.147483647E9 / (double)totalWork : 1.0;
                    int work = totalWork > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)totalWork;
                    monitor.beginTask(String.valueOf(AbstractRetrieveFileTransfer.this.getRemoteFileURL().toString()) + Messages.AbstractRetrieveFileTransfer_Progress_Data, work);
                    InputStream readInputStream = null;
                    try {
                        try {
                            if (AbstractRetrieveFileTransfer.this.remoteFileContents == null) {
                                throw new IOException("input stream cannot be null");
                            }
                            readInputStream = AbstractRetrieveFileTransfer.this.wrapTransferReadInputStream(AbstractRetrieveFileTransfer.this.remoteFileContents, monitor);
                            while (!AbstractRetrieveFileTransfer.this.isDone() && !AbstractRetrieveFileTransfer.this.isPaused()) {
                                try {
                                    int bytes = readInputStream.read(buf);
                                    AbstractRetrieveFileTransfer.this.handleReceivedData(buf, bytes, factor, monitor);
                                }
                                catch (OperationCanceledException e) {
                                    throw new UserCancelledException(Messages.AbstractRetrieveFileTransfer_Exception_User_Cancelled);
                                }
                            }
                        }
                        catch (Exception e) {
                            Activator a2;
                            block31: {
                                if (!AbstractRetrieveFileTransfer.this.isDone()) {
                                    AbstractRetrieveFileTransfer.this.setDoneException(e);
                                }
                                try {
                                    if (readInputStream != null) {
                                        readInputStream.close();
                                    }
                                }
                                catch (IOException e2) {
                                    a2 = Activator.getDefault();
                                    if (a2 == null) break block31;
                                    a2.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e2));
                                }
                            }
                            AbstractRetrieveFileTransfer.this.hardClose();
                            monitor.done();
                            try {
                                if (AbstractRetrieveFileTransfer.this.isPaused()) {
                                    AbstractRetrieveFileTransfer.this.fireTransferReceivePausedEvent();
                                    break block32;
                                }
                                AbstractRetrieveFileTransfer.this.fireTransferReceiveDoneEvent();
                            }
                            catch (Exception e3) {
                                a2 = Activator.getDefault();
                                if (a2 != null) {
                                    a2.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, Messages.AbstractRetrieveFileTransfer_EXCEPTION_IN_FINALLY, (Throwable)e3));
                                }
                                break block32;
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        block34: {
                            Activator a3;
                            block33: {
                                try {
                                    if (readInputStream != null) {
                                        readInputStream.close();
                                    }
                                }
                                catch (IOException e) {
                                    a3 = Activator.getDefault();
                                    if (a3 == null) break block33;
                                    a3.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
                                }
                            }
                            AbstractRetrieveFileTransfer.this.hardClose();
                            monitor.done();
                            try {
                                if (AbstractRetrieveFileTransfer.this.isPaused()) {
                                    AbstractRetrieveFileTransfer.this.fireTransferReceivePausedEvent();
                                } else {
                                    AbstractRetrieveFileTransfer.this.fireTransferReceiveDoneEvent();
                                }
                            }
                            catch (Exception e) {
                                a3 = Activator.getDefault();
                                if (a3 == null) break block34;
                                a3.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, Messages.AbstractRetrieveFileTransfer_EXCEPTION_IN_FINALLY, (Throwable)e));
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (readInputStream != null) {
                            readInputStream.close();
                        }
                    }
                    catch (IOException e) {
                        a = Activator.getDefault();
                        if (a == null) break block35;
                        a.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
                    }
                }
                AbstractRetrieveFileTransfer.this.hardClose();
                monitor.done();
                try {
                    if (AbstractRetrieveFileTransfer.this.isPaused()) {
                        AbstractRetrieveFileTransfer.this.fireTransferReceivePausedEvent();
                    } else {
                        AbstractRetrieveFileTransfer.this.fireTransferReceiveDoneEvent();
                    }
                }
                catch (Exception e) {
                    a = Activator.getDefault();
                    if (a == null) break block32;
                    a.log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, Messages.AbstractRetrieveFileTransfer_EXCEPTION_IN_FINALLY, (Throwable)e));
                }
            }
            return AbstractRetrieveFileTransfer.this.getFinalStatus(AbstractRetrieveFileTransfer.this.exception);
        }
    };

    protected InputStream wrapTransferReadInputStream(InputStream inputStream, IProgressMonitor monitor) {
        return new PollingInputStream(inputStream, this.getRetryAttempts(), monitor, readTimeoutMessage, closeTimeoutMessage);
    }

    private int getRetryAttempts() {
        Object o;
        int result = POLLING_RETRY_ATTEMPTS;
        Map localOptions = this.getOptions();
        if (localOptions != null && (o = localOptions.get("org.eclipse.ecf.provider.filetransfer.retrieve.retryAttempts")) != null) {
            if (o instanceof Integer) {
                result = (Integer)o;
            } else if (o instanceof String) {
                result = new Integer((String)o);
            }
        }
        return result;
    }

    protected URL getRemoteFileURL() {
        return this.remoteFileURL;
    }

    protected int getSocketReadTimeout() {
        int result = READ_TIMEOUT;
        Map localOptions = this.getOptions();
        if (localOptions != null) {
            Object o = localOptions.get(IRetrieveFileTransferOptions.READ_TIMEOUT);
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
                return result;
            }
            o = localOptions.get("org.eclipse.ecf.provider.filetransfer.httpclient.retrieve.readTimeout");
            if (o != null) {
                if (o instanceof Integer) {
                    result = (Integer)o;
                } else if (o instanceof String) {
                    result = new Integer((String)o);
                }
            }
        }
        return result;
    }

    protected int getSocketCloseTimeout() {
        Object o;
        int result = CLOSE_TIMEOUT;
        Map localOptions = this.getOptions();
        if (localOptions != null && (o = localOptions.get("org.eclipse.ecf.provider.filetransfer.retrieve.closeTimeout")) != null) {
            if (o instanceof Integer) {
                result = (Integer)o;
            } else if (o instanceof String) {
                result = new Integer((String)o);
            }
        }
        return result;
    }

    protected void setInputStream(InputStream ins) {
        this.remoteFileContents = new TimeoutInputStream(ins, 8192, this.getSocketReadTimeout(), this.getSocketCloseTimeout());
    }

    protected void setOutputStream(OutputStream outs) {
        this.localFileContents = outs;
    }

    protected void setCloseOutputStream(boolean close) {
        this.closeOutputStream = close;
    }

    protected void setFileLength(long length) {
        this.fileLength = length;
    }

    protected void setLastModifiedTime(long timestamp) {
        this.lastModifiedTime = timestamp;
    }

    protected Map getOptions() {
        return this.options;
    }

    protected synchronized void handleReceivedData(byte[] buf, int bytes, double factor, IProgressMonitor monitor) throws IOException {
        if (bytes != -1) {
            this.bytesReceived += (long)bytes;
            this.localFileContents.write(buf, 0, bytes);
            this.downloadRateBytesPerSecond = (double)this.bytesReceived / ((double)(System.currentTimeMillis() + 1L - this.transferStartTime) / 1000.0);
            monitor.setTaskName(String.valueOf(this.createJobName()) + Messages.AbstractRetrieveFileTransfer_Progress_Data + NLS.bind((String)Messages.AbstractRetrieveFileTransfer_InfoTransferRate, (Object)AbstractRetrieveFileTransfer.toHumanReadableBytes(this.downloadRateBytesPerSecond)));
            monitor.worked((int)Math.round(factor * (double)bytes));
            this.fireTransferReceiveDataEvent();
        } else {
            this.setDone(true);
        }
    }

    public static String toHumanReadableBytes(double size) {
        String unit;
        double convertedSize;
        if (size / 1.073741824E9 >= 1.0) {
            convertedSize = size / 1.073741824E9;
            unit = Messages.AbstractRetrieveFileTransfer_SizeUnitGB;
        } else if (size / 1048576.0 >= 1.0) {
            convertedSize = size / 1048576.0;
            unit = Messages.AbstractRetrieveFileTransfer_SizeUnitMB;
        } else if (size / 1024.0 >= 1.0) {
            convertedSize = size / 1024.0;
            unit = Messages.AbstractRetrieveFileTransfer_SizeUnitKB;
        } else {
            convertedSize = size;
            unit = Messages.AbstractRetrieveFileTransfer_SizeUnitBytes;
        }
        DecimalFormat df = new DecimalFormat(NLS.bind((String)Messages.AbstractRetrieveFileTransfer_TransferRateFormat, (Object)unit));
        return df.format(convertedSize);
    }

    public ID getID() {
        return this.remoteFileID;
    }

    protected IStatus getFinalStatus(Throwable exception1) {
        return Status.OK_STATUS;
    }

    protected void hardClose() {
        try {
            if (this.remoteFileContents != null) {
                this.remoteFileContents.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
        }
        try {
            if (this.localFileContents != null && this.closeOutputStream) {
                this.localFileContents.close();
            }
        }
        catch (IOException e) {
            Activator.getDefault().log((IStatus)new Status(4, "org.eclipse.ecf.provider.filetransfer", 4, "hardClose", (Throwable)e));
        }
        this.remoteFileContents = null;
        this.localFileContents = null;
    }

    protected void fireTransferReceivePausedEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceivePausedEvent(){

            public IIncomingFileTransfer getSource() {
                return AbstractRetrieveFileTransfer.this;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IIncomingFileTransferReceivePausedEvent[");
                sb.append("bytesReceived=").append(AbstractRetrieveFileTransfer.this.bytesReceived).append(";fileLength=").append(AbstractRetrieveFileTransfer.this.fileLength).append("]");
                return sb.toString();
            }
        });
    }

    protected void fireTransferReceiveDoneEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDoneEvent(){

            public IIncomingFileTransfer getSource() {
                return AbstractRetrieveFileTransfer.this;
            }

            public Exception getException() {
                return AbstractRetrieveFileTransfer.this.getException();
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveDoneEvent[");
                sb.append("bytesReceived=").append(AbstractRetrieveFileTransfer.this.bytesReceived).append(";fileLength=").append(AbstractRetrieveFileTransfer.this.fileLength).append(";exception=").append(this.getException()).append("]");
                return sb.toString();
            }
        });
    }

    protected void fireTransferReceiveDataEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveDataEvent(){

            public IIncomingFileTransfer getSource() {
                return AbstractRetrieveFileTransfer.this;
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveDataEvent[");
                sb.append("bytesReceived=").append(AbstractRetrieveFileTransfer.this.bytesReceived).append(";fileLength=").append(AbstractRetrieveFileTransfer.this.fileLength).append("]");
                return sb.toString();
            }
        });
    }

    public void setConnectContextForAuthentication(IConnectContext connectContext) {
        this.connectContext = connectContext;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public long getBytesReceived() {
        return this.bytesReceived;
    }

    protected UserCancelledException newUserCancelledException() {
        return new UserCancelledException(Messages.AbstractRetrieveFileTransfer_Exception_User_Cancelled);
    }

    protected synchronized void resetDoneAndException() {
        this.setDone(false);
        this.exception = null;
    }

    protected synchronized void setDone(boolean done) {
        this.done = done;
    }

    protected synchronized void setDoneException(Exception e) {
        this.done = true;
        this.exception = e;
    }

    protected synchronized boolean isCanceled() {
        return this.done && this.exception instanceof UserCancelledException;
    }

    protected void setDoneCanceled() {
        this.setDoneCanceled((Exception)this.newUserCancelledException());
    }

    protected synchronized void setDoneCanceled(Exception e) {
        this.done = true;
        this.exception = e instanceof UserCancelledException ? e : this.newUserCancelledException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        if (this.isPaused()) {
            this.setDoneCanceled();
            this.fireTransferReceiveDoneEvent();
            return;
        }
        Object object = this.jobLock;
        synchronized (object) {
            if (this.job != null) {
                this.job.cancel();
            }
        }
    }

    public synchronized Exception getException() {
        return this.exception;
    }

    public double getPercentComplete() {
        if (this.fileLength == -1L || this.fileLength == 0L) {
            return this.fileLength;
        }
        return (double)this.bytesReceived / (double)this.fileLength;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public Date getRemoteLastModified() {
        return this.lastModifiedTime == 0L ? null : new Date(this.lastModifiedTime);
    }

    public synchronized boolean isDone() {
        return this.done;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }

    protected abstract void openStreams() throws IncomingFileTransferException;

    public void sendRetrieveRequest(IFileID remoteFileID1, IFileTransferListener transferListener, Map options1) throws IncomingFileTransferException {
        this.sendRetrieveRequest(remoteFileID1, null, transferListener, options1);
    }

    public Namespace getRetrieveNamespace() {
        return IDFactory.getDefault().getNamespaceByName(FileTransferNamespace.PROTOCOL);
    }

    public boolean isPaused() {
        return this.paused;
    }

    protected abstract boolean doPause();

    public boolean pause() {
        return this.doPause();
    }

    protected abstract boolean doResume();

    public boolean resume() {
        return this.doResume();
    }

    public IFileTransferListener getListener() {
        return this.listener;
    }

    protected String createRangeName() {
        if (this.rangeSpecification == null) {
            return "";
        }
        return "[" + this.rangeSpecification.getStartPosition() + "," + this.rangeSpecification.getEndPosition() + "]";
    }

    protected String createJobName() {
        return String.valueOf(this.getRemoteFileURL().toString()) + this.createRangeName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupAndScheduleJob(FileTransferJob fileTransferJob) {
        if (fileTransferJob == null) {
            fileTransferJob = new FileTransferJob(this.createJobName());
        }
        fileTransferJob.setFileTransferRunnable(this.fileTransferRunnable);
        fileTransferJob.setFileTransfer((IFileTransfer)this);
        if (this.isDone()) {
            return;
        }
        Object object = this.jobLock;
        synchronized (object) {
            this.job = fileTransferJob;
            this.job.schedule();
        }
    }

    protected void fireReceiveStartEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveStartEvent(){

            public IIncomingFileTransfer getSource() {
                return AbstractRetrieveFileTransfer.this;
            }

            public IFileID getFileID() {
                return AbstractRetrieveFileTransfer.this.remoteFileID;
            }

            public IIncomingFileTransfer receive(File localFileToSave) throws IOException {
                return this.receive(localFileToSave, null);
            }

            public IIncomingFileTransfer receive(File localFileToSave, FileTransferJob fileTransferJob) throws IOException {
                AbstractRetrieveFileTransfer.this.setOutputStream(new BufferedOutputStream(new FileOutputStream(localFileToSave)));
                AbstractRetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                return AbstractRetrieveFileTransfer.this;
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore) throws IOException {
                return this.receive(streamToStore, null);
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore, FileTransferJob fileTransferJob) throws IOException {
                AbstractRetrieveFileTransfer.this.setOutputStream(streamToStore);
                AbstractRetrieveFileTransfer.this.setCloseOutputStream(false);
                AbstractRetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                return AbstractRetrieveFileTransfer.this;
            }

            public void cancel() {
                AbstractRetrieveFileTransfer.this.cancel();
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveStartEvent[");
                sb.append("isdone=").append(AbstractRetrieveFileTransfer.this.isDone()).append(";");
                sb.append("bytesReceived=").append(AbstractRetrieveFileTransfer.this.bytesReceived).append("]");
                return sb.toString();
            }

            public Map getResponseHeaders() {
                return AbstractRetrieveFileTransfer.this.responseHeaders;
            }
        });
    }

    protected void fireReceiveResumedEvent() {
        this.listener.handleTransferEvent((IFileTransferEvent)new IIncomingFileTransferReceiveResumedEvent(){

            public IIncomingFileTransfer getSource() {
                return AbstractRetrieveFileTransfer.this;
            }

            public IFileID getFileID() {
                return AbstractRetrieveFileTransfer.this.remoteFileID;
            }

            public IIncomingFileTransfer receive(File localFileToSave, boolean append) throws IOException {
                return this.receive(localFileToSave, null, append);
            }

            public IIncomingFileTransfer receive(File localFileToSave, FileTransferJob fileTransferJob, boolean append) throws IOException {
                AbstractRetrieveFileTransfer.this.setOutputStream(new BufferedOutputStream(new FileOutputStream(localFileToSave.getName(), append)));
                AbstractRetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                return AbstractRetrieveFileTransfer.this;
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore) throws IOException {
                return this.receive(streamToStore, null);
            }

            public IIncomingFileTransfer receive(OutputStream streamToStore, FileTransferJob fileTransferJob) throws IOException {
                AbstractRetrieveFileTransfer.this.setOutputStream(streamToStore);
                AbstractRetrieveFileTransfer.this.setCloseOutputStream(false);
                AbstractRetrieveFileTransfer.this.setupAndScheduleJob(fileTransferJob);
                return AbstractRetrieveFileTransfer.this;
            }

            public void cancel() {
                AbstractRetrieveFileTransfer.this.hardClose();
            }

            public String toString() {
                StringBuffer sb = new StringBuffer("IIncomingFileTransferReceiveResumedEvent[");
                sb.append("isdone=").append(AbstractRetrieveFileTransfer.this.isDone()).append(";");
                sb.append("bytesReceived=").append(AbstractRetrieveFileTransfer.this.bytesReceived).append("]");
                return sb.toString();
            }

            public Map getResponseHeaders() {
                return AbstractRetrieveFileTransfer.this.responseHeaders;
            }
        });
    }

    public IFileRangeSpecification getFileRangeSpecification() {
        return this.rangeSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendRetrieveRequest(IFileID rFileID, IFileRangeSpecification rangeSpec, IFileTransferListener transferListener, Map ops) throws IncomingFileTransferException {
        Assert.isNotNull((Object)rFileID, (String)Messages.AbstractRetrieveFileTransfer_RemoteFileID_Not_Null);
        Assert.isNotNull((Object)transferListener, (String)Messages.AbstractRetrieveFileTransfer_TransferListener_Not_Null);
        Object object = this.jobLock;
        synchronized (object) {
            this.job = null;
        }
        this.remoteFileURL = null;
        this.remoteFileID = rFileID;
        this.listener = transferListener;
        this.remoteFileContents = null;
        this.localFileContents = null;
        this.closeOutputStream = true;
        this.resetDoneAndException();
        this.bytesReceived = 0L;
        this.fileLength = -1L;
        this.options = ops;
        this.paused = false;
        this.rangeSpecification = rangeSpec;
        try {
            this.remoteFileURL = rFileID.getURL();
        }
        catch (MalformedURLException e) {
            this.setDoneException(e);
            this.fireTransferReceiveDoneEvent();
            return;
        }
        try {
            this.setupProxies();
            this.openStreams();
        }
        catch (IncomingFileTransferException e) {
            this.setDoneException((Exception)((Object)e));
            this.fireTransferReceiveDoneEvent();
        }
    }

    protected abstract void setupProxy(Proxy var1);

    protected IProxyData selectProxyFromProxies(String protocol, IProxyData[] proxies) {
        block7: {
            block6: {
                if (proxies == null || proxies.length == 0) {
                    return null;
                }
                if (proxies.length == 1) {
                    return proxies[0];
                }
                if (!protocol.equalsIgnoreCase("http")) break block6;
                int i = 0;
                while (i < proxies.length) {
                    if (proxies[i].getType().equals("HTTP")) {
                        return proxies[i];
                    }
                    ++i;
                }
                break block7;
            }
            if (!protocol.equalsIgnoreCase("https")) break block7;
            int i = 0;
            while (i < proxies.length) {
                if (proxies[i].getType().equals("HTTPS")) {
                    return proxies[i];
                }
                ++i;
            }
        }
        return proxies[0];
    }

    protected void setupProxies() {
        if (this.proxy == null) {
            try {
                this.proxy = ProxySetupHelper.getProxy(this.getRemoteFileURL().toExternalForm());
            }
            catch (NoClassDefFoundError e) {
                Activator.logNoProxyWarning(e);
            }
        }
        if (this.proxy != null) {
            this.setupProxy(this.proxy);
        }
    }

    public String getRemoteFileName() {
        IPath path;
        String pathStr = this.getRemoteFileURL().getPath();
        if (pathStr.length() > 0 && (path = Path.fromPortableString((String)pathStr)).segmentCount() > 0) {
            return path.lastSegment();
        }
        return null;
    }

    protected boolean targetHasGzSuffix(String target) {
        if (target == null) {
            return false;
        }
        return target.endsWith(".gz");
    }
}

