/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.util.Objects;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.ui.AbstractSetupDialog;
import org.eclipse.oomph.ui.OomphUIPlugin;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SwitchUserHomeDialog
extends AbstractSetupDialog {
    private String location;
    private String defaultLocation;

    public SwitchUserHomeDialog(Shell parentShell) {
        super(parentShell, PropertiesUtil.getProductName(), 780, 240, (OomphUIPlugin)SetupInstallerPlugin.INSTANCE, false);
    }

    public String getUserHomeLocation() {
        return this.location;
    }

    protected String getDefaultMessage() {
        return Messages.SwitchUserHomeDialog_Title_description;
    }

    protected int getContainerMargin() {
        return 10;
    }

    protected void createUI(Composite parent) {
        final Shell shell = this.getShell();
        this.setTitle(Messages.SwitchUserHomeDialog_Title_text);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = this.getContainerMargin();
        layout.marginHeight = this.getContainerMargin();
        layout.verticalSpacing = 5;
        parent.setLayout((Layout)layout);
        final Label locationLabel = new Label(parent, 0);
        locationLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        locationLabel.setText(Messages.SwitchUserHomeDialog_UserHomeFolder_label);
        final Text locationText = new Text(parent, 2048);
        locationText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SwitchUserHomeDialog.this.location = locationText.getText();
                String error = this.validate();
                SwitchUserHomeDialog.this.setErrorMessage(error);
                Button okButton = SwitchUserHomeDialog.this.getButton(0);
                okButton.setEnabled(error == null && SwitchUserHomeDialog.this.location.length() != 0 && !Objects.equals(SwitchUserHomeDialog.this.location, SwitchUserHomeDialog.this.defaultLocation));
            }

            private String validate() {
                if (SwitchUserHomeDialog.this.location.length() == 0) {
                    return null;
                }
                File folder = new File(SwitchUserHomeDialog.this.location);
                if (!folder.exists()) {
                    return null;
                }
                if (!folder.isDirectory()) {
                    return Messages.KeepInstallerDialog_PathNoDirectory_message;
                }
                return null;
            }
        });
        Button browseButton = new Button(parent, 0);
        browseButton.setText(Messages.KeepInstallerDialog_Browse_label + StringUtil.HORIZONTAL_ELLIPSIS);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String dir;
                FileDialog dialog = new FileDialog(shell, 73728);
                dialog.setText(locationLabel.getText());
                if (!StringUtil.isEmpty((String)SwitchUserHomeDialog.this.location)) {
                    File file = new File(SwitchUserHomeDialog.this.location).getAbsoluteFile();
                    dialog.setFilterPath(file.getParent());
                    dialog.setFileName(file.getName());
                }
                if ((dir = dialog.open()) != null) {
                    locationText.setText(dir);
                }
            }
        });
        this.setDefaultLocation(locationText);
    }

    protected String getShellText() {
        return PropertiesUtil.getProductName();
    }

    protected void setDefaultLocation(final Text locationText) {
        UIUtil.asyncExec((Control)locationText, (Runnable)new Runnable(){

            @Override
            public void run() {
                File home = new File(PropertiesUtil.getUserHome());
                SwitchUserHomeDialog.this.defaultLocation = home.getAbsolutePath();
                locationText.setText(SwitchUserHomeDialog.this.defaultLocation);
                locationText.setSelection(SwitchUserHomeDialog.this.defaultLocation.length());
            }
        });
    }
}

