/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.targlets.core.ITargletContainerListener;
import org.eclipse.oomph.targlets.core.TargletContainerEvent;
import org.eclipse.oomph.targlets.internal.core.Messages;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.osgi.util.NLS;

public class TargletContainerListenerRegistry
implements ITargletContainerListener.Registry {
    public static final TargletContainerListenerRegistry INSTANCE = new TargletContainerListenerRegistry();
    private final List<ITargletContainerListener> listeners = new ArrayList<ITargletContainerListener>();
    private final ExtensionPointHandler extensionPointHandler = new ExtensionPointHandler();

    private TargletContainerListenerRegistry() {
    }

    public void start() throws Exception {
        this.extensionPointHandler.start();
    }

    public void stop() throws Exception {
        this.extensionPointHandler.stop();
        this.listeners.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(ITargletContainerListener listener) {
        List<ITargletContainerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(ITargletContainerListener listener) {
        List<ITargletContainerListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(TargletContainerEvent event, IProgressMonitor monitor) {
        ITargletContainerListener[] targletContainerListeners;
        List<ITargletContainerListener> list = this.listeners;
        synchronized (list) {
            targletContainerListeners = this.listeners.toArray(new ITargletContainerListener[this.listeners.size()]);
        }
        if (targletContainerListeners.length != 0) {
            monitor.beginTask("", targletContainerListeners.length);
            ITargletContainerListener[] iTargletContainerListenerArray = targletContainerListeners;
            int n = targletContainerListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ITargletContainerListener listener = iTargletContainerListenerArray[n2];
                try {
                    monitor.subTask(NLS.bind((String)Messages.TargletContainerListenerRegistry_Sending_task, (Object)event, (Object)listener));
                    listener.handleTargletContainerEvent(event, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
                }
                catch (Exception ex) {
                    TargletsCorePlugin.INSTANCE.log(ex);
                }
                ++n2;
            }
            monitor.done();
        }
    }

    public static class ExtensionPointHandler
    implements IRegistryEventListener {
        public static final String EXTENSION_POINT = "org.eclipse.oomph.targlets.core.targletContainerListeners";
        private final Map<IConfigurationElement, ITargletContainerListener> listeners = new HashMap<IConfigurationElement, ITargletContainerListener>();

        public void start() throws Exception {
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(EXTENSION_POINT);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                this.added(configurationElement);
                ++n2;
            }
            extensionRegistry.addListener((IRegistryEventListener)this, EXTENSION_POINT);
        }

        public void stop() throws Exception {
            Platform.getExtensionRegistry().removeListener((IRegistryEventListener)this);
            for (ITargletContainerListener listener : this.listeners.values()) {
                INSTANCE.removeListener(listener);
            }
            this.listeners.clear();
        }

        public void added(IExtensionPoint[] extensionPoints) {
        }

        public void removed(IExtensionPoint[] extensionPoints) {
        }

        public void added(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.added(configurationElement);
                    ++n4;
                }
                ++n2;
            }
        }

        public void removed(IExtension[] extensions) {
            IExtension[] iExtensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                    this.removed(configurationElement);
                    ++n4;
                }
                ++n2;
            }
        }

        private void added(IConfigurationElement configurationElement) {
            try {
                ITargletContainerListener listener = (ITargletContainerListener)configurationElement.createExecutableExtension("class");
                this.listeners.put(configurationElement, listener);
                INSTANCE.addListener(listener);
            }
            catch (Exception ex) {
                TargletsCorePlugin.INSTANCE.log(ex);
            }
        }

        private void removed(IConfigurationElement configurationElement) {
            ITargletContainerListener listener = this.listeners.remove(configurationElement);
            if (listener != null) {
                INSTANCE.removeListener(listener);
            }
        }
    }
}

