/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.resource.flexcontainerspec;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.flexcontainerspec.AtmosphericPressureSensorFlexContainer;
import org.eclipse.om2m.commons.resource.flexcontainerspec.ExtendedCarbonDioxideSensorFlexContainer;
import org.eclipse.om2m.commons.resource.flexcontainerspec.NoiseFlexContainer;
import org.eclipse.om2m.commons.resource.flexcontainerspec.RelativeHumidityFlexContainer;
import org.eclipse.om2m.commons.resource.flexcontainerspec.TemperatureFlexContainer;

@XmlRootElement(name="deWSn", namespace="http://www.onem2m.org/xml/protocols/homedomain")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="deWSn", namespace="http://www.onem2m.org/xml/protocols/homedomain")
public class DeviceWeatherStationFlexContainer
extends AbstractFlexContainer {
    public static final String LONG_NAME = "deviceWeatherStation";
    public static final String SHORT_NAME = "deWSn";
    @XmlElement(name="tempe", required=true, type=TemperatureFlexContainer.class)
    private TemperatureFlexContainer temperature;
    @XmlElement(name="relHy", required=true, type=RelativeHumidityFlexContainer.class)
    private RelativeHumidityFlexContainer relativeHumidity;
    @XmlElement(name="atPSr", required=true, type=AtmosphericPressureSensorFlexContainer.class)
    private AtmosphericPressureSensorFlexContainer atmosphericPressureSensor;
    @XmlElement(name="noise", required=true, type=NoiseFlexContainer.class)
    private NoiseFlexContainer noise;
    @XmlElement(name="eCDSr", required=true, type=ExtendedCarbonDioxideSensorFlexContainer.class)
    private ExtendedCarbonDioxideSensorFlexContainer extendedCarbonDioxideSensor;

    public DeviceWeatherStationFlexContainer() {
        this.setContainerDefinition("org.onem2m.home.device.deviceWeatherStation");
        this.setLongName(LONG_NAME);
        this.setShortName(SHORT_NAME);
    }

    @Override
    public void finalizeSerialization() {
        this.getTemperature();
        this.getRelativeHumidity();
        this.getAtmosphericPressureSensor();
        this.getNoise();
        this.getExtendedCarbonDioxideSensor();
    }

    @Override
    public void finalizeDeserialization() {
        if (this.temperature != null) {
            this.setTemperature(this.temperature);
        }
        if (this.relativeHumidity != null) {
            this.setRelativeHumidity(this.relativeHumidity);
        }
        if (this.atmosphericPressureSensor != null) {
            this.setAtmosphericPressureSensor(this.atmosphericPressureSensor);
        }
        if (this.noise != null) {
            this.setNoise(this.noise);
        }
        if (this.extendedCarbonDioxideSensor != null) {
            this.setExtendedCarbonDioxideSensor(this.extendedCarbonDioxideSensor);
        }
    }

    public void setTemperature(TemperatureFlexContainer temperature) {
        this.temperature = temperature;
        this.getFlexContainerOrContainerOrSubscription().add(temperature);
    }

    public TemperatureFlexContainer getTemperature() {
        this.temperature = (TemperatureFlexContainer)this.getResourceByName("tempe");
        return this.temperature;
    }

    public void setRelativeHumidity(RelativeHumidityFlexContainer relativeHumidity) {
        this.relativeHumidity = relativeHumidity;
        this.getFlexContainerOrContainerOrSubscription().add(relativeHumidity);
    }

    public RelativeHumidityFlexContainer getRelativeHumidity() {
        this.relativeHumidity = (RelativeHumidityFlexContainer)this.getResourceByName("relHy");
        return this.relativeHumidity;
    }

    public void setAtmosphericPressureSensor(AtmosphericPressureSensorFlexContainer atmosphericPressureSensor) {
        this.atmosphericPressureSensor = atmosphericPressureSensor;
        this.getFlexContainerOrContainerOrSubscription().add(atmosphericPressureSensor);
    }

    public AtmosphericPressureSensorFlexContainer getAtmosphericPressureSensor() {
        this.atmosphericPressureSensor = (AtmosphericPressureSensorFlexContainer)this.getResourceByName("atPSr");
        return this.atmosphericPressureSensor;
    }

    public void setNoise(NoiseFlexContainer noise) {
        this.noise = noise;
        this.getFlexContainerOrContainerOrSubscription().add(noise);
    }

    public NoiseFlexContainer getNoise() {
        this.noise = (NoiseFlexContainer)this.getResourceByName("noise");
        return this.noise;
    }

    public void setExtendedCarbonDioxideSensor(ExtendedCarbonDioxideSensorFlexContainer extendedCarbonDioxideSensor) {
        this.extendedCarbonDioxideSensor = extendedCarbonDioxideSensor;
        this.getFlexContainerOrContainerOrSubscription().add(extendedCarbonDioxideSensor);
    }

    public ExtendedCarbonDioxideSensorFlexContainer getExtendedCarbonDioxideSensor() {
        this.extendedCarbonDioxideSensor = (ExtendedCarbonDioxideSensorFlexContainer)this.getResourceByName("eCDSr");
        return this.extendedCarbonDioxideSensor;
    }
}

