/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.om2m.sdt.Element;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;

public class SubDevice
extends Element {
    private Map<String, Module> modules = new HashMap<String, Module>();
    private Map<String, Property> properties = new HashMap<String, Property>();

    public SubDevice(String id) {
        super(id);
    }

    public String getId() {
        return this.getName();
    }

    public Collection<String> getModuleNames() {
        return this.modules.keySet();
    }

    public Collection<Module> getModules() {
        return this.modules.values();
    }

    public Module getModule(String name) {
        return this.modules.get(name);
    }

    public void addModule(Module module) {
        if (this.modules.get(module.getName()) != null) {
            throw new IllegalArgumentException();
        }
        this.modules.put(module.getName(), module);
    }

    public void removeModule(String name) {
        this.modules.remove(name);
    }

    public Collection<String> getPropertyNames() {
        return this.properties.keySet();
    }

    public Collection<Property> getProperties() {
        return this.properties.values();
    }

    public Property getProperty(String name) {
        return this.properties.get(name);
    }

    public void addProperty(Property property) {
        this.properties.put(property.getName(), property);
    }

    public void removeProperty(String name) {
        this.properties.remove(name);
    }

    @Override
    protected String prettyPrint(String t1) {
        String t2 = String.valueOf(t1) + "\t";
        StringBuffer ret = new StringBuffer(t1).append("<SubDevice id=\"").append(this.getId()).append("\">");
        if (this.getDoc() != null) {
            ret.append("\n").append(t2).append(this.getDoc());
        }
        this.prettyPrint(ret, this.properties.values(), "Properties", t2);
        this.prettyPrint(ret, this.modules.values(), "Modules", t2);
        return ret.append("\n").append(t1).append("</SubDevice>").toString();
    }
}

