/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.binding.coap;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.binding.coap.CoapClient;
import org.eclipse.om2m.binding.coap.CoapMessageDeliverer;
import org.eclipse.om2m.binding.coap.CoapServer;
import org.eclipse.om2m.binding.service.RestClientService;
import org.eclipse.om2m.core.service.CseService;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator {
    private static Log LOGGER = LogFactory.getLog(Activator.class);
    private ServiceTracker<Object, Object> cseServiceTracker;
    CoapServer server;

    public void start(BundleContext bundleContext) throws Exception {
        LOGGER.info((Object)"Register CoAP RestClientService..");
        bundleContext.registerService(RestClientService.class.getName(), (Object)new CoapClient(), null);
        LOGGER.info((Object)"Starting CoAP server");
        this.server = new CoapServer();
        this.server.startServer();
        this.cseServiceTracker = new ServiceTracker<Object, Object>(bundleContext, CseService.class.getName(), null){

            public void removedService(ServiceReference<Object> reference, Object service) {
                LOGGER.info((Object)"CSE Service removed");
                try {
                    CoapMessageDeliverer.setCse((CseService)service);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.error((Object)"Error removing CSE Service", (Throwable)e);
                }
            }

            public Object addingService(ServiceReference<Object> reference) {
                LOGGER.info((Object)"CSE Service discovered");
                CseService cse = (CseService)this.context.getService(reference);
                try {
                    CoapMessageDeliverer.setCse(cse);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"Error adding CSE Service", (Throwable)e);
                }
                return cse;
            }
        };
        this.cseServiceTracker.open();
        LOGGER.info((Object)"CseService opened");
    }

    public void stop(BundleContext bundleContext) throws Exception {
    }
}

