/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt.flexcontainerservice;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.exceptions.Om2mException;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.RequestPrimitive;
import org.eclipse.om2m.flexcontainer.service.FlexContainerService;
import org.eclipse.om2m.ipe.sdt.Activator;
import org.eclipse.om2m.ipe.sdt.SDTUtil;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.datapoints.ValuedDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.osgi.framework.ServiceRegistration;

public class ModuleFlexContainerService
implements FlexContainerService {
    private static Log logger = LogFactory.getLog(ModuleFlexContainerService.class);
    private final Module module;
    private final String flexContainerLocation;
    private ServiceRegistration serviceRegistration = null;

    public ModuleFlexContainerService(Module pModule, String pFlexContainerLocation) {
        this.module = pModule;
        this.flexContainerLocation = pFlexContainerLocation;
    }

    public void register() {
        if (this.serviceRegistration != null) {
            return;
        }
        this.serviceRegistration = Activator.registerFlexContainerService(this);
    }

    public void unregister() {
        if (this.serviceRegistration != null) {
            this.serviceRegistration.unregister();
            this.serviceRegistration = null;
        }
    }

    public String getCustomAttributeValue(String customAttributeName) throws Om2mException {
        logger.debug((Object)("DataPointFlexContainerService - getCustomAttributeValue(customAttributeName=" + customAttributeName + ")"));
        Property prop = this.module.getPropertyByShortName(customAttributeName);
        if (prop != null) {
            logger.debug((Object)"CustomAttribute is a property, not a datapoint");
            return prop.getValue();
        }
        DataPoint dataPoint = this.module.getDataPointByShortName(customAttributeName);
        if (dataPoint == null) {
            throw new Om2mException("unknown custom attribute " + customAttributeName + " in " + this.module, ResponseStatusCode.INTERNAL_SERVER_ERROR);
        }
        String value = null;
        try {
            Object o = ((ValuedDataPoint)dataPoint).getValue();
            String type = dataPoint.getDataType().getTypeChoice().getOneM2MType();
            value = SDTUtil.getStringValue(type, o);
        }
        catch (AccessException e) {
            e.printStackTrace();
            throw new Om2mException("unable to retrieve value of DataPoint " + dataPoint.getName() + " : " + e.getMessage(), ResponseStatusCode.ACCESS_DENIED);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Om2mException("unable to retrieve value of DataPoint " + dataPoint.getName() + " : " + e.getMessage(), ResponseStatusCode.INTERNAL_SERVER_ERROR);
        }
        logger.debug((Object)("DataPointFlexContainerService - getCustomAttributeValue(customAttributeName=" + customAttributeName + ") - value=" + value));
        return value;
    }

    public Map<String, String> getCustomAttributeValues(List<String> customAttributeNames) throws Om2mException {
        try {
            HashMap<String, String> ret = new HashMap<String, String>();
            ArrayList<String> dpNames = new ArrayList<String>();
            for (String string : customAttributeNames) {
                Property prop = this.module.getPropertyByShortName(string);
                if (prop != null) {
                    logger.debug((Object)("CustomAttribute " + string + " is a property, not a datapoint"));
                    ret.put(string, prop.getValue());
                    continue;
                }
                if (this.module.getDataPointByShortName(string) != null) {
                    logger.debug((Object)("CustomAttribute " + string + " is a datapoint"));
                    dpNames.add(string);
                    continue;
                }
                logger.warn((Object)("CustomAttribute " + string + " unknown"));
                throw new Om2mException(ResponseStatusCode.INVALID_ARGUMENTS);
            }
            for (Map.Entry entry : this.module.getDatapointHandler().getValues(dpNames).entrySet()) {
                DataPoint dataPoint = this.module.getDataPointByShortName((String)entry.getKey());
                String type = dataPoint.getDataType().getTypeChoice().getOneM2MType();
                ret.put((String)entry.getKey(), SDTUtil.getStringValue(type, entry.getValue()));
            }
            return ret;
        }
        catch (AccessException e) {
            e.printStackTrace();
            throw new Om2mException(e.getMessage(), (Throwable)e, ResponseStatusCode.ACCESS_DENIED);
        }
        catch (DataPointException e) {
            e.printStackTrace();
            throw new Om2mException(e.getMessage(), (Throwable)e, ResponseStatusCode.INTERNAL_SERVER_ERROR);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Om2mException(ResponseStatusCode.INVALID_ARGUMENTS);
        }
    }

    public void setCustomAttributeValues(List<CustomAttribute> customAttributes, RequestPrimitive request) throws Om2mException {
        logger.debug((Object)"setCustomAttributeValues()");
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (CustomAttribute ca : customAttributes) {
            DataPoint dataPoint = this.module.getDataPointByShortName(ca.getCustomAttributeName());
            if (dataPoint == null) {
                throw new Om2mException(ResponseStatusCode.INVALID_ARGUMENTS);
            }
            try {
                String type = dataPoint.getDataType().getTypeChoice().getOneM2MType();
                values.put(ca.getCustomAttributeName(), SDTUtil.getValue(ca.getCustomAttributeValue(), type));
            }
            catch (Exception e) {
                logger.info((Object)("KO: " + e.getMessage()));
                throw new Om2mException(e.getMessage(), (Throwable)e, ResponseStatusCode.CONTENTS_UNACCEPTABLE);
            }
        }
        try {
            this.module.getDatapointHandler().setValues(values);
        }
        catch (AccessException e) {
            logger.warn((Object)("KO: " + e.getMessage()));
            throw new Om2mException(e.getMessage(), (Throwable)e, ResponseStatusCode.ACCESS_DENIED);
        }
        catch (Exception e) {
            logger.warn((Object)("KO: " + e.getMessage()));
            throw new Om2mException(e.getMessage(), (Throwable)e, ResponseStatusCode.INTERNAL_SERVER_ERROR);
        }
    }

    public String getFlexContainerLocation() {
        return this.flexContainerLocation;
    }
}

