/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.PollingChannelEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AE;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AccessControlPolicy;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.DynamicAuthorizationConsultation;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.PollingChannel;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.AcpMapper;
import org.eclipse.om2m.core.entitymapper.ContainerMapper;
import org.eclipse.om2m.core.entitymapper.DynamicAuthorizationConsultationMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.FlexContainerMapper;
import org.eclipse.om2m.core.entitymapper.GroupMapper;
import org.eclipse.om2m.core.entitymapper.PollingChannelMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class AeMapper
extends EntityMapper<AeEntity, AE> {
    @Override
    protected AE createResource() {
        return new AE();
    }

    @Override
    protected void mapAttributes(AeEntity entity, AE resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setAEID(entity.getAeid());
        resource.setAppID(entity.getAppID());
        resource.setAppName(entity.getAppName());
        resource.setNodeLink(entity.getNodeLink());
        resource.setOntologyRef(entity.getOntologyRef());
        if (!entity.getPointOfAccess().isEmpty()) {
            resource.getPointOfAccess().addAll(entity.getPointOfAccess());
        }
        resource.setRequestReachability(Boolean.valueOf(entity.isRequestReachability()));
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(AeEntity entity, int level, int offset) {
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (AccessControlPolicyEntity acpEntity : entity.getChildAccessControlPolicies()) {
            child = new ChildResourceRef();
            child.setResourceName(acpEntity.getName());
            child.setType(BigInteger.valueOf(1L));
            child.setValue(acpEntity.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new AcpMapper().getChildResourceRef(acpEntity, level - 1, offset - 1));
        }
        for (ContainerEntity containerEntity : entity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(containerEntity.getName());
            child.setType(BigInteger.valueOf(3L));
            child.setValue(containerEntity.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContainerMapper().getChildResourceRef(containerEntity, level - 1, offset - 1));
        }
        for (FlexContainerEntity flexContainerEntity : entity.getChildFlexContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(flexContainerEntity.getName());
            child.setType(flexContainerEntity.getResourceType());
            child.setValue(flexContainerEntity.getResourceID());
            child.setSpid(flexContainerEntity.getContainerDefinition());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerMapper().getChildResourceRef(flexContainerEntity, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(BigInteger.valueOf(23L));
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (GroupEntity group : entity.getChildGroups()) {
            child = new ChildResourceRef();
            child.setResourceName(group.getName());
            child.setType(BigInteger.valueOf(9L));
            child.setValue(group.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new GroupMapper().getChildResourceRef(group, level - 1, offset - 1));
        }
        for (PollingChannelEntity pollEntity : entity.getPollingChannels()) {
            child = new ChildResourceRef();
            child.setResourceName(pollEntity.getName());
            child.setValue(pollEntity.getResourceID());
            child.setType(15);
            childRefs.add(child);
            childRefs.addAll(new PollingChannelMapper().getChildResourceRef(pollEntity, level - 1, offset - 1));
        }
        for (DynamicAuthorizationConsultationEntity dace : entity.getChildDynamicAuthorizationConsultations()) {
            ChildResourceRef ch = new ChildResourceRef();
            ch.setResourceName(dace.getName());
            ch.setType(34);
            ch.setValue(dace.getResourceID());
            childRefs.add(ch);
            childRefs.addAll(new DynamicAuthorizationConsultationMapper().getChildResourceRef(dace, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(AeEntity entity, AE resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(AeEntity entity, AE resource, int level, int offset) {
        if (level == 0) {
            return;
        }
        for (AccessControlPolicyEntity acpEntity : entity.getChildAccessControlPolicies()) {
            AccessControlPolicy acpRes = (AccessControlPolicy)new AcpMapper().mapEntityToResource(acpEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(acpRes);
        }
        for (ContainerEntity containerEntity : entity.getChildContainers()) {
            Container cnt = (Container)new ContainerMapper().mapEntityToResource(containerEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(cnt);
        }
        for (FlexContainerEntity flexContainerEntity : entity.getChildFlexContainers()) {
            AbstractFlexContainer fcnt = (AbstractFlexContainer)new FlexContainerMapper().mapEntityToResource(flexContainerEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(fcnt);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(subRes);
        }
        for (GroupEntity group : entity.getChildGroups()) {
            Group grp = (Group)new GroupMapper().mapEntityToResource(group, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(grp);
        }
        for (PollingChannelEntity pollEntity : entity.getPollingChannels()) {
            PollingChannel poll = (PollingChannel)new PollingChannelMapper().mapEntityToResource(pollEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(poll);
        }
        for (DynamicAuthorizationConsultationEntity daceEntity : entity.getChildDynamicAuthorizationConsultations()) {
            DynamicAuthorizationConsultation dace = (DynamicAuthorizationConsultation)new DynamicAuthorizationConsultationMapper().mapEntityToResource(daceEntity, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContainerOrGroupOrAccessControlPolicy().add(dace);
        }
    }
}

