/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mongodb.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoAnncEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoAnncEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.MgmtObjAnncEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.NodeAnncEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.persistence.mongodb.Constants;
import org.eclipse.om2m.persistence.mongodb.DAOFactoryImpl;
import org.eclipse.om2m.persistence.mongodb.DBTransactionImpl;
import org.eclipse.om2m.persistence.mongodb.resource.ResourceSerializerDeserializer;
import org.eclipse.om2m.persistence.mongodb.util.DBUtilManagerImpl;
import org.eclipse.om2m.persistence.service.DAOFactory;
import org.eclipse.om2m.persistence.service.DBConstants;
import org.eclipse.om2m.persistence.service.DBService;
import org.eclipse.om2m.persistence.service.DBTransaction;
import org.eclipse.om2m.persistence.service.util.DBUtilManager;

public class DBServiceImpl
implements DBService,
Constants {
    private static final Log LOGGER = LogFactory.getLog(DBServiceImpl.class);
    private static final DBServiceImpl INSTANCE = new DBServiceImpl();
    private MongoCollection<Document> resourceCollection;
    private MongoCollection<Document> announceCollection;
    private GsonBuilder gsonBuilder;
    private Gson gson;

    public static DBServiceImpl getInstance() {
        return INSTANCE;
    }

    private DBServiceImpl() {
    }

    protected void init() {
        MongoClient mongoClient = new MongoClient(DBConstants.DB_URL);
        LOGGER.info((Object)("mongoDB client=" + mongoClient));
        MongoDatabase database = mongoClient.getDatabase("mydb_" + org.eclipse.om2m.commons.constants.Constants.CSE_NAME);
        this.resourceCollection = database.getCollection("om2m_resource");
        this.announceCollection = database.getCollection("om2m_announce");
        if (DBConstants.DB_RESET) {
            LOGGER.info((Object)"delete all");
            this.resourceCollection.deleteMany((Bson)new Document());
            this.resourceCollection.dropIndexes();
            try {
                Document doc = new Document();
                doc.put("HierarchicalURI", (Object)100);
                this.resourceCollection.createIndex(Indexes.ascending((String[])new String[]{"ResourceID"}));
                this.resourceCollection.createIndex(Indexes.ascending((String[])new String[]{"HierarchicalURI"}), new IndexOptions().unique(true));
            }
            catch (Exception e) {
                LOGGER.error((Object)"Can't delete all ", (Throwable)e);
            }
            this.announceCollection.deleteMany((Bson)new Document());
            this.announceCollection.dropIndexes();
            this.announceCollection.createIndex(Indexes.ascending((String[])new String[]{"LOCAL_RESOURCE_ID", "ANNOUNCE_CSE_ID", "REMOTE_RESOURCE_ID"}), new IndexOptions().unique(true));
        }
        this.gsonBuilder = new GsonBuilder();
        this.gsonBuilder.registerTypeAdapter(CSEBaseEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AccessControlPolicyEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AeEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(FlexContainerEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(ContainerEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(ContentInstanceEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(SubscriptionEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(RemoteCSEEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AeAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(FlexContainerAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(DynamicAuthorizationConsultationEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(NodeEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(NodeAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(MgmtObjEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(MgmtObjAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(DeviceInfoEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(DeviceInfoAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AreaNwkDeviceInfoEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AreaNwkDeviceInfoAnncEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AreaNwkInfoEntity.class, new ResourceSerializerDeserializer());
        this.gsonBuilder.registerTypeAdapter(AreaNwkInfoAnncEntity.class, new ResourceSerializerDeserializer());
        this.gson = this.gsonBuilder.create();
    }

    public DBTransaction getDbTransaction() {
        return new DBTransactionImpl();
    }

    public DAOFactory getDAOFactory() {
        return new DAOFactoryImpl();
    }

    public DBUtilManager getDBUtilManager() {
        return new DBUtilManagerImpl();
    }

    public MongoCollection<Document> getResourceCollection() {
        return this.resourceCollection;
    }

    public MongoCollection<Document> getAnnounceCollection() {
        return this.announceCollection;
    }

    public Gson getGson() {
        return this.gson;
    }
}

