/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipe.sdt;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AreaNwkDeviceInfo;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.DeviceInfo;
import org.eclipse.om2m.commons.resource.Node;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.FlexContainerFactory;
import org.eclipse.om2m.ipe.sdt.CseUtil;
import org.eclipse.om2m.ipe.sdt.SDTModuleAdaptor;
import org.eclipse.om2m.sdt.Device;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.Property;
import org.eclipse.om2m.sdt.home.types.PropertyType;

public class SDTDeviceAdaptor {
    private static final Log logger = LogFactory.getLog(SDTDeviceAdaptor.class);
    private static final String SEP = "/";
    private static final String DEVICE_PREFIX = "DEVICE_";
    private static final String NODE_PREFIX = "NODE_";
    private final boolean hasToBeAnnounced;
    private final String parentLocation;
    private final String baseLocation;
    private final String resourceLocation;
    private final String deviceName;
    private final String nodeName;
    private final Device device;
    private final String adminAcpResource;
    private final String announceCseId;
    private final String remoteCseName;
    private boolean isPublished = false;
    private final Map<Module, SDTModuleAdaptor> modules;
    private String nodeLocation;

    public SDTDeviceAdaptor(String pParentLocation, String baseLocation, Device pDevice, String pAdminAcpResource, String pAnnounceCseId, String pRemoteCseName, boolean hasToBeAnnounced) {
        this.parentLocation = pParentLocation;
        this.baseLocation = baseLocation;
        this.hasToBeAnnounced = hasToBeAnnounced;
        this.device = pDevice;
        this.deviceName = DEVICE_PREFIX + this.device.getId();
        this.nodeName = NODE_PREFIX + this.device.getId();
        this.resourceLocation = String.valueOf(this.parentLocation) + SEP + this.deviceName;
        this.announceCseId = pAnnounceCseId;
        this.remoteCseName = pRemoteCseName;
        this.adminAcpResource = pAdminAcpResource;
        this.modules = new HashMap<Module, SDTModuleAdaptor>();
    }

    public boolean publishIntoOM2MTree() {
        logger.info((Object)("publishIntoOM2MTree(flexContainerName=" + this.deviceName + ", parentLocation:" + this.parentLocation));
        AbstractFlexContainer flexContainer = FlexContainerFactory.getSpecializationFlexContainer((String)this.device.getShortDefinitionName());
        flexContainer.setName(this.deviceName);
        flexContainer.setContainerDefinition(this.device.getDefinition());
        flexContainer.setLongName(this.device.getLongDefinitionName());
        flexContainer.setShortName(this.device.getShortDefinitionName());
        flexContainer.getAccessControlPolicyIDs().add(this.adminAcpResource);
        flexContainer.getLabels().add("id/" + this.device.getId());
        flexContainer.getLabels().add("name/" + this.device.getName());
        flexContainer.getLabels().add("pid/" + this.device.getPid());
        flexContainer.getLabels().add("object.type/device");
        flexContainer.getLabels().add("cntDef/" + this.device.getDefinition());
        flexContainer.getLabels().add("OTB.CATEGORY/Read");
        this.isPublished = true;
        Node node = new Node();
        node.setNodeID(this.nodeName);
        node.setName(this.nodeName);
        node.getAccessControlPolicyIDs().add(this.adminAcpResource);
        node.getLabels().add("object.type/node");
        node.getLabels().add("name/" + this.nodeName);
        DeviceInfo devInfo = new DeviceInfo();
        node.getMgmtObjs().add(devInfo);
        AreaNwkDeviceInfo nwkDeviceInfo = new AreaNwkDeviceInfo();
        node.getMgmtObjs().add(nwkDeviceInfo);
        nwkDeviceInfo.setAreaNwkId("TBD");
        nwkDeviceInfo.setDevID(this.device.getName());
        nwkDeviceInfo.setDevType("SDT");
        devInfo.setDeviceType(flexContainer.getContainerDefinition());
        logger.info((Object)("Node mgmtObjs: " + node.getMgmtObjs()));
        if (this.hasToBeAnnounced) {
            flexContainer.getAnnounceTo().add(SEP + this.announceCseId);
            flexContainer.getAnnouncedAttribute().add("nl");
            node.getAnnounceTo().add(SEP + this.announceCseId);
            node.getAnnouncedAttribute().add("hsl");
            devInfo.getAnnounceTo().add(SEP + this.announceCseId);
            devInfo.getAnnouncedAttribute().add("man");
            devInfo.getAnnouncedAttribute().add("dlb");
            devInfo.getAnnouncedAttribute().add("mod");
            devInfo.getAnnouncedAttribute().add("dty");
            nwkDeviceInfo.getAnnounceTo().add(SEP + this.announceCseId);
            nwkDeviceInfo.getAnnouncedAttribute().add("dvt");
        }
        for (Property sdtProperty : this.device.getProperties()) {
            logger.debug((Object)("handle SDT Property (name=" + sdtProperty.getName() + ", value=" + sdtProperty.getValue() + ", type=" + sdtProperty.getType() + ")"));
            if (sdtProperty.getType() == null || sdtProperty.getValue() == null && sdtProperty.isOptional()) continue;
            String shortName = sdtProperty.getShortName();
            if (shortName.equals(PropertyType.deviceSerialNum.getShortName())) {
                devInfo.setDeviceLabel(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.deviceFirmwareVersion.getShortName())) {
                devInfo.setFwVersion(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.deviceManufacturer.getShortName())) {
                devInfo.setManufacturer(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.deviceModelName.getShortName())) {
                devInfo.setModel(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.hardwareVersion.getShortName())) {
                devInfo.setHwVersion(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.manufacturerDetailsLink.getShortName())) {
                devInfo.setManufacturerDetailsLink(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.osVersion.getShortName())) {
                devInfo.setOsVersion(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.location.getShortName())) {
                devInfo.setLocation(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.country.getShortName())) {
                devInfo.setCountry(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.dateOfManufacture.getShortName())) {
                devInfo.setManufacturingDate(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.supportURL.getShortName())) {
                devInfo.setSupportURL(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.deviceSubModelName.getShortName())) {
                devInfo.setSubModel(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.deviceName.getShortName())) {
                devInfo.setDeviceName(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.presentationURL.getShortName())) {
                devInfo.setPresentationURL(sdtProperty.getValue());
                continue;
            }
            if (shortName.equals(PropertyType.protocol.getShortName())) {
                devInfo.setProtocol(sdtProperty.getValue());
                continue;
            }
            CustomAttribute customAttributeForSdtProperty = new CustomAttribute();
            customAttributeForSdtProperty.setShortName(shortName);
            customAttributeForSdtProperty.setValue(sdtProperty.getValue());
            logger.info((Object)("new Property CustomAttribute (" + customAttributeForSdtProperty + ")"));
            flexContainer.getCustomAttributes().add(customAttributeForSdtProperty);
        }
        flexContainer.setNodeLink(this.nodeName);
        ResponsePrimitive response = CseUtil.sendCreateFlexContainerRequest(flexContainer, this.parentLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            logger.error((Object)("unable to create a FlexContainer for SDT Device " + this.deviceName + " : " + response.getContent()), null);
            return false;
        }
        flexContainer = (AbstractFlexContainer)response.getContent();
        node.setHostedServiceLinks(flexContainer.getName());
        response = CseUtil.sendCreateNodeRequest(node, this.baseLocation);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            logger.error((Object)("unable to create a Node for SDT Device " + this.deviceName + " : " + response.getContent()), null);
            return false;
        }
        this.nodeLocation = ((Node)response.getContent()).getResourceID();
        for (Module module : this.device.getModules()) {
            SDTModuleAdaptor sdtModuleAdaptor = new SDTModuleAdaptor(module, this.resourceLocation, this.announceCseId, this.hasToBeAnnounced);
            if (sdtModuleAdaptor.publishModuleIntoOM2MTree()) {
                this.modules.put(module, sdtModuleAdaptor);
                continue;
            }
            logger.error((Object)("unable to publish module " + module.getName()), null);
            this.unpublishIntoOM2MTree();
            return false;
        }
        return true;
    }

    public void unpublishIntoOM2MTree() {
        logger.info((Object)("unpublish SDT Device (flexContainerLocation=" + this.resourceLocation + ")"));
        for (SDTModuleAdaptor module : this.modules.values()) {
            module.unpublishModuleFromOM2MTree();
        }
        CseUtil.sendDeleteRequest(this.resourceLocation);
        CseUtil.sendDeleteRequest(this.nodeLocation);
    }
}

