/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.netatmo.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.sdt.home.netatmo.model.Event;
import org.eclipse.om2m.sdt.home.netatmo.model.Person;
import org.eclipse.om2m.sdt.home.netatmo.model.WelcomeCamera;

public class Home {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String PERSONS = "persons";
    public static final String CAMERAS = "cameras";
    public static final String EVENTS = "events";
    private final String id;
    private final String name;
    private final Map<String, Person> persons;
    private final Map<String, WelcomeCamera> cameras;
    private final List<Event> events;

    public Home(String pId, String pName) {
        this.id = pId;
        this.name = pName;
        this.persons = new HashMap<String, Person>();
        this.cameras = new HashMap<String, WelcomeCamera>();
        this.events = new ArrayList<Event>();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Person getPerson(String personId) {
        Map<String, Person> map = this.persons;
        synchronized (map) {
            return this.persons.get(personId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Person> getPersons() {
        HashMap<String, Person> toBeReturned = new HashMap<String, Person>();
        Map<String, Person> map = this.persons;
        synchronized (map) {
            toBeReturned.putAll(this.persons);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrUpdatePerson(Person person) {
        Map<String, Person> map = this.persons;
        synchronized (map) {
            block4: {
                Person existingPerson = this.persons.get(person.getId());
                if (existingPerson == null) break block4;
                existingPerson.setLastSeen(person.getLastSeen());
                existingPerson.setOutOfSight(person.getOutOfSight());
                return true;
            }
            this.persons.put(person.getId(), person);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePerson(String personId) {
        Map<String, Person> map = this.persons;
        synchronized (map) {
            this.persons.remove(personId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrUpdateCamera(WelcomeCamera pCamera) {
        Map<String, WelcomeCamera> map = this.cameras;
        synchronized (map) {
            block4: {
                WelcomeCamera currentCamera = this.cameras.get(pCamera.getId());
                if (currentCamera == null) break block4;
                currentCamera.setAlimOk(pCamera.getAlimOk());
                currentCamera.setIsOn(pCamera.getIsOn());
                currentCamera.setSdOk(pCamera.getSdOk());
                currentCamera.setVpnUrl(pCamera.getVpnUrl());
                return true;
            }
            this.cameras.put(pCamera.getId(), pCamera);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, WelcomeCamera> getCameras() {
        HashMap<String, WelcomeCamera> toBeReturned = new HashMap<String, WelcomeCamera>();
        Map<String, WelcomeCamera> map = this.cameras;
        synchronized (map) {
            toBeReturned.putAll(this.cameras);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WelcomeCamera getCamera(String cameraId) {
        Map<String, WelcomeCamera> map = this.cameras;
        synchronized (map) {
            return this.cameras.get(cameraId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Event> getEvents() {
        ArrayList<Event> toBeReturned = new ArrayList<Event>();
        List<Event> list = this.events;
        synchronized (list) {
            toBeReturned.addAll(this.events);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEvents(List<Event> toBeReplacedWith) {
        List<Event> list = this.events;
        synchronized (list) {
            this.events.clear();
            this.events.addAll(toBeReplacedWith);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Home(id=").append(this.id).append(", name=").append(this.name).append(", persons=[");
        Map<String, Person> ps = this.getPersons();
        for (Person p : ps.values()) {
            sb.append(p.toString()).append(",");
        }
        sb.append("], cameras=[");
        Map<String, WelcomeCamera> cs = this.getCameras();
        for (WelcomeCamera c : cs.values()) {
            sb.append(c.toString()).append(",");
        }
        sb.append("], events=[");
        List<Event> es = this.getEvents();
        for (Event e : es) {
            sb.append(e.toString()).append(",");
        }
        sb.append("])");
        return sb.toString();
    }
}

