/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.devices;

import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.modules.BinarySwitch;
import org.eclipse.om2m.sdt.home.modules.Boiler;
import org.eclipse.om2m.sdt.home.modules.FaultDetection;
import org.eclipse.om2m.sdt.home.modules.KeepWarm;
import org.eclipse.om2m.sdt.home.modules.LiquidLevel;
import org.eclipse.om2m.sdt.home.modules.RunState;
import org.eclipse.om2m.sdt.home.modules.Temperature;
import org.eclipse.om2m.sdt.home.types.DeviceType;

public class Kettle
extends GenericDevice {
    private FaultDetection faultDetection;
    private RunState runState;
    private LiquidLevel waterLevel;
    private BinarySwitch binarySwitch;
    private Temperature temperature;
    private Boiler boiler;
    private KeepWarm keepWarm;

    public Kettle(String id, String serial, Domain domain) {
        super(id, serial, DeviceType.deviceKettle, domain);
    }

    public void addModule(Module module) {
        if (module instanceof FaultDetection) {
            this.addModule((FaultDetection)module);
        } else if (module instanceof RunState) {
            this.addModule((RunState)module);
        } else if (module instanceof LiquidLevel) {
            this.addModule((LiquidLevel)module);
        } else if (module instanceof BinarySwitch) {
            this.addModule((BinarySwitch)module);
        } else if (module instanceof KeepWarm) {
            this.addModule((KeepWarm)module);
        } else if (module instanceof Temperature) {
            this.addModule((Temperature)module);
        } else if (module instanceof Boiler) {
            this.addModule((Boiler)module);
        } else {
            super.addModule(module);
        }
    }

    public void addModule(FaultDetection mod) {
        this.faultDetection = mod;
        super.addModule((Module)this.faultDetection);
    }

    public void addModule(RunState mod) {
        this.runState = mod;
        super.addModule((Module)this.runState);
    }

    public void addModule(Boiler mod) {
        this.boiler = mod;
        super.addModule((Module)this.boiler);
    }

    public void addModule(LiquidLevel mod) {
        this.waterLevel = mod;
        super.addModule((Module)this.waterLevel);
    }

    public void addModule(BinarySwitch mod) {
        this.binarySwitch = mod;
        super.addModule((Module)this.binarySwitch);
    }

    public void addModule(Temperature mod) {
        this.temperature = mod;
        super.addModule((Module)this.temperature);
    }

    public void addModule(KeepWarm mod) {
        this.keepWarm = mod;
        super.addModule((Module)this.keepWarm);
    }

    public FaultDetection getFaultDetection() {
        return this.faultDetection;
    }

    public Temperature getTemperature() {
        return this.temperature;
    }

    public KeepWarm getKeepWarm() {
        return this.keepWarm;
    }

    public RunState getRunState() {
        return this.runState;
    }

    public LiquidLevel getWaterLevel() {
        return this.waterLevel;
    }

    public BinarySwitch getBinarySwitch() {
        return this.binarySwitch;
    }

    public Boiler getBoiler() {
        return this.boiler;
    }
}

