/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.constants.ResponseStatusCode;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.CustomAttribute;
import org.eclipse.om2m.commons.resource.ResponsePrimitive;
import org.eclipse.om2m.commons.resource.flexcontainerspec.BinarySwitchFlexContainer;
import org.eclipse.om2m.core.service.CseService;
import org.eclipse.om2m.testsuite.flexcontainer.FlexContainerTestSuite;
import org.eclipse.om2m.testsuite.flexcontainer.TestReport;

public class BinarySwitchFlexContainerTest
extends FlexContainerTestSuite {
    private BinarySwitchFlexContainerTest() {
        super(null);
    }

    public BinarySwitchFlexContainerTest(CseService pCseService) {
        super(pCseService);
    }

    @Override
    protected String getTestSuiteName() {
        return "BinarySwitchFlexContainer";
    }

    public void testCreateValidBinarySwitchFlexContainer() {
        BinarySwitchFlexContainer initialFlexContainer = new BinarySwitchFlexContainer();
        initialFlexContainer.setOntologyRef("OrangeOntologyRef");
        initialFlexContainer.setCreator("Greg");
        initialFlexContainer.setName("GregFirstBinaryFlexContainer" + System.currentTimeMillis());
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("true");
        initialFlexContainer.getCustomAttributes().add(ca);
        BinarySwitchFlexContainer responseCreatedFlexContainer = null;
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)initialFlexContainer, "/" + Constants.CSE_ID, "admin:admin");
        if (response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            responseCreatedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            try {
                this.checkFlexContainerName((AbstractFlexContainer)initialFlexContainer, (AbstractFlexContainer)responseCreatedFlexContainer);
                this.checkFlexContainerCreator((AbstractFlexContainer)initialFlexContainer, (AbstractFlexContainer)responseCreatedFlexContainer);
                this.checkFlexContainerDefinition((AbstractFlexContainer)initialFlexContainer, (AbstractFlexContainer)responseCreatedFlexContainer);
                this.checkFlexContainerOntologyRef((AbstractFlexContainer)initialFlexContainer, (AbstractFlexContainer)responseCreatedFlexContainer);
                this.checkFlexContainerCustomAttribute((AbstractFlexContainer)initialFlexContainer, (AbstractFlexContainer)responseCreatedFlexContainer);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.createTestReport("createValidBinarySwitchFlexContainer", TestReport.Status.KO, e.getMessage(), e);
                return;
            }
        } else {
            this.createTestReport("createValidBinarySwitchFlexContainer", TestReport.Status.KO, "unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.CREATED, null);
            return;
        }
        response = this.sendRetrieveRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + responseCreatedFlexContainer.getName());
        if (response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            BinarySwitchFlexContainer retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            try {
                this.checkFlexContainer((AbstractFlexContainer)responseCreatedFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.createTestReport("createValidBinarySwitchFlexContainer", TestReport.Status.KO, e.getMessage(), e);
                return;
            }
        } else {
            this.createTestReport("createValidBinarySwitchFlexContainer", TestReport.Status.KO, "unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.OK, null);
            return;
        }
        this.createTestReport("createValidBinarySwitchFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testCreateInvalidBinarySwitchFlexContainer() {
        BinarySwitchFlexContainer initialFlexContainer = new BinarySwitchFlexContainer();
        initialFlexContainer.setOntologyRef("OrangeOntologyRef");
        initialFlexContainer.setCreator("Greg");
        initialFlexContainer.setName("GregFirstBinaryFlexContainer" + System.currentTimeMillis());
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powerStateFake");
        ca.setValue("true");
        initialFlexContainer.getCustomAttributes().add(ca);
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)initialFlexContainer, "/" + Constants.CSE_ID, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.BAD_REQUEST)) {
            this.createTestReport("testCreateInvalidBinarySwitchFlexContainer", TestReport.Status.KO, "unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.BAD_REQUEST, null);
            return;
        }
        this.createTestReport("testCreateInvalidBinarySwitchFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testUpdateBinarySwitchFlexContainer() {
        BinarySwitchFlexContainer initialFlexContainer = new BinarySwitchFlexContainer();
        initialFlexContainer.setOntologyRef("OrangeOntologyRef");
        initialFlexContainer.setCreator("Greg");
        initialFlexContainer.setName("GregFirstBinaryFlexContainer" + System.currentTimeMillis());
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("true");
        initialFlexContainer.getCustomAttributes().add(ca);
        BinarySwitchFlexContainer responseCreatedFlexContainer = null;
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)initialFlexContainer, "/" + Constants.CSE_ID, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "CREATE - unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.CREATED, null);
            return;
        }
        responseCreatedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        BinarySwitchFlexContainer toBeUpdated = new BinarySwitchFlexContainer();
        ca.setValue("false");
        toBeUpdated.getCustomAttributes().add(ca);
        response = this.sendUpdateFlexContainerRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + responseCreatedFlexContainer.getName(), (AbstractFlexContainer)toBeUpdated);
        BinarySwitchFlexContainer updatedFlexContainer = null;
        if (response.getResponseStatusCode().equals(ResponseStatusCode.UPDATED)) {
            updatedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            if (!updatedFlexContainer.getCustomAttribute("powSe").getValue().equals("false")) {
                this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "unable to update powerState value to false", null);
                return;
            }
        } else {
            this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "UPDATE - unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.UPDATED, null);
            return;
        }
        response = this.sendRetrieveRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + responseCreatedFlexContainer.getName());
        if (response.getResponseStatusCode().equals(ResponseStatusCode.OK)) {
            BinarySwitchFlexContainer retrievedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
            responseCreatedFlexContainer.getCustomAttribute("powSe").setValue("false");
            try {
                this.checkFlexContainer((AbstractFlexContainer)responseCreatedFlexContainer, (AbstractFlexContainer)retrievedFlexContainer);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "updatedFlexContainer and retrievedFlexContainer are differents", e);
                return;
            }
        } else {
            this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "unable to retrieve the FlexContainer", null);
            return;
        }
        this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteBinarySwitchFlexContainer() {
        BinarySwitchFlexContainer initialFlexContainer = new BinarySwitchFlexContainer();
        initialFlexContainer.setContainerDefinition("org.onem2m.home.moduleclass.binaryswitch");
        initialFlexContainer.setOntologyRef("OrangeOntologyRef");
        initialFlexContainer.setCreator("Greg");
        initialFlexContainer.setName("GregFirstBinaryFlexContainer" + System.currentTimeMillis());
        CustomAttribute ca = new CustomAttribute();
        ca.setShortName("powSe");
        ca.setValue("true");
        initialFlexContainer.getCustomAttributes().add(ca);
        BinarySwitchFlexContainer responseCreatedFlexContainer = null;
        ResponsePrimitive response = this.sendCreateFlexContainerRequest((AbstractFlexContainer)initialFlexContainer, "/" + Constants.CSE_ID, Constants.ADMIN_REQUESTING_ENTITY);
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.CREATED)) {
            this.createTestReport("testUpdateBinarySwitchFlexContainer", TestReport.Status.KO, "CREATE - unexpected response status code :" + response.getResponseStatusCode() + ", expected status code:" + ResponseStatusCode.CREATED, null);
            return;
        }
        responseCreatedFlexContainer = (BinarySwitchFlexContainer)response.getContent();
        response = this.sendDeleteRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + responseCreatedFlexContainer.getName());
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.DELETED)) {
            this.createTestReport("testDeleteBinarySwitchFlexContainer", TestReport.Status.KO, "DELETE - unexpected response status code:" + response.getResponseStatusCode() + ", expected:" + ResponseStatusCode.DELETED, null);
            return;
        }
        response = this.sendRetrieveRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/" + responseCreatedFlexContainer.getName());
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteBinarySwitchFlexContainer", TestReport.Status.KO, "DELETE - unexpected response status code:" + response.getResponseStatusCode() + ", expected:" + ResponseStatusCode.NOT_FOUND, null);
            return;
        }
        this.createTestReport("testDeleteBinarySwitchFlexContainer", TestReport.Status.OK, null, null);
    }

    public void testDeleteUnknownBinarySwitch() {
        ResponsePrimitive response = this.sendDeleteRequest("/" + Constants.CSE_ID + "/" + Constants.CSE_NAME + "/UNKNOWN_FLEXCONTAINER");
        if (!response.getResponseStatusCode().equals(ResponseStatusCode.NOT_FOUND)) {
            this.createTestReport("testDeleteUnknownBinarySwitch", TestReport.Status.KO, "DELETE - unexpected response status code:" + response.getResponseStatusCode() + ", expected:" + ResponseStatusCode.NOT_FOUND, null);
            return;
        }
        this.createTestReport("testDeleteUnknownBinarySwitch", TestReport.Status.OK, null, null);
    }
}

