/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.hue;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.om2m.hue.api.HueBridgeDevice;
import org.eclipse.om2m.hue.api.HueLightDevice;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.home.HomeDomain;
import org.eclipse.om2m.sdt.home.devices.GenericDevice;
import org.eclipse.om2m.sdt.home.driver.Logger;
import org.eclipse.om2m.sdt.home.driver.Utils;
import org.eclipse.om2m.sdt.home.hue.HomeLight;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.log.LogService;

public class Activator {
    private static final String PROTOCOL = "Hue";
    private Domain domain;
    private List<ServiceReference> refs;
    private Map<String, HomeLight> lights;
    private boolean activated;
    private BundleContext context;
    static Logger logger;

    public Activator() {
        logger = new Logger(PROTOCOL);
        logger.info("ctor");
        this.domain = new HomeDomain("Philips Hue Domain");
        this.refs = new ArrayList<ServiceReference>();
        this.lights = new HashMap<String, HomeLight>();
    }

    public void activate(ComponentContext componentContext) throws Exception {
        this.context = componentContext.getBundleContext();
        logger.info("Activating");
        for (ServiceReference ref : this.refs) {
            try {
                this.addLight(ref);
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        }
        this.refs.clear();
        this.activated = true;
        logger.info("Activated " + this.domain.prettyPrint());
    }

    public void deactivate(ComponentContext componentContext) throws Exception {
        this.activated = false;
        for (HomeLight light : this.lights.values()) {
            light.unregister();
        }
        this.lights.clear();
    }

    public void setHueLightDevice(ServiceReference ref) {
        logger.info("Add Hue light " + ref);
        if (this.activated) {
            try {
                this.addLight(ref);
            }
            catch (Throwable t) {
                logger.error("", t);
            }
        } else {
            this.refs.add(ref);
        }
    }

    public void unsetHueLightDevice(ServiceReference ref) {
        HueLightDevice hue = (HueLightDevice)this.context.getService(ref);
        logger.info("Removed Hue light " + hue);
        HomeLight light = this.lights.remove(hue.getId());
        if (light != null) {
            light.unregister();
            this.domain.removeDevice(light.getId());
        }
    }

    public void setHueBridgeDevice(HueBridgeDevice bridge) {
        logger.info("Add Hue bridge " + bridge);
    }

    public void unsetHueBridgeDevice(HueBridgeDevice bridge) {
        logger.info("Removed Hue bridge " + bridge);
    }

    public void setLog(LogService logService) {
        logger.setLogService((Object)logService);
    }

    public void unsetLog(LogService logService) {
        logger.unsetLogService();
    }

    private void addLight(ServiceReference ref) {
        if (Boolean.TRUE.equals(ref.getProperty("otb.proxied"))) {
            logger.info("proxied Hue light, ignore");
            return;
        }
        HueLightDevice hue = (HueLightDevice)this.context.getService(ref);
        logger.info("Added Hue light " + hue);
        HomeLight light = new HomeLight(hue, this.domain);
        light.setProtocol(PROTOCOL);
        Utils.setProperties((ServiceReference)ref, (GenericDevice)light);
        String[] stringArray = ref.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            Object val = ref.getProperty(prop);
            logger.info("prop " + prop + " / " + val);
            if (prop.equals("UPnP.device.manufacturerURL")) {
                try {
                    light.setManufacturerDetailsLink(new URL(val.toString()));
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (prop.equals("UPnP.presentationURL")) {
                try {
                    light.setPresentationURL(new URL(val.toString()));
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (prop.equals("UPnP.device.modelURL")) {
                try {
                    light.setSupportURL(new URL(val.toString()));
                }
                catch (MalformedURLException malformedURLException) {}
            }
            ++n2;
        }
        light.register(this.context);
        this.lights.put(hue.getId(), light);
    }
}

