/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.entitymapper;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.om2m.commons.constants.ResultContent;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;
import org.eclipse.om2m.commons.resource.AbstractFlexContainer;
import org.eclipse.om2m.commons.resource.AnnounceableResource;
import org.eclipse.om2m.commons.resource.ChildResourceRef;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.core.entitymapper.ContentInstanceMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapper;
import org.eclipse.om2m.core.entitymapper.EntityMapperFactory;
import org.eclipse.om2m.core.entitymapper.FlexContainerMapper;
import org.eclipse.om2m.core.entitymapper.SubscriptionMapper;

public class ContainerMapper
extends EntityMapper<ContainerEntity, Container> {
    @Override
    protected Container createResource() {
        return new Container();
    }

    @Override
    protected void mapAttributes(ContainerEntity entity, Container resource, int level, int offset) {
        if (level < 0) {
            return;
        }
        EntityMapperFactory.getAnnounceableSubordonateEntity_AnnounceableResourceMapper().mapAttributes((AnnounceableSubordinateEntity)entity, (AnnounceableResource)resource, level, offset);
        resource.setCreator(entity.getCreator());
        resource.setCurrentByteSize(BigInteger.valueOf(entity.getCurrentByteSize()));
        resource.setCurrentNrOfInstances(entity.getCurrentNrOfInstances());
        resource.setLocationID(entity.getLocationID());
        resource.setMaxByteSize(entity.getMaxByteSize());
        resource.setMaxInstanceAge(entity.getMaxInstanceAge());
        resource.setMaxNrOfInstances(entity.getMaxNrOfInstances());
        resource.setOntologyRef(entity.getOntologyRef());
        resource.setStateTag(entity.getStateTag());
        resource.setOldest(String.valueOf(entity.getHierarchicalURI()) + "/" + "ol");
        resource.setLatest(String.valueOf(entity.getHierarchicalURI()) + "/" + "la");
    }

    @Override
    protected List<ChildResourceRef> getChildResourceRef(ContainerEntity entity, int level, int offset) {
        ChildResourceRef child;
        ArrayList<ChildResourceRef> childRefs = new ArrayList<ChildResourceRef>();
        if (level == 0) {
            return childRefs;
        }
        for (ContentInstanceEntity cin : entity.getChildContentInstances()) {
            child = new ChildResourceRef();
            child.setResourceName(cin.getName());
            child.setType(4);
            child.setValue(cin.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContentInstanceMapper().getChildResourceRef(cin, level - 1, offset - 1));
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            child = new ChildResourceRef();
            child.setResourceName(sub.getName());
            child.setType(23);
            child.setValue(sub.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new SubscriptionMapper().getChildResourceRef(sub, level - 1, offset - 1));
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(childCont.getName());
            child.setType(3);
            child.setValue(childCont.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new ContainerMapper().getChildResourceRef(childCont, level - 1, offset - 1));
        }
        for (FlexContainerEntity childFlexCont : entity.getChildFlexContainers()) {
            child = new ChildResourceRef();
            child.setResourceName(childFlexCont.getName());
            child.setType(28);
            child.setValue(childFlexCont.getResourceID());
            childRefs.add(child);
            childRefs.addAll(new FlexContainerMapper().getChildResourceRef(childFlexCont, level - 1, offset - 1));
        }
        return childRefs;
    }

    @Override
    protected void mapChildResourceRef(ContainerEntity entity, Container resource, int level, int offset) {
        resource.getChildResource().addAll(this.getChildResourceRef(entity, level, offset));
    }

    @Override
    protected void mapChildResources(ContainerEntity entity, Container resource, int level, int offset) {
        for (ContentInstanceEntity cin : entity.getChildContentInstances()) {
            ContentInstance cinRes = (ContentInstance)new ContentInstanceMapper().mapEntityToResource(cin, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContentInstanceOrContainerOrSubscription().add(cinRes);
        }
        for (SubscriptionEntity sub : entity.getSubscriptions()) {
            Subscription subRes = (Subscription)new SubscriptionMapper().mapEntityToResource(sub, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContentInstanceOrContainerOrSubscription().add(subRes);
        }
        for (ContainerEntity childCont : entity.getChildContainers()) {
            Container cnt = (Container)new ContainerMapper().mapEntityToResource(childCont, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContentInstanceOrContainerOrSubscription().add(cnt);
        }
        for (FlexContainerEntity childFlexCont : entity.getChildFlexContainers()) {
            AbstractFlexContainer fcnt = (AbstractFlexContainer)new FlexContainerMapper().mapEntityToResource(childFlexCont, ResultContent.ATTRIBUTES_AND_CHILD_RES, level - 1, offset - 1);
            resource.getContentInstanceOrContainerOrSubscription().add(fcnt);
        }
    }
}

