/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.testsuite.flexcontainer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.om2m.commons.constants.Constants;
import org.eclipse.om2m.commons.resource.Notification;
import org.eclipse.om2m.datamapping.service.DataMapperService;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;

public class SubscriptionServlet
extends HttpServlet {
    private final DataMapperService dataMapperService;
    private final HttpService httpService;
    private List<Notification> receivedNotifications = new ArrayList<Notification>();
    private String servletPath = "/NotificationServlet_" + System.currentTimeMillis();

    public SubscriptionServlet(HttpService pHttpService, DataMapperService pDataMapperService) {
        this.httpService = pHttpService;
        this.dataMapperService = pDataMapperService;
    }

    public void registerServlet() throws ServletException, NamespaceException {
        this.httpService.registerServlet(this.servletPath, (Servlet)this, null, null);
    }

    public void unregisterServlet() {
        this.httpService.unregister(this.servletPath);
    }

    public String getServletUrl() {
        return "http://" + Constants.CSE_IP + ":" + Constants.CSE_PORT + this.servletPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream()));
        String line = null;
        StringBuffer sb = new StringBuffer();
        while ((line = br.readLine()) != null) {
            sb.append(line);
        }
        Notification notification = (Notification)this.dataMapperService.stringToObj(sb.toString());
        List<Notification> list = this.receivedNotifications;
        synchronized (list) {
            System.out.println("receive a new notification: " + notification.toString());
            this.receivedNotifications.add(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Notification getLastNotification() {
        List<Notification> list = this.receivedNotifications;
        synchronized (list) {
            if (!this.receivedNotifications.isEmpty()) {
                return this.receivedNotifications.get(this.receivedNotifications.size() - 1);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Notification> getNotifications() {
        ArrayList<Notification> toBeReturned = new ArrayList<Notification>();
        List<Notification> list = this.receivedNotifications;
        synchronized (list) {
            toBeReturned.addAll(this.receivedNotifications);
        }
        return toBeReturned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetNotifications() {
        List<Notification> list = this.receivedNotifications;
        synchronized (list) {
            this.receivedNotifications.clear();
        }
    }
}

