/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.constants.MgmtDefinitionTypes;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnounceableSubordinateEntity;
import org.eclipse.om2m.commons.entities.AreaNwkDeviceInfoEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.DeviceInfoEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.MgmtObjEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Inheritance(strategy=InheritanceType.JOINED)
@Entity(name="NODE")
public class NodeEntity
extends AnnounceableSubordinateEntity {
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="NOD_ACP_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> linkedAcps;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedNodeEntities")
    @JoinTable(name="NOD_DAC_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @Column(name="ni")
    protected String nodeID;
    @Column(name="hcl")
    protected String hostedCSELink;
    @Column(name="hsl")
    protected String hostedServiceLinks;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=CSEBaseEntity.class)
    @JoinTable(name="CSB_NOD_CH_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSEB_ID", referencedColumnName="ri")})
    protected CSEBaseEntity parentCsb;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_NOD_CH_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="NOD_SUB_JOIN", joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentNode")
    @JoinTable(name="ANI_NOD_JOIN", inverseJoinColumns={@JoinColumn(name="ANI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkInfoEntity> childAreaNwkInfoEntities;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentNode")
    @JoinTable(name="ANDI_NOD_JOIN", inverseJoinColumns={@JoinColumn(name="ANDI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<AreaNwkDeviceInfoEntity> childAreaNwkDeviceInfoEntities;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="parentNode")
    @JoinTable(name="DVI_NOD_JOIN", inverseJoinColumns={@JoinColumn(name="DVI_JOIN_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="NOD_JOIN_ID", referencedColumnName="ri")})
    protected List<DeviceInfoEntity> childDeviceInfoEntities;

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.linkedAcps == null) {
            this.linkedAcps = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.linkedAcps;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.linkedAcps = accessControlPolicies;
    }

    public String getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public String getHostedCSELink() {
        return this.hostedCSELink;
    }

    public void setHostedCSELink(String hostedCSELink) {
        this.hostedCSELink = hostedCSELink;
    }

    public String getHostedServiceLinks() {
        return this.hostedServiceLinks;
    }

    public void setHostedServiceLinks(String hostedServiceLinks) {
        this.hostedServiceLinks = hostedServiceLinks;
    }

    public CSEBaseEntity getParentCsb() {
        return this.parentCsb;
    }

    public void setParentCsb(CSEBaseEntity parentCsb) {
        this.parentCsb = parentCsb;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    public List<AreaNwkInfoEntity> getChildAreaNwkInfoEntities() {
        if (this.childAreaNwkInfoEntities == null) {
            this.childAreaNwkInfoEntities = new ArrayList<AreaNwkInfoEntity>();
        }
        return this.childAreaNwkInfoEntities;
    }

    public void setChildAreaNwkInfoEntities(List<AreaNwkInfoEntity> childAreaNwkInfoEntities) {
        this.childAreaNwkInfoEntities = childAreaNwkInfoEntities;
    }

    public List<AreaNwkDeviceInfoEntity> getChildAreaNwkDeviceInfoEntities() {
        if (this.childAreaNwkDeviceInfoEntities == null) {
            this.childAreaNwkDeviceInfoEntities = new ArrayList<AreaNwkDeviceInfoEntity>();
        }
        return this.childAreaNwkDeviceInfoEntities;
    }

    public void setChildAreaNwkDeviceInfoEntities(List<AreaNwkDeviceInfoEntity> childAreaNwkDeviceInfoEntities) {
        this.childAreaNwkDeviceInfoEntities = childAreaNwkDeviceInfoEntities;
    }

    public List<DeviceInfoEntity> getChildDeviceInfoEntities() {
        if (this.childDeviceInfoEntities == null) {
            this.childDeviceInfoEntities = new ArrayList<DeviceInfoEntity>();
        }
        return this.childDeviceInfoEntities;
    }

    public void setChildDeviceInfoEntities(List<DeviceInfoEntity> childDeviceInfoEntities) {
        this.childDeviceInfoEntities = childDeviceInfoEntities;
    }

    public List<MgmtObjEntity> getMgmtObjEntities() {
        ArrayList<MgmtObjEntity> ret = new ArrayList<MgmtObjEntity>();
        ret.addAll(this.getChildAreaNwkInfoEntities());
        ret.addAll(this.getChildAreaNwkDeviceInfoEntities());
        ret.addAll(this.getChildDeviceInfoEntities());
        return ret;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    public void addMgmtObj(MgmtObjEntity mgmtObj) {
        BigInteger mgmtDef = mgmtObj.getMgmtDefinition();
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.getChildAreaNwkInfoEntities().add((AreaNwkInfoEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.getChildAreaNwkDeviceInfoEntities().add((AreaNwkDeviceInfoEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.getChildDeviceInfoEntities().add((DeviceInfoEntity)mgmtObj);
        }
    }

    public void removeMgmtObj(MgmtObjEntity mgmtObj) {
        BigInteger mgmtDef = mgmtObj.getMgmtDefinition();
        if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_INFO)) {
            this.getChildAreaNwkInfoEntities().remove((AreaNwkInfoEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.AREA_NWK_DEVICE_INFO)) {
            this.getChildAreaNwkDeviceInfoEntities().remove((AreaNwkDeviceInfoEntity)mgmtObj);
        } else if (mgmtDef.equals(MgmtDefinitionTypes.DEVICE_INFO)) {
            this.getChildDeviceInfoEntities().remove((DeviceInfoEntity)mgmtObj);
        }
    }
}

