/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.persistence.mongodb.dao;

import com.mongodb.client.FindIterable;
import com.mongodb.client.model.Filters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bson.Document;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AeAnncEntity;
import org.eclipse.om2m.commons.entities.AeEntity;
import org.eclipse.om2m.commons.entities.AreaNwkInfoEntity;
import org.eclipse.om2m.commons.entities.CSEBaseEntity;
import org.eclipse.om2m.commons.entities.ContainerEntity;
import org.eclipse.om2m.commons.entities.ContentInstanceEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.FlexContainerEntity;
import org.eclipse.om2m.commons.entities.GroupEntity;
import org.eclipse.om2m.commons.entities.LabelEntity;
import org.eclipse.om2m.commons.entities.NodeEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.persistence.mongodb.DBServiceImpl;
import org.eclipse.om2m.persistence.service.DAO;
import org.eclipse.om2m.persistence.service.DBTransaction;

public class LabelEntityDao
implements DAO<LabelEntity> {
    private static final Log LOGGER = LogFactory.getLog(LabelEntityDao.class);

    public void create(DBTransaction dbTransaction, LabelEntity resource) {
    }

    public LabelEntity find(DBTransaction dbTransaction, Object id) {
        LOGGER.info((Object)("LabelEntityDAO.find(id=" + id + ")"));
        LabelEntity labelEntity = null;
        FindIterable elements = DBServiceImpl.getInstance().getResourceCollection().find(Filters.eq((String)"LabelsEntities", (Object)Filters.eq((String)"label", (Object)id)));
        if (elements != null) {
            labelEntity = new LabelEntity((String)id);
            for (Document element : elements) {
                Integer resourceType = element.getInteger((Object)"ResourceType");
                switch (resourceType) {
                    case 2: {
                        AeEntity aeEntity = (AeEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), AeEntity.class);
                        labelEntity.getLinkedAe().add(aeEntity);
                        break;
                    }
                    case 10002: {
                        AeAnncEntity aeAnncEntity = (AeAnncEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), AeAnncEntity.class);
                        labelEntity.getLinkedAeA().add(aeAnncEntity);
                        break;
                    }
                    case 4: {
                        ContentInstanceEntity contentInstanceEntity = (ContentInstanceEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), ContentInstanceEntity.class);
                        labelEntity.getLinkedCin().add(contentInstanceEntity);
                        break;
                    }
                    case 3: {
                        ContainerEntity containerEntity = (ContainerEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), ContainerEntity.class);
                        labelEntity.getLinkedCnt().add(containerEntity);
                        break;
                    }
                    case 9: {
                        GroupEntity cfr_ignored_0 = (GroupEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), GroupEntity.class);
                        break;
                    }
                    case 16: {
                        RemoteCSEEntity remoteCseEntity = (RemoteCSEEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), RemoteCSEEntity.class);
                        labelEntity.getLinkedCsr().add(remoteCseEntity);
                        break;
                    }
                    case 5: {
                        CSEBaseEntity cfr_ignored_1 = (CSEBaseEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), CSEBaseEntity.class);
                        break;
                    }
                    case 28: {
                        FlexContainerEntity flexContainerEntity = (FlexContainerEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), FlexContainerEntity.class);
                        labelEntity.getLinkedFcnt().add(flexContainerEntity);
                        break;
                    }
                    case 10028: {
                        FlexContainerAnncEntity flexContainerAnncEntity = (FlexContainerAnncEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), FlexContainerAnncEntity.class);
                        labelEntity.getLinkedFcntA().add(flexContainerAnncEntity);
                        break;
                    }
                    case 1: {
                        AccessControlPolicyEntity accessControlPolicyEntity = (AccessControlPolicyEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), AccessControlPolicyEntity.class);
                        labelEntity.getLinkedACP().add(accessControlPolicyEntity);
                        break;
                    }
                    case 14: {
                        NodeEntity nodeEntity = (NodeEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), NodeEntity.class);
                        labelEntity.getLinkedNodes().add(nodeEntity);
                        break;
                    }
                    case 13: {
                        AreaNwkInfoEntity areaNetworkInfoEntity = (AreaNwkInfoEntity)DBServiceImpl.getInstance().getGson().fromJson(element.toJson(), AreaNwkInfoEntity.class);
                        labelEntity.getLinkedAni().add(areaNetworkInfoEntity);
                        break;
                    }
                }
            }
        }
        return labelEntity;
    }

    public void update(DBTransaction dbTransaction, LabelEntity resource) {
    }

    public void delete(DBTransaction dbTransaction, LabelEntity resource) {
    }
}

