/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.sdt.home.modules;

import java.util.Map;
import org.eclipse.om2m.sdt.DataPoint;
import org.eclipse.om2m.sdt.Domain;
import org.eclipse.om2m.sdt.Identifiers;
import org.eclipse.om2m.sdt.Module;
import org.eclipse.om2m.sdt.datapoints.BooleanDataPoint;
import org.eclipse.om2m.sdt.exceptions.AccessException;
import org.eclipse.om2m.sdt.exceptions.DataPointException;
import org.eclipse.om2m.sdt.home.types.AlertColourCode;
import org.eclipse.om2m.sdt.home.types.DatapointType;
import org.eclipse.om2m.sdt.home.types.ModuleType;
import org.eclipse.om2m.sdt.home.types.Tone;

public class AlarmSpeaker
extends Module {
    private Tone tone;
    private BooleanDataPoint alarmStatus;
    private AlertColourCode light;

    public AlarmSpeaker(String name, Domain domain, BooleanDataPoint alarmStatus) {
        super(name, domain, (Identifiers)ModuleType.alarmSpeaker);
        if (alarmStatus == null || !alarmStatus.getShortDefinitionType().equals(DatapointType.alarmStatus.getShortName())) {
            domain.removeModule(this.getName());
            throw new IllegalArgumentException("Wrong alarmStatus datapoint: " + alarmStatus);
        }
        this.alarmStatus = alarmStatus;
        this.alarmStatus.setDoc("\"True\" indicates the alarm start while \"False\" indicates the alarm stop");
        this.addDataPoint((DataPoint)this.alarmStatus);
    }

    public AlarmSpeaker(String name, Domain domain, Map<String, DataPoint> dps) {
        this(name, domain, (BooleanDataPoint)dps.get(DatapointType.alarmStatus.getShortName()));
        AlertColourCode light;
        Tone tone = (Tone)dps.get(DatapointType.tone.getShortName());
        if (tone != null) {
            this.setTone(tone);
        }
        if ((light = (AlertColourCode)dps.get(DatapointType.light.getShortName())) != null) {
            this.setLight(light);
        }
    }

    public boolean getAlarmStatus() throws DataPointException, AccessException {
        return (Boolean)this.alarmStatus.getValue();
    }

    public void setAlarmStatus(boolean b) throws DataPointException, AccessException {
        this.alarmStatus.setValue((Object)b);
    }

    protected void setAlarmStatus(BooleanDataPoint dp) throws DataPointException {
        this.alarmStatus = dp;
    }

    public void setTone(Tone dp) {
        this.tone = dp;
        this.tone.setDoc("Representing the tones of the alarm");
        this.tone.setOptional(true);
        this.addDataPoint((DataPoint)this.tone);
    }

    public int getTone() throws DataPointException, AccessException {
        if (this.tone == null) {
            throw new UnsupportedOperationException("Not implemented");
        }
        return (Integer)this.tone.getValue();
    }

    public void setTone(int v) throws DataPointException, AccessException {
        if (this.tone == null) {
            throw new UnsupportedOperationException("Not implemented");
        }
        this.tone.setValue(v);
    }

    public void setLight(AlertColourCode dp) {
        this.light = dp;
        this.light.setDoc("Representing the lighting mode of the alarm");
        this.light.setOptional(true);
        this.addDataPoint((DataPoint)this.light);
    }

    public int getLight() throws DataPointException, AccessException {
        if (this.light == null) {
            throw new UnsupportedOperationException("Not implemented");
        }
        return (Integer)this.light.getValue();
    }

    public void setLight(int v) throws DataPointException, AccessException {
        if (this.light == null) {
            throw new UnsupportedOperationException("Not implemented");
        }
        this.light.setValue(v);
    }
}

