/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.entities;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import org.eclipse.om2m.commons.entities.AccessControlPolicyEntity;
import org.eclipse.om2m.commons.entities.AnnouncedResourceEntity;
import org.eclipse.om2m.commons.entities.DynamicAuthorizationConsultationEntity;
import org.eclipse.om2m.commons.entities.FlexContainerAnncEntity;
import org.eclipse.om2m.commons.entities.RemoteCSEEntity;
import org.eclipse.om2m.commons.entities.SubscriptionEntity;

@Entity(name="AEA")
@Inheritance(strategy=InheritanceType.JOINED)
public class AeAnncEntity
extends AnnouncedResourceEntity {
    @Column(name="apn")
    protected String appName;
    @Column(name="api", nullable=false)
    protected String appID;
    @Column(name="aei", nullable=false)
    protected String aeid;
    @Column(name="poa")
    protected List<String> pointOfAccess;
    @Column(name="or")
    protected String ontologyRef;
    @Column(name="nl")
    protected String nodeLink;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=SubscriptionEntity.class, cascade={CascadeType.ALL})
    @JoinTable(name="AEANNCSUB_JOIN_ID", joinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="SUB_ID", referencedColumnName="ri")})
    protected List<SubscriptionEntity> subscriptions;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="AEANNC_ACP", joinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="ACP_ID", referencedColumnName="ri")})
    protected List<AccessControlPolicyEntity> accessControlPolicies;
    @ManyToMany(fetch=FetchType.LAZY, mappedBy="linkedAeAnncEntities")
    @JoinTable(name="AEANNC_DAC_JOIN", joinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="DAC_JOINID", referencedColumnName="ri")})
    protected List<DynamicAuthorizationConsultationEntity> dynamicAuthorizationConsultations;
    @ManyToOne(fetch=FetchType.LAZY, targetEntity=RemoteCSEEntity.class)
    @JoinTable(name="CSR_AEANNCH_JOIN", inverseJoinColumns={@JoinColumn(name="CSR_ID", referencedColumnName="ri")}, joinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")})
    protected RemoteCSEEntity parentCsr;
    @OneToMany(fetch=FetchType.LAZY, targetEntity=FlexContainerAnncEntity.class, mappedBy="parentAeAnnc", cascade={CascadeType.ALL})
    @JoinTable(name="AEANNC_FCNTA_JOIN", joinColumns={@JoinColumn(name="AEANNC_ID", referencedColumnName="ri")}, inverseJoinColumns={@JoinColumn(name="FCNTA_ID", referencedColumnName="ri")})
    protected List<FlexContainerAnncEntity> flexContainerAnncs;

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }

    public String getAppID() {
        return this.appID;
    }

    public void setAppID(String appID) {
        this.appID = appID;
    }

    public String getAeid() {
        return this.aeid;
    }

    public void setAeid(String aeid) {
        this.aeid = aeid;
    }

    public List<String> getPointOfAccess() {
        if (this.pointOfAccess == null) {
            this.pointOfAccess = new ArrayList<String>();
        }
        return this.pointOfAccess;
    }

    public void setPointOfAccess(List<String> pointOfAccess) {
        this.pointOfAccess = pointOfAccess;
    }

    public String getOntologyRef() {
        return this.ontologyRef;
    }

    public void setOntologyRef(String ontologyRef) {
        this.ontologyRef = ontologyRef;
    }

    public String getNodeLink() {
        return this.nodeLink;
    }

    public void setNodeLink(String nodeLink) {
        this.nodeLink = nodeLink;
    }

    public List<SubscriptionEntity> getSubscriptions() {
        if (this.subscriptions == null) {
            this.subscriptions = new ArrayList<SubscriptionEntity>();
        }
        return this.subscriptions;
    }

    public void setSubscriptions(List<SubscriptionEntity> subscriptions) {
        this.subscriptions = subscriptions;
    }

    @Override
    public List<AccessControlPolicyEntity> getAccessControlPolicies() {
        if (this.accessControlPolicies == null) {
            this.accessControlPolicies = new ArrayList<AccessControlPolicyEntity>();
        }
        return this.accessControlPolicies;
    }

    @Override
    public void setAccessControlPolicies(List<AccessControlPolicyEntity> accessControlPolicies) {
        this.accessControlPolicies = accessControlPolicies;
    }

    @Override
    public List<DynamicAuthorizationConsultationEntity> getDynamicAuthorizationConsultations() {
        if (this.dynamicAuthorizationConsultations == null) {
            this.dynamicAuthorizationConsultations = new ArrayList<DynamicAuthorizationConsultationEntity>();
        }
        return this.dynamicAuthorizationConsultations;
    }

    @Override
    public void setDynamicAuthorizationConsultations(List<DynamicAuthorizationConsultationEntity> list) {
        this.dynamicAuthorizationConsultations = list;
    }

    public RemoteCSEEntity getParentCsr() {
        return this.parentCsr;
    }

    public void setParentCsr(RemoteCSEEntity parentCsr) {
        this.parentCsr = parentCsr;
    }

    public List<FlexContainerAnncEntity> getFlexContainerAnncs() {
        if (this.flexContainerAnncs == null) {
            this.flexContainerAnncs = new ArrayList<FlexContainerAnncEntity>();
        }
        return this.flexContainerAnncs;
    }

    public void setFlexContainerAnncs(List<FlexContainerAnncEntity> flexContainerAnncs) {
        this.flexContainerAnncs = flexContainerAnncs;
    }
}

