/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.ipu.sample;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.om2m.commons.obix.Contract;
import org.eclipse.om2m.commons.obix.Obj;
import org.eclipse.om2m.commons.obix.Op;
import org.eclipse.om2m.commons.obix.Str;
import org.eclipse.om2m.commons.obix.Uri;
import org.eclipse.om2m.commons.obix.io.ObixEncoder;
import org.eclipse.om2m.commons.resource.AnyURIList;
import org.eclipse.om2m.commons.resource.Application;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ContentInstance;
import org.eclipse.om2m.commons.resource.Group;
import org.eclipse.om2m.commons.resource.MemberType;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.ipu.sample.SampleMonitor;

public class Switchs {
    private static Log LOGGER = LogFactory.getLog(Switchs.class);
    public static final String APP_ID = "LAMP_ALL";
    static final String GROUP_ON = "ON_ALL";
    static final String GROUP_OFF = "OFF_ALL";
    public static final String METHOD = "CREATE";

    public static void postGroups(String aPoCPath, String type, String location, List<String> keys) {
        Group groupON = new Group();
        groupON.setId(GROUP_ON);
        groupON.setMemberType(MemberType.APPLICATION);
        Group groupOFF = new Group();
        groupOFF.setId(GROUP_OFF);
        groupOFF.setMemberType(MemberType.APPLICATION);
        AnyURIList membersON = new AnyURIList();
        AnyURIList membersOFF = new AnyURIList();
        int i = 0;
        while (i < keys.size()) {
            membersON.getReference().add(String.valueOf(SampleMonitor.SCLID) + "/applications/" + keys.get(i) + "/" + aPoCPath + "/true");
            membersOFF.getReference().add(String.valueOf(SampleMonitor.SCLID) + "/applications/" + keys.get(i) + "/" + aPoCPath + "/false");
            ++i;
        }
        groupON.setMembers(membersON);
        groupOFF.setMembers(membersOFF);
        SampleMonitor.SCL.doRequest(new RequestIndication(METHOD, String.valueOf(SampleMonitor.SCLID) + "/groups", SampleMonitor.REQENTITY, (Resource)groupON));
        SampleMonitor.SCL.doRequest(new RequestIndication(METHOD, String.valueOf(SampleMonitor.SCLID) + "/groups", SampleMonitor.REQENTITY, (Resource)groupOFF));
        ResponseConfirm response = SampleMonitor.SCL.doRequest(new RequestIndication(METHOD, String.valueOf(SampleMonitor.SCLID) + "/applications", SampleMonitor.REQENTITY, (Resource)new Application(APP_ID)));
        if (response.getStatusCode().equals((Object)StatusCode.STATUS_CREATED)) {
            SampleMonitor.SCL.doRequest(new RequestIndication(METHOD, String.valueOf(SampleMonitor.SCLID) + "/applications/" + APP_ID + "/containers", SampleMonitor.REQENTITY, (Resource)new Container("DESCRIPTOR")));
            String content = Switchs.getDescriptorRep(SampleMonitor.SCLID, APP_ID, type, location, "DESCRIPTOR");
            String targetID = String.valueOf(SampleMonitor.SCLID) + "/applications/" + APP_ID + "/containers/" + "DESCRIPTOR" + "/contentInstances";
            SampleMonitor.SCL.doRequest(new RequestIndication(METHOD, targetID, SampleMonitor.REQENTITY, (Resource)new ContentInstance(content.getBytes())));
        }
    }

    public static String getDescriptorRep(String sclId, String appId, String type, String location, String stateCont) {
        LOGGER.info((Object)"Descriptor Representation Construction");
        Obj obj = new Obj();
        obj.add((Object)new Str("type", type));
        obj.add((Object)new Str("location", location));
        obj.add((Object)new Str("appId", appId));
        Op opON = new Op();
        opON.setName("switchAllON");
        opON.setHref(new Uri(String.valueOf(sclId) + "/groups/" + GROUP_ON + "/membersContent"));
        opON.setIs(new Contract("execute"));
        opON.setIn(new Contract("obix:Nil"));
        opON.setOut(new Contract("obix:Nil"));
        obj.add((Object)opON);
        Op opOFF = new Op();
        opOFF.setName("switchAllOFF");
        opOFF.setHref(new Uri(String.valueOf(sclId) + "/groups/" + GROUP_OFF + "/membersContent"));
        opOFF.setIs(new Contract("execute"));
        opOFF.setIn(new Contract("obix:Nil"));
        opOFF.setOut(new Contract("obix:Nil"));
        obj.add((Object)opOFF);
        return ObixEncoder.toString((Obj)obj);
    }

    public static void switchLamp(String appId, boolean newState) {
        SampleMonitor.SCL.doRequest(new RequestIndication("EXECUTE", String.valueOf(SampleMonitor.SCLID) + "/applications/" + appId + "/" + "lamps" + "/" + newState, SampleMonitor.REQENTITY, ""));
    }

    public static void switchAll(boolean newState) {
        if (newState) {
            SampleMonitor.SCL.doRequest(new RequestIndication("EXECUTE", String.valueOf(SampleMonitor.SCLID) + "/groups/" + GROUP_ON + "/membersContent", SampleMonitor.REQENTITY, ""));
        } else {
            SampleMonitor.SCL.doRequest(new RequestIndication("EXECUTE", String.valueOf(SampleMonitor.SCLID) + "/groups/" + GROUP_OFF + "/membersContent", SampleMonitor.REQENTITY, ""));
        }
    }
}

