/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ContainerAnnc;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class ContainerAnncController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        ContainerAnnc containerAnnc = null;
        try {
            containerAnnc = (ContainerAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (containerAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (containerAnnc.getId() != null && DAOFactory.getContainerAnncDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + containerAnnc.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ContainerAnncId Conflit"));
        }
        if (containerAnnc.getId() == null || containerAnnc.getId().isEmpty()) {
            containerAnnc.setId(ContainerAnncController.generateId("CONT_", "Annc"));
        }
        if (containerAnnc.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute CREATE is Mandatory"));
        }
        if (containerAnnc.getLink() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute CREATE is Mandatory"));
        }
        if (containerAnnc.getExpirationTime() != null && !this.checkExpirationTime(containerAnnc.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time CREATE is Out of Date"));
        }
        containerAnnc.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + containerAnnc.getId());
        if (containerAnnc.getExpirationTime() == null) {
            containerAnnc.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(containerAnnc.getAccessRightID(), em) == null) {
            containerAnnc.setAccessRightID(accessRightID);
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)containerAnnc);
        DAOFactory.getContainerAnncDAO().create(containerAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ContainerAnnc containerAnnc = DAOFactory.getContainerAnncDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (containerAnnc == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(containerAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)containerAnnc);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ContainerAnnc containerAnnc = DAOFactory.getContainerAnncDAO().find(requestIndication.getTargetID(), em);
        if (containerAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(containerAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        ContainerAnnc containerAnncNew = null;
        try {
            containerAnncNew = (ContainerAnnc)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (containerAnncNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (containerAnncNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ContainerAnncId UPDATE is Not Permitted"));
        }
        if (containerAnncNew.getExpirationTime() != null && !this.checkExpirationTime(containerAnncNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (containerAnncNew.getLink() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute UPDATE is Mandatory"));
        }
        if (containerAnncNew.getSearchStrings() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "searchStrings attribute UPDATE is Mandatory"));
        }
        if (containerAnncNew.getExpirationTime() != null) {
            containerAnnc.setExpirationTime(containerAnncNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(containerAnncNew.getAccessRightID(), em) != null) {
            containerAnnc.setAccessRightID(containerAnncNew.getAccessRightID());
        }
        containerAnnc.setSearchStrings(containerAnncNew.getSearchStrings());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)containerAnnc);
        DAOFactory.getContainerAnncDAO().update(containerAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)containerAnnc);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        ContainerAnnc containerAnnc = DAOFactory.getContainerAnncDAO().find(requestIndication.getTargetID(), em);
        if (containerAnnc == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(containerAnnc.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)containerAnnc);
        DAOFactory.getContainerAnncDAO().delete(containerAnnc, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

