/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.ReferenceToNamedResource;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.resource.Subscription;
import org.eclipse.om2m.commons.resource.SubscriptionType;
import org.eclipse.om2m.commons.resource.Subscriptions;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;

public class SubscriptionController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Subscription subscription = null;
        try {
            subscription = (Subscription)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (subscription == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (subscription.getExpirationTime() != null && !this.checkExpirationTime(subscription.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time CREATE is Out of Date"));
        }
        if (subscription.getContact() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Link attribute is mandatory"));
        }
        if (subscription.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time CREATE is Not Permitted"));
        }
        if (subscription.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time CREATE is Not Permitted"));
        }
        if (subscription.getSubscriptionType() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionType CREATE is Not Permitted"));
        }
        if (this.checkContactURIExistence(requestIndication.getTargetID(), subscription.getContact(), em)) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "Subscription ContactURI Conflict"));
        }
        if (subscription.getId() != null && !subscription.getId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ID should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (subscription.getId() != null && DAOFactory.getSubscriptionDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + subscription.getId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "SubscriptionId Conflit"));
        }
        if (subscription.getId() == null || subscription.getId().isEmpty()) {
            subscription.setId(SubscriptionController.generateId("SUB_", ""));
        }
        subscription.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + subscription.getId());
        if (subscription.getExpirationTime() == null) {
            subscription.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        subscription.setSubscriptionType(SubscriptionType.ASYNCHRONOUS);
        subscription.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        subscription.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        DAOFactory.getSubscriptionDAO().create(subscription, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)subscription);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Subscription subscription = DAOFactory.getSubscriptionDAO().find(requestIndication.getTargetID(), em);
        if (subscription == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        String parentUri = subscription.getUri().split("/subscriptions")[0];
        errorResponse = this.checkAccessRight(this.getAccessRightId(parentUri, em), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)subscription);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Subscription subscription = DAOFactory.getSubscriptionDAO().find(requestIndication.getTargetID(), em);
        if (subscription == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        String parentUri = subscription.getUri().split("/subscriptions")[0];
        errorResponse = this.checkAccessRight(this.getAccessRightId(parentUri, em), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Subscription subscriptionNew = null;
        try {
            subscriptionNew = (Subscription)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (subscriptionNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (subscriptionNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "subscriptionId UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getContact() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Contact attribute UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getSubscriptionType() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "subscriptionType UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getFilterCriteria() != null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "filterCriteria UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "CreationTime UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "LatModifiedTime UPDATE is Not Permitted"));
        }
        if (subscriptionNew.getExpirationTime() != null && !this.checkExpirationTime(subscriptionNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time Update is Out of Date"));
        }
        if (subscriptionNew.getExpirationTime() != null) {
            subscription.setExpirationTime(subscriptionNew.getExpirationTime());
        }
        if (subscriptionNew.getMinimalTimeBetweenNotifications() != null) {
            subscription.setMinimalTimeBetweenNotifications(subscriptionNew.getMinimalTimeBetweenNotifications());
        }
        if (subscriptionNew.getDelayTolerance() != null) {
            subscription.setDelayTolerance(subscriptionNew.getDelayTolerance());
        }
        subscription.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        DAOFactory.getSubscriptionDAO().update(subscription, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)subscription);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Subscription subscription = DAOFactory.getSubscriptionDAO().find(requestIndication.getTargetID(), em);
        ResponseConfirm errorResponse = new ResponseConfirm();
        if (subscription == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        String parentUri = subscription.getUri().split("/subscriptions")[0];
        errorResponse = this.checkAccessRight(this.getAccessRightId(parentUri, em), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        DAOFactory.getSubscriptionDAO().delete(subscription, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }

    public boolean checkContactURIExistence(String targetId, String contact, EntityManager em) {
        Subscriptions subscriptions = DAOFactory.getSubscriptionsDAO().find(targetId, em);
        int i = 0;
        while (i < subscriptions.getSubscriptionCollection().getNamedReference().size()) {
            Subscription subscription = DAOFactory.getSubscriptionDAO().find(String.valueOf(targetId) + "/" + ((ReferenceToNamedResource)subscriptions.getSubscriptionCollection().getNamedReference().get(i)).getId(), em);
            if (subscription.getContact().equalsIgnoreCase(contact)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

