/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.Container;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.constants.Constants;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class ContainerController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Container container = null;
        try {
            container = (Container)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (container == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (container.getExpirationTime() != null && !this.checkExpirationTime(container.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time is Out of Date"));
        }
        if (container.getContentInstancesReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " ContentInstances Reference is Not Permitted"));
        }
        if (container.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " Subscription Reference is Not Permitted"));
        }
        if (container.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time is Not Permitted"));
        }
        if (container.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time is Not Permitted"));
        }
        if (container.getId() != null && !container.getId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Id should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (container.getId() == null || container.getId().isEmpty() || DAOFactory.getContainerDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + container.getId(), em) != null) {
            container.setId(ContainerController.generateId("CONT_", ""));
        }
        container.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + container.getId());
        if (container.getExpirationTime() == null) {
            container.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(container.getAccessRightID(), em) == null) {
            container.setAccessRightID(accessRightID);
        }
        if (container.getSearchStrings() == null) {
            container.setSearchStrings(ContainerController.generateSearchStrings(container.getClass().getSimpleName(), container.getId()));
        }
        if (container.getMaxNrOfInstances() == null || container.getMaxNrOfInstances() > Constants.MAX_NBR_OF_INSTANCES) {
            container.setMaxNrOfInstances(Constants.MAX_NBR_OF_INSTANCES);
        }
        if (container.getAnnounceTo() == null) {
            AnnounceTo announceTo = new AnnounceTo();
            announceTo.setActivated(Boolean.valueOf(false));
            announceTo.setGlobal(Boolean.valueOf(false));
            container.setAnnounceTo(announceTo);
        }
        container.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        container.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        container.setContentInstancesReference(String.valueOf(container.getUri()) + "/contentInstances");
        container.setSubscriptionsReference(String.valueOf(container.getUri()) + "/subscriptions");
        if (container.getAnnounceTo().isActivated().booleanValue()) {
            container.setAnnounceTo(new Announcer().announce(container.getAnnounceTo(), container.getUri(), container.getSearchStrings(), requestIndication.getRequestingEntity()));
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)container);
        DAOFactory.getContainerDAO().create(container, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)container);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (container == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        container.setContentInstancesReference(String.valueOf(container.getUri()) + "/contentInstances");
        container.setSubscriptionsReference(String.valueOf(container.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)container);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID(), em);
        if (container == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Container containerNew = null;
        try {
            containerNew = (Container)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (containerNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (containerNew.getId() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AppId UPDATE is Not Permitted"));
        }
        if (containerNew.getExpirationTime() != null && !this.checkExpirationTime(containerNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (containerNew.getContentInstancesReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "ContentInstance Reference UPDATE is Not Permitted"));
        }
        if (containerNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference UPDATE is Not Permitted"));
        }
        if (containerNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time UPDATE is Not Permitted"));
        }
        if (containerNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time UPDATE is Not Permitted"));
        }
        if (containerNew.getExpirationTime() != null) {
            em.close();
            container.setExpirationTime(containerNew.getExpirationTime());
        }
        if (DAOFactory.getAccessRightDAO().find(containerNew.getAccessRightID(), em) != null) {
            container.setAccessRightID(containerNew.getAccessRightID());
        }
        if (containerNew.getSearchStrings() != null) {
            container.setSearchStrings(containerNew.getSearchStrings());
        }
        if (containerNew.getAnnounceTo() != null) {
            container.setAnnounceTo(containerNew.getAnnounceTo());
        }
        if (containerNew.getMaxNrOfInstances() != null && containerNew.getMaxNrOfInstances() < Constants.MAX_NBR_OF_INSTANCES) {
            container.setMaxNrOfInstances(containerNew.getMaxNrOfInstances());
        }
        if (containerNew.getMaxByteSize() != null) {
            container.setMaxByteSize(containerNew.getMaxByteSize());
        }
        if (containerNew.getMaxInstanceAge() != null) {
            container.setMaxInstanceAge(containerNew.getMaxInstanceAge());
        }
        container.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)container);
        DAOFactory.getContainerDAO().update(container, em);
        em.getTransaction().commit();
        em.close();
        container.setContentInstancesReference(String.valueOf(container.getUri()) + "/contentInstances");
        container.setSubscriptionsReference(String.valueOf(container.getUri()) + "/subscriptions");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)container);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Container container = DAOFactory.getContainerDAO().find(requestIndication.getTargetID(), em);
        if (container == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(container.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (container.getAnnounceTo().isActivated().booleanValue()) {
            new Announcer().deAnnounce(container.getAnnounceTo(), container.getUri(), requestIndication.getRequestingEntity());
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)container);
        DAOFactory.getContainerDAO().delete(container, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not yet Implemented"));
    }
}

