/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.core.controller;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.RollbackException;
import org.eclipse.om2m.commons.resource.APoCPath;
import org.eclipse.om2m.commons.resource.AnnounceTo;
import org.eclipse.om2m.commons.resource.Application;
import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.rest.RequestIndication;
import org.eclipse.om2m.commons.rest.ResponseConfirm;
import org.eclipse.om2m.commons.utils.DateConverter;
import org.eclipse.om2m.commons.utils.XmlMapper;
import org.eclipse.om2m.core.announcer.Announcer;
import org.eclipse.om2m.core.controller.Controller;
import org.eclipse.om2m.core.dao.DAOFactory;
import org.eclipse.om2m.core.dao.DBAccess;
import org.eclipse.om2m.core.notifier.Notifier;

public class ApplicationController
extends Controller {
    @Override
    public ResponseConfirm doCreate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        String accessRightID = this.getAccessRightId(requestIndication.getTargetID(), em);
        if (accessRightID == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(accessRightID, requestIndication.getRequestingEntity(), "CREATE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Application application = null;
        try {
            application = (Application)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (application == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (application.getAppId() != null && !application.getAppId().matches("^[A-Za-z0-9_-]*$")) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AppId should match the following regexpr: ^[A-Za-z0-9_-]*$"));
        }
        if (application.getAppId() != null && DAOFactory.getApplicationDAO().find(String.valueOf(requestIndication.getTargetID()) + "/" + application.getAppId(), em) != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ApplicationId Conflit"));
        }
        if (application.getAppId() == null || application.getAppId().isEmpty()) {
            application.setAppId(ApplicationController.generateId("APP_", ""));
        }
        if (application.getExpirationTime() != null && !this.checkExpirationTime(application.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time CREATE is Out of Date"));
        }
        if (application.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, " Containers Reference is Not Permitted"));
        }
        if (application.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference is Not Permitted"));
        }
        if (application.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference is Not Permitted"));
        }
        if (application.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference is Not Permitted"));
        }
        if (application.getNotificationChannelsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "NotificationChannelsReference is Not Permitted"));
        }
        if (application.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time is Not Permitted"));
        }
        if (application.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time is Not Permitted"));
        }
        application.setUri(String.valueOf(requestIndication.getTargetID()) + "/" + application.getAppId());
        if (application.getExpirationTime() == null) {
            application.setExpirationTime(this.getNewExpirationTime(999999999L));
        }
        if (DAOFactory.getAccessRightDAO().find(application.getAccessRightID(), em) == null) {
            application.setAccessRightID(accessRightID);
        }
        if (application.getAPoCPaths() != null) {
            int i = 0;
            while (i < application.getAPoCPaths().getAPoCPath().size()) {
                if (DAOFactory.getAccessRightDAO().find(((APoCPath)application.getAPoCPaths().getAPoCPath().get(i)).getAccessRightID(), em) == null) {
                    ((APoCPath)application.getAPoCPaths().getAPoCPath().get(i)).setAccessRightID(application.getAccessRightID());
                }
                ++i;
            }
        }
        if (application.getSearchStrings() == null) {
            application.setSearchStrings(ApplicationController.generateSearchStrings(application.getClass().getSimpleName(), application.getAppId()));
        }
        if (application.getAnnounceTo() == null) {
            AnnounceTo announceTo = new AnnounceTo();
            announceTo.setActivated(Boolean.valueOf(false));
            announceTo.setGlobal(Boolean.valueOf(false));
            application.setAnnounceTo(announceTo);
        }
        application.setContainersReference(String.valueOf(application.getUri()) + "/containers");
        application.setGroupsReference(String.valueOf(application.getUri()) + "/groups");
        application.setAccessRightsReference(String.valueOf(application.getUri()) + "/accessRights");
        application.setSubscriptionsReference(String.valueOf(application.getUri()) + "/subscriptions");
        application.setNotificationChannelsReference(String.valueOf(application.getUri()) + "/notificationChannels");
        application.setCreationTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        application.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        if (application.getAnnounceTo().isActivated().booleanValue()) {
            application.setAnnounceTo(new Announcer().announce(application.getAnnounceTo(), application.getUri(), application.getSearchStrings(), requestIndication.getRequestingEntity()));
        }
        Notifier.notify(StatusCode.STATUS_CREATED, (Resource)application);
        try {
            DAOFactory.getApplicationDAO().create(application, em);
            em.getTransaction().commit();
            em.close();
        }
        catch (RollbackException e) {
            em.close();
            LOGGER.debug((Object)"ApplicationId Conflict", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_CONFLICT, "ApplicationId Conflit"));
        }
        return new ResponseConfirm(StatusCode.STATUS_CREATED, (Resource)application);
    }

    @Override
    public ResponseConfirm doRetrieve(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(requestIndication.getTargetID(), em);
        em.close();
        if (application == null) {
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(application.getAccessRightID(), requestIndication.getRequestingEntity(), "READ");
        if (errorResponse != null) {
            return errorResponse;
        }
        application.setContainersReference(String.valueOf(application.getUri()) + "/containers");
        application.setGroupsReference(String.valueOf(application.getUri()) + "/groups");
        application.setAccessRightsReference(String.valueOf(application.getUri()) + "/accessRights");
        application.setSubscriptionsReference(String.valueOf(application.getUri()) + "/subscriptions");
        application.setNotificationChannelsReference(String.valueOf(application.getUri()) + "/notificationChannels");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)application);
    }

    @Override
    public ResponseConfirm doUpdate(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(requestIndication.getTargetID(), em);
        if (application == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist in DataBase"));
        }
        errorResponse = this.checkAccessRight(application.getAccessRightID(), requestIndication.getRequestingEntity(), "WRITE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (requestIndication.getRepresentation() == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Resource Representation is EMPTY"));
        }
        Application applicationNew = null;
        try {
            applicationNew = (Application)XmlMapper.getInstance().xmlToObject(requestIndication.getRepresentation());
        }
        catch (ClassCastException e) {
            em.close();
            LOGGER.debug((Object)"ClassCastException : Incorrect resource type in JAXB unmarshalling.", (Throwable)e);
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource type"));
        }
        if (applicationNew == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Incorrect resource representation syntax"));
        }
        if (applicationNew.getAppId() != null && !applicationNew.getAppId().equals(application.getAppId())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AppId UPDATE is Not Permitted"));
        }
        if (applicationNew.getExpirationTime() != null && !this.checkExpirationTime(applicationNew.getExpirationTime())) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Expiration Time UPDATE is Out of Date"));
        }
        if (applicationNew.getContainersReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Containers Reference UPDATE is Not Permitted"));
        }
        if (applicationNew.getGroupsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Groups Reference UPDATE is Not Permitted"));
        }
        if (applicationNew.getAccessRightsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "AccessRights Reference UPDATE is Not Permitted"));
        }
        if (applicationNew.getSubscriptionsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "SubscriptionsReference UPDATE is Not Permitted"));
        }
        if (applicationNew.getNotificationChannelsReference() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "NotificationChannelsReference UPDATE is Not Permitted"));
        }
        if (applicationNew.getCreationTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Creation Time UPDATE is Not Permitted"));
        }
        if (applicationNew.getLastModifiedTime() != null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_BAD_REQUEST, "Last Modified Time UPDATE is Not Permitted"));
        }
        if (DAOFactory.getAccessRightDAO().find(applicationNew.getAccessRightID(), em) != null) {
            application.setAccessRightID(applicationNew.getAccessRightID());
        }
        if (applicationNew.getExpirationTime() != null) {
            application.setExpirationTime(applicationNew.getExpirationTime());
        }
        if (applicationNew.getSearchStrings() != null) {
            application.setSearchStrings(applicationNew.getSearchStrings());
        }
        if (applicationNew.getAnnounceTo() != null) {
            application.setAnnounceTo(applicationNew.getAnnounceTo());
        }
        if (applicationNew.getAPoC() != null) {
            application.setAPoC(applicationNew.getAPoC());
        }
        if (applicationNew.getAPoCPaths() != null) {
            application.setAPoCPaths(applicationNew.getAPoCPaths());
        }
        if (applicationNew.getLocRequestor() != null) {
            application.setLocRequestor(applicationNew.getLocRequestor());
        }
        application.setLastModifiedTime(DateConverter.toXMLGregorianCalendar((Date)new Date()).toString());
        Notifier.notify(StatusCode.STATUS_OK, (Resource)application);
        DAOFactory.getApplicationDAO().update(application, em);
        em.getTransaction().commit();
        em.close();
        application.setContainersReference(String.valueOf(application.getUri()) + "/containers");
        application.setGroupsReference(String.valueOf(application.getUri()) + "/groups");
        application.setAccessRightsReference(String.valueOf(application.getUri()) + "/accessRights");
        application.setSubscriptionsReference(String.valueOf(application.getUri()) + "/subscriptions");
        application.setNotificationChannelsReference(String.valueOf(application.getUri()) + "/notificationChannels");
        return new ResponseConfirm(StatusCode.STATUS_OK, (Resource)application);
    }

    @Override
    public ResponseConfirm doDelete(RequestIndication requestIndication) {
        ResponseConfirm errorResponse = new ResponseConfirm();
        EntityManager em = DBAccess.createEntityManager();
        em.getTransaction().begin();
        Application application = DAOFactory.getApplicationDAO().find(requestIndication.getTargetID(), em);
        if (application == null) {
            em.close();
            return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_FOUND, String.valueOf(requestIndication.getTargetID()) + " does not exist"));
        }
        errorResponse = this.checkAccessRight(application.getAccessRightID(), requestIndication.getRequestingEntity(), "DELETE");
        if (errorResponse != null) {
            em.close();
            return errorResponse;
        }
        if (application.getAnnounceTo().isActivated().booleanValue()) {
            new Announcer().deAnnounce(application.getAnnounceTo(), application.getUri(), requestIndication.getRequestingEntity());
        }
        Notifier.notify(StatusCode.STATUS_DELETED, (Resource)application);
        DAOFactory.getApplicationDAO().delete(application, em);
        em.getTransaction().commit();
        em.close();
        return new ResponseConfirm(StatusCode.STATUS_OK);
    }

    @Override
    public ResponseConfirm doExecute(RequestIndication requestIndication) {
        return new ResponseConfirm(new ErrorInfo(StatusCode.STATUS_NOT_IMPLEMENTED, String.valueOf(requestIndication.getMethod()) + " Method is not implmented"));
    }
}

