/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.om2m.commons.rest;

import org.eclipse.om2m.commons.resource.ErrorInfo;
import org.eclipse.om2m.commons.resource.Resource;
import org.eclipse.om2m.commons.resource.StatusCode;
import org.eclipse.om2m.commons.utils.XmlMapper;

public class ResponseConfirm {
    private StatusCode statusCode;
    private String representation;
    private String resourceURI;

    public ResponseConfirm() {
    }

    public ResponseConfirm(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public ResponseConfirm(StatusCode statusCode, String representation) {
        this.statusCode = statusCode;
        this.representation = representation;
    }

    public ResponseConfirm(StatusCode statusCode, Resource resource) {
        this.statusCode = statusCode;
        this.representation = XmlMapper.getInstance().objectToXml(resource);
        this.resourceURI = resource.getUri();
    }

    public ResponseConfirm(ErrorInfo errorInfo) {
        this.statusCode = errorInfo.getStatusCode();
        this.representation = XmlMapper.getInstance().objectToXml(errorInfo);
    }

    public StatusCode getStatusCode() {
        return this.statusCode;
    }

    public void setStatusCode(StatusCode statusCode) {
        this.statusCode = statusCode;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public void setResourceURI(String resourceURI) {
        this.resourceURI = resourceURI;
    }

    public String getRepresentation() {
        return this.representation;
    }

    public void setRepresentation(String representation) {
        this.representation = representation;
    }

    public String toString() {
        return "ResponseConfirm [statusCode=" + (Object)((Object)this.statusCode) + ", representation=" + this.representation + ", resourceURI=" + this.resourceURI + "]";
    }
}

