/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CategorizedProblem;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FunctionalExpression;
import org.eclipse.jdt.internal.compiler.ast.ImportReference;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.StringLiteral;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;
import org.eclipse.jdt.internal.compiler.util.SimpleSetOfCharArray;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.core.exceptions.InternalCompilerError;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.AbstractMethodMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.CallinMappingDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.GuardPredicateDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.PrecedenceDeclaration;
import org.eclipse.objectteams.otdt.internal.core.compiler.ast.TypeValueParameter;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.BytecodeTransformer;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.CallinPrecedenceAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.InlineAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.bytecode.WordValueAttribute;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Config;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.Dependencies;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.control.StateMemento;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.CallinCalloutBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.OTClassScope;
import org.eclipse.objectteams.otdt.internal.core.compiler.lookup.PrecedenceBinding;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TeamModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.TypeModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.AbstractSmapGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.RoleSmapGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.smap.TeamSmapGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.copyinheritance.CopyInheritance;
import org.eclipse.objectteams.otdt.internal.core.compiler.statemachine.transformer.RoleSplitter;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.Sorting;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext,
ClassFileConstants {
    public static final int CLASS_DECL = 1;
    public static final int INTERFACE_DECL = 2;
    public static final int ENUM_DECL = 3;
    public static final int ANNOTATION_TYPE_DECL = 4;
    public int modifiers = 0;
    public int modifiersSourceStart;
    public int functionalExpressionsCount = 0;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public CompilationResult compilationResult;
    public MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;
    public FieldBinding enumValuesSyntheticfield;
    public int enumConstantsCounter;
    public TypeParameter[] typeParameters;
    public AbstractMethodMappingDeclaration[] callinCallouts;
    public PrecedenceDeclaration[] precedences;
    public TypeReference baseclass;
    public GuardPredicateDeclaration predicate = null;
    public CompilationUnitDeclaration compilationUnit = null;
    public boolean isConverted = false;
    private TeamModel teamModel = null;
    private TypeModel model = null;
    private RoleModel roleModel = null;
    public boolean isGenerated = false;
    public boolean isPurelyCopied = false;
    public boolean willCatchAbort = false;

    public void copyPredicates() {
        int n;
        int n2;
        ASTNode[] aSTNodeArray;
        int count = 0;
        if (this.predicate != null) {
            ++count;
        }
        int max = count + (this.methods == null ? 0 : this.methods.length) + (this.callinCallouts == null ? 0 : this.callinCallouts.length);
        GuardPredicateDeclaration[] guardMethods = new GuardPredicateDeclaration[max];
        if (this.predicate != null) {
            guardMethods[0] = this.predicate;
        }
        if (this.methods != null) {
            aSTNodeArray = this.methods;
            n2 = this.methods.length;
            n = 0;
            while (n < n2) {
                ASTNode method = aSTNodeArray[n];
                if (((AbstractMethodDeclaration)method).isMethod()) {
                    MethodDeclaration md = (MethodDeclaration)method;
                    if (md.predicate != null) {
                        guardMethods[count++] = md.predicate;
                    }
                }
                ++n;
            }
        }
        if (this.callinCallouts != null) {
            aSTNodeArray = this.callinCallouts;
            n2 = this.callinCallouts.length;
            n = 0;
            while (n < n2) {
                ASTNode mapping = aSTNodeArray[n];
                if (((AbstractMethodMappingDeclaration)mapping).isCallin()) {
                    CallinMappingDeclaration callinDecl = (CallinMappingDeclaration)mapping;
                    if (callinDecl.predicate != null) {
                        guardMethods[count++] = callinDecl.predicate;
                    }
                }
                ++n;
            }
        }
        if (count == 0) {
            return;
        }
        int oldLen = 0;
        if (this.methods != null) {
            oldLen = this.methods.length;
        }
        AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[oldLen + count];
        if (oldLen > 0) {
            System.arraycopy(this.methods, 0, newMethods, 0, oldLen);
        }
        if (count > 0) {
            System.arraycopy(guardMethods, 0, newMethods, oldLen, count);
        }
        this.methods = newMethods;
    }

    public boolean isRoleFile() {
        if (this.compilationUnit == null) {
            return false;
        }
        int i = 0;
        while (i < this.compilationUnit.types.length) {
            if (this.compilationUnit.types[i] == this) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public PackageBinding getPackageOfTeam(ImportReference teamPackage, Scope aScope) {
        boolean match;
        TypeDeclaration teamDecl = this.enclosingType;
        if (teamDecl == null) {
            return null;
        }
        char[] teamName = teamDecl.name;
        if (RoleSplitter.isClassPartName(teamName)) {
            teamName = RoleSplitter.getInterfacePartName(teamName);
        }
        if (!(match = teamDecl.binding != null ? CharOperation.equals(teamPackage.tokens, PackageBinding.TeamPackageBinding.adjustTeamPackageName(teamDecl.binding.compoundName)) : CharOperation.equals(teamPackage.tokens[teamPackage.tokens.length - 1], teamName))) {
            aScope.problemReporter().mismatchingPackageForRole(teamPackage.tokens, teamName, this.name, teamPackage.sourceStart, teamPackage.sourceEnd);
            return null;
        }
        return teamDecl.scope.getCurrentPackage();
    }

    public int getRoleFileDepth() {
        if (!this.isRoleFile()) {
            return 0;
        }
        int depth = 0;
        TypeDeclaration current = this.enclosingType;
        while (current != null && current.isTeam()) {
            ++depth;
            current = current.enclosingType;
        }
        return depth;
    }

    public TeamModel getTeamModel() {
        if (this.teamModel == null) {
            this.teamModel = new TeamModel(this);
        }
        if (this.teamModel.getBinding() == null && this.binding != null) {
            this.teamModel.setBinding(this.binding);
        }
        return this.teamModel;
    }

    public TypeModel getModel() {
        if (this.model == null) {
            this.model = new TypeModel(this);
        }
        return this.model;
    }

    public RoleModel getRoleModel() {
        assert (this.isRole());
        if (this.roleModel == null) {
            this.roleModel = new RoleModel(this);
        }
        if (this.roleModel.getBinding() == null && this.binding != null) {
            this.roleModel.setBinding(this.binding);
        }
        return this.roleModel;
    }

    public RoleModel getRoleModel(TeamModel aTeamModel) {
        this.getRoleModel();
        this.roleModel.setTeamModel(aTeamModel);
        return this.roleModel;
    }

    public void setBinding(SourceTypeBinding binding) {
        this.binding = binding;
        this.getModel();
        if (this.isTeam()) {
            this.getTeamModel();
        }
        if (this.isRole()) {
            this.getRoleModel();
        }
    }

    public void adjustOrgObjectteamsTeam() {
        this.modifiers |= 0x4000000;
        TypeDeclaration confined = null;
        TypeDeclaration otconfined = null;
        if (this.memberTypes != null) {
            int i = 0;
            while (i < this.memberTypes.length) {
                TypeDeclaration memberType = this.memberTypes[i];
                memberType.modifiers |= 0x1000000;
                if (CharOperation.equals(memberType.name, IOTConstants.OTCONFINED)) {
                    otconfined = memberType;
                } else if (CharOperation.equals(memberType.name, IOTConstants.CONFINED)) {
                    confined = memberType;
                }
                ++i;
            }
            if (confined != null && otconfined != null) {
                RoleModel ifcModel = confined.getRoleModel(this.getTeamModel());
                RoleModel clsModel = otconfined.getRoleModel(this.getTeamModel());
                ifcModel._classPart = otconfined;
                clsModel._interfacePart = confined;
            }
        }
    }

    public final boolean isTeam() {
        return (this.modifiers & 0x4000000) != 0;
    }

    public boolean isSourceRole() {
        if ((this.modifiers & 0x4000) != 0) {
            return false;
        }
        return (!this.isGenerated || !this.isInterface()) && (this.modifiers & 0x1000000) != 0;
    }

    public boolean isRole() {
        if ((this.modifiers & 0x1000000) != 0) {
            return true;
        }
        if ((this.modifiers & 0x4000) != 0) {
            return false;
        }
        if (this.enclosingType == null && this.scope != null && this.scope.parent != null && this.scope.parent.methodScope() != null) {
            this.enclosingType = this.scope.parent.methodScope().referenceType();
        }
        if (this.enclosingType != null) {
            return this.enclosingType.isRole();
        }
        if (this.binding != null) {
            return this.binding.isRole();
        }
        return false;
    }

    public boolean isDirectRole() {
        return (this.modifiers & 0x1000000) != 0;
    }

    public boolean isInterface() {
        return TypeDeclaration.kind(this.modifiers) == 2;
    }

    public boolean isRegularInterface() {
        return (this.modifiers & 0x1200) == 512;
    }

    public char[] sourceName() {
        if (this.isSourceRole() && RoleSplitter.isClassPartName(this.name)) {
            return RoleSplitter.getInterfacePartName(this.name);
        }
        return this.name;
    }

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    @Override
    public void abort(int abortLevel, CategorizedProblem problem) {
        if (!this.willCatchAbort) {
            switch (abortLevel) {
                case 2: 
                case 4: {
                    StateHelper.setStateRecursive(this.scope.referenceCompilationUnit(), 25, false);
                    break;
                }
                case 16: {
                    break;
                }
                default: {
                    StateHelper.setStateRecursive(this, 25, false);
                }
            }
        }
        switch (abortLevel) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, problem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, problem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, problem);
            }
        }
        throw new AbortType(this.compilationResult, problem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] methodDeclarations = this.methods;
            if (this.methods == null) {
                boolean length = false;
                methodDeclarations = new AbstractMethodDeclaration[1];
            } else {
                int length = methodDeclarations.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = methodDeclarations;
                methodDeclarations = new AbstractMethodDeclaration[length + 1];
                System.arraycopy(abstractMethodDeclarationArray, 0, methodDeclarations, 1, length);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            methodDeclarations[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = methodDeclarations;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        TypeBinding[] argumentTypes = methodBinding.parameters;
        int argumentsLength = argumentTypes.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (argumentsLength > 0) {
            String baseName = "arg";
            methodDeclaration.arguments = new Argument[argumentsLength];
            Argument[] arguments = methodDeclaration.arguments;
            int i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            MethodDeclaration[] newMethods = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, newMethods, 1, this.missingAbstractMethods.length);
            newMethods[0] = methodDeclaration;
            this.missingAbstractMethods = newMethods;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers | 0x1000, methodBinding.selector, methodBinding.returnType, argumentsLength == 0 ? Binding.NO_PARAMETERS : argumentTypes, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localType = (LocalTypeBinding)this.binding;
                if (localType.constantPoolName() == null) {
                    localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
                }
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope enclosingClassScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.updateMaxFieldCount();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if ((flowInfo.tagBits & 1) == 0) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localType = (LocalTypeBinding)this.binding;
                localType.setConstantPoolName(currentScope.compilationUnitScope().computeConstantPoolName(localType));
            }
            this.manageEnclosingInstanceAccessIfNecessary(currentScope, flowInfo);
            this.updateMaxFieldCount();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope unitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (this.isRoleFile()) {
                if (this.binding.enclosingType() != null) {
                    Dependencies.ensureBindingState(this.binding.enclosingType(), 20);
                } else if (!this.compilationResult.hasErrors()) {
                    throw new InternalCompilerError("Role file unexpectedly has no enclosing team");
                }
            }
            int myMaxFieldCount = this.scope.outerMostClassScope().referenceType().maxFieldCount;
            this.internalAnalyseCode(null, FlowInfo.initial(myMaxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean hasConstructor = false;
        if (this.methods != null) {
            int i = this.methods.length;
            while (--i >= 0) {
                AbstractMethodDeclaration am = this.methods[i];
                if (!am.isConstructor()) continue;
                if (!CharOperation.equals(am.selector, this.name)) {
                    ConstructorDeclaration c = (ConstructorDeclaration)am;
                    if (c.constructorCall != null && !c.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration m = parser.convertToMethodDeclaration(c, this.compilationResult);
                    this.methods[i] = m;
                    continue;
                }
                switch (TypeDeclaration.kind(this.modifiers)) {
                    case 2: {
                        parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)am);
                        break;
                    }
                    case 4: {
                        parser.problemReporter().annotationTypeDeclarationCannotHaveConstructor((ConstructorDeclaration)am);
                    }
                }
                hasConstructor = true;
            }
        }
        return hasConstructor;
    }

    @Override
    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createDefaultConstructor(boolean needExplicitConstructorCall, boolean needToInsert) {
        if (this.isDirectRole() && this.roleModel == null) {
            return null;
        }
        ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
        constructor.bits |= 0x80;
        constructor.selector = this.name;
        constructor.modifiers = this.modifiers & 7;
        constructor.declarationSourceStart = constructor.sourceStart = this.sourceStart;
        constructor.sourceEnd = constructor.bodyEnd = this.sourceEnd;
        constructor.declarationSourceEnd = constructor.bodyEnd;
        if (needExplicitConstructorCall) {
            constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructor.constructorCall.sourceStart = this.sourceStart;
            constructor.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (needToInsert) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructor};
            } else {
                AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
                newMethods[0] = constructor;
                this.methods = newMethods;
            }
        }
        return constructor;
    }

    public MethodBinding createDefaultConstructorWithBinding(MethodBinding inheritedConstructorBinding, boolean eraseThrownExceptions) {
        int i;
        String baseName = "$anonymous";
        TypeBinding[] argumentTypes = inheritedConstructorBinding.parameters;
        int argumentsLength = argumentTypes.length;
        ConstructorDeclaration constructor = new ConstructorDeclaration(this.compilationResult);
        constructor.selector = new char[]{'x'};
        constructor.sourceStart = this.sourceStart;
        constructor.sourceEnd = this.sourceEnd;
        int newModifiers = this.modifiers & 7;
        if (inheritedConstructorBinding.isVarargs()) {
            newModifiers |= 0x80;
        }
        constructor.modifiers = newModifiers;
        constructor.bits |= 0x80;
        if (argumentsLength > 0) {
            constructor.arguments = new Argument[argumentsLength];
            Argument[] arguments = constructor.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                arguments[i] = new Argument((String.valueOf(baseName) + i).toCharArray(), 0L, null, 0);
            }
        }
        constructor.constructorCall = SuperReference.implicitSuperConstructorCall();
        constructor.constructorCall.sourceStart = this.sourceStart;
        constructor.constructorCall.sourceEnd = this.sourceEnd;
        if (argumentsLength > 0) {
            constructor.constructorCall.arguments = new Expression[argumentsLength];
            Expression[] args = constructor.constructorCall.arguments;
            i = argumentsLength;
            while (--i >= 0) {
                args[i] = new SingleNameReference((String.valueOf(baseName) + i).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{constructor};
        } else {
            AbstractMethodDeclaration[] newMethods = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, newMethods, 1, this.methods.length);
            newMethods[0] = constructor;
            this.methods = newMethods;
        }
        ReferenceBinding[] thrownExceptions = eraseThrownExceptions ? this.scope.environment().convertToRawTypes(inheritedConstructorBinding.thrownExceptions, true, true) : inheritedConstructorBinding.thrownExceptions;
        SourceTypeBinding sourceType = this.binding;
        constructor.binding = new MethodBinding(constructor.modifiers, argumentsLength == 0 ? Binding.NO_PARAMETERS : argumentTypes, thrownExceptions, sourceType);
        constructor.binding.tagBits |= inheritedConstructorBinding.tagBits & 0x80L;
        constructor.binding.modifiers |= 0x4000000;
        if (inheritedConstructorBinding.parameterNonNullness != null && argumentsLength > 0) {
            int len = inheritedConstructorBinding.parameterNonNullness.length;
            constructor.binding.parameterNonNullness = new Boolean[len];
            System.arraycopy(inheritedConstructorBinding.parameterNonNullness, 0, constructor.binding.parameterNonNullness, 0, len);
        }
        constructor.scope = new MethodScope(this.scope, constructor, true);
        constructor.bindArguments();
        constructor.constructorCall.resolve(constructor.scope);
        this.binding.addMethod(constructor.binding);
        return constructor.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null && this.fields != null) {
            int i = 0;
            int max = this.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = this.fields[i];
                if (fieldDecl.binding == fieldBinding) {
                    return fieldDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null && this.memberTypes != null) {
            int i = 0;
            int max = this.memberTypes.length;
            while (i < max) {
                TypeDeclaration memberTypeDecl = this.memberTypes[i];
                if (TypeBinding.equalsEquals(memberTypeDecl.binding, memberTypeBinding)) {
                    return memberTypeDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int i = 0;
            int max = this.methods.length;
            while (i < max) {
                AbstractMethodDeclaration methodDecl = this.methods[i];
                if (methodDecl.binding == methodBinding) {
                    return methodDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public AbstractMethodMappingDeclaration declarationOf(CallinCalloutBinding mappingBinding) {
        if (mappingBinding != null && this.callinCallouts != null) {
            int i = 0;
            int max = this.callinCallouts.length;
            while (i < max) {
                AbstractMethodMappingDeclaration mappingDecl = this.callinCallouts[i];
                if (mappingDecl.binding == mappingBinding) {
                    return mappingDecl;
                }
                ++i;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] typeName) {
        int typeNameLength = typeName.length;
        if (typeNameLength < 1 || !CharOperation.equals(typeName[0], this.name)) {
            return null;
        }
        if (typeNameLength == 1) {
            return this;
        }
        char[][] subTypeName = new char[typeNameLength - 1][];
        System.arraycopy(typeName, 1, subTypeName, 0, typeNameLength - 1);
        int i = 0;
        while (i < this.memberTypes.length) {
            TypeDeclaration typeDecl = this.memberTypes[i].declarationOfType(subTypeName);
            if (typeDecl != null) {
                return typeDecl;
            }
            ++i;
        }
        return null;
    }

    @Override
    public CompilationUnitDeclaration getCompilationUnitDeclaration() {
        if (this.scope != null) {
            return this.scope.compilationUnitScope().referenceContext;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void generateCode(ClassFile enclosingClassFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        this.bits |= 0x2000;
        if (!(!this.isConverted || this.isTeam() && this.getTeamModel().containsRoFi(true))) {
            return;
        }
        if (RoleModel.isRoleWithBaseProblem(this)) {
            this.ignoreFurtherInvestigation = true;
        }
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            this.markMissingBytecode();
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        if (this.isRole()) {
            ReferenceBinding superTeam;
            ReferenceBinding prevSuper = superTeam = this.binding.enclosingType().superclass();
            ReferenceBinding currentSuper = superTeam.enclosingType();
            ClassFile enclosingSuperClassFile = null;
            block6: while (currentSuper != null) {
                ReferenceBinding current = this.binding.enclosingType().enclosingType();
                enclosingSuperClassFile = enclosingClassFile.enclosingClassFile;
                while (current != null) {
                    if (TypeBinding.equalsEquals(current, currentSuper)) break block6;
                    current = current.enclosingType();
                    enclosingSuperClassFile = enclosingSuperClassFile.enclosingClassFile;
                }
                prevSuper = currentSuper;
                currentSuper = currentSuper.enclosingType();
            }
            if (currentSuper != null && !prevSuper.isBinaryBinding()) {
                TypeDeclaration superType = ((SourceTypeBinding)prevSuper.erasure()).scope.referenceContext;
                superType.generateCode(null, enclosingSuperClassFile);
            }
        }
        if (this.isTeam()) {
            CopyInheritance.copySyntheticTeamMethods(this);
            this.getTeamModel().updateDecapsAccessIds();
        }
        this.binding.computeValueParameterSlotSizes();
        try {
            try {
                char[] smap;
                ClassFile classFile = ClassFile.getNewInstance(this.binding);
                classFile.initialize(this.binding, enclosingClassFile, false);
                if (this.binding.isMemberType()) {
                    classFile.recordInnerClasses(this.binding);
                } else if (this.binding.isLocalType()) {
                    enclosingClassFile.recordInnerClasses(this.binding);
                    classFile.recordInnerClasses(this.binding);
                }
                TypeVariableBinding[] typeVariables = this.binding.typeVariables();
                int i = 0;
                int max = typeVariables.length;
                while (i < max) {
                    TypeVariableBinding typeVariableBinding = typeVariables[i];
                    if ((typeVariableBinding.tagBits & 0x800L) != 0L) {
                        Util.recordNestedType(classFile, typeVariableBinding);
                    }
                    ++i;
                }
                classFile.addFieldInfos();
                if (this.isRole() && this.fields != null) {
                    FieldDeclaration[] fieldDeclarationArray = this.fields;
                    int typeVariableBinding = this.fields.length;
                    max = 0;
                    while (max < typeVariableBinding) {
                        FieldDeclaration field = fieldDeclarationArray[max];
                        if (!(field instanceof Initializer) && !field.isGenerated && field.binding.isPublic()) {
                            SourceTypeBinding enclosingTeam = (SourceTypeBinding)this.binding.enclosingType();
                            enclosingTeam.addSyntheticMethod(field.binding, true, false, true);
                            enclosingTeam.addSyntheticMethod(field.binding, false, false, true);
                        }
                        ++max;
                    }
                }
                if (this.isTeam()) {
                    ReferenceBinding[] members = this.getTeamModel().getKnownRoles();
                    int i2 = 0;
                    while (i2 < members.length) {
                        classFile.recordInnerClasses(members[i2]);
                        ++i2;
                    }
                }
                new BytecodeTransformer().checkCopyNonWideConstants(this.scope, classFile);
                if (this.memberTypes != null) {
                    i = 0;
                    max = this.memberTypes.length;
                    while (i < max) {
                        TypeDeclaration memberType = this.memberTypes[i];
                        if (!memberType.isRole()) {
                            classFile.recordInnerClasses(memberType.binding);
                        }
                        memberType.generateCode(this.scope, classFile);
                        ++i;
                    }
                }
                classFile.setForMethodInfos();
                if (this.methods != null) {
                    i = 0;
                    max = this.methods.length;
                    while (i < max) {
                        if (this.needToProcess(this.methods[i])) {
                            this.methods[i].generateCode(this.scope, classFile);
                        }
                        ++i;
                    }
                }
                classFile.addSpecialMethods();
                if (this.ignoreFurtherInvestigation) {
                    throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
                }
                if (this.isTeam()) {
                    this.getTeamModel().generateRoFiCache(classFile);
                }
                if ((smap = this.getSMAP()) != null) {
                    this.getModel().addAttribute(InlineAttribute.sourceDebugExtensionAttribute(smap));
                }
                classFile.addAttributes();
                this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile);
                return;
            }
            catch (AbortType abortType) {
                if (this.binding == null) {
                    if (!this.isTeam()) return;
                    this.teamModel.setState(24);
                    return;
                }
                ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
                if (!this.isTeam()) return;
                this.teamModel.setState(24);
                return;
            }
        }
        finally {
            if (this.isTeam()) {
                this.teamModel.setState(24);
            }
        }
    }

    private void markMissingBytecode() {
        this.traverse(new ASTVisitor(){

            @Override
            public boolean visit(MethodDeclaration method, ClassScope classScope) {
                if (method.binding != null) {
                    method.binding.bytecodeMissing = true;
                }
                return true;
            }

            @Override
            public boolean visit(ConstructorDeclaration ctor, ClassScope classScope) {
                if (ctor.binding != null) {
                    ctor.binding.bytecodeMissing = true;
                }
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration type, ClassScope classScope) {
                type.tagAsHavingErrors();
                return true;
            }

            @Override
            public boolean visit(TypeDeclaration type, BlockScope blockScope) {
                type.tagAsHavingErrors();
                return true;
            }
        }, this.scope);
    }

    private char[] getSMAP() {
        if (this.isInterface()) {
            return null;
        }
        AbstractSmapGenerator generator = this.createSmapGenerator();
        if (generator == null) {
            return null;
        }
        generator.addStratum("OTJ");
        generator.setDefaultStratum("OTJ");
        return generator.generate();
    }

    protected AbstractSmapGenerator createSmapGenerator() {
        if (this.isRole()) {
            return new RoleSmapGenerator(this);
        }
        if (this.isTeam()) {
            return new TeamSmapGenerator(this);
        }
        return null;
    }

    @Override
    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        int pc = codeStream.position;
        if (this.binding != null) {
            SyntheticArgumentBinding[] enclosingInstances = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int i = 0;
            int slotSize = 0;
            int count = enclosingInstances == null ? 0 : enclosingInstances.length;
            while (i < count) {
                SyntheticArgumentBinding enclosingInstance = enclosingInstances[i];
                enclosingInstance.resolvedPosition = ++slotSize;
                if (slotSize > 255) {
                    blockScope.problemReporter().noMoreAvailableSpaceForArgument(enclosingInstance, blockScope.referenceType());
                }
                ++i;
            }
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(pc, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile enclosingClassFile) {
        if ((this.bits & 0x2000) != 0) {
            return;
        }
        if (this.binding != null) {
            Dependencies.ensureBindingState(this.binding, 23);
        }
        if (this.binding != null) {
            SyntheticArgumentBinding[] enclosingInstances = ((NestedTypeBinding)this.binding).syntheticEnclosingInstances();
            int i = 0;
            int slotSize = 0;
            int count = enclosingInstances == null ? 0 : enclosingInstances.length;
            while (i < count) {
                SyntheticArgumentBinding enclosingInstance = enclosingInstances[i];
                enclosingInstance.resolvedPosition = ++slotSize;
                if (slotSize > 255) {
                    classScope.problemReporter().noMoreAvailableSpaceForArgument(enclosingInstance, classScope.referenceType());
                }
                ++i;
            }
        }
        this.generateCode(enclosingClassFile);
    }

    public void generateCode(CompilationUnitScope unitScope) {
        this.generateCode((ClassFile)null);
    }

    @Override
    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    private void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int count;
        int i;
        if (this.isRoleFile() && !this.binding.isSynthInterface() && !this.compilationResult.hasSyntaxError) {
            this.scope.referenceCompilationUnit().checkUnusedImports();
        }
        if (this.scope instanceof OTClassScope) {
            ((OTClassScope)this.scope).checkUnusedImports();
        }
        if (!this.binding.isUsed() && this.binding.isOrEnclosedByPrivateType() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        if (this.typeParameters != null && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            int i2 = 0;
            int length = this.typeParameters.length;
            while (i2 < length) {
                TypeParameter typeParameter = this.typeParameters[i2];
                if (!(typeParameter instanceof TypeValueParameter) && (typeParameter.binding.modifiers & 0x8000000) == 0) {
                    this.scope.problemReporter().unusedTypeParameter(typeParameter);
                }
                ++i2;
            }
        }
        FlowContext parentContext = flowContext instanceof InitializationFlowContext ? null : flowContext;
        InitializationFlowContext initializerContext = new InitializationFlowContext(parentContext, this, flowInfo, flowContext, this.initializerScope);
        InitializationFlowContext staticInitializerContext = new InitializationFlowContext(null, this, flowInfo, flowContext, this.staticInitializerScope);
        FlowInfo nonStaticFieldInfo = flowInfo.unconditionalFieldLessCopy();
        FlowInfo staticFieldInfo = flowInfo.unconditionalFieldLessCopy();
        if (this.fields != null) {
            i = 0;
            count = this.fields.length;
            while (i < count) {
                FieldDeclaration field = this.fields[i];
                if (field.isStatic()) {
                    if ((staticFieldInfo.tagBits & 1) != 0) {
                        field.bits &= Integer.MAX_VALUE;
                    }
                    staticInitializerContext.handledExceptions = Binding.ANY_EXCEPTION;
                    if ((staticFieldInfo = field.analyseCode(this.staticInitializerScope, (FlowContext)staticInitializerContext, staticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(field);
                        staticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                } else {
                    if ((nonStaticFieldInfo.tagBits & 1) != 0) {
                        field.bits &= Integer.MAX_VALUE;
                    }
                    initializerContext.handledExceptions = Binding.ANY_EXCEPTION;
                    if ((nonStaticFieldInfo = field.analyseCode(this.initializerScope, (FlowContext)initializerContext, nonStaticFieldInfo)) == FlowInfo.DEAD_END) {
                        this.initializerScope.problemReporter().initializerMustCompleteNormally(field);
                        nonStaticFieldInfo = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                }
                ++i;
            }
        }
        if (this.typeParameters != null) {
            nonStaticFieldInfo = TypeValueParameter.analyseCode(this.typeParameters, this.initializerScope, flowContext, nonStaticFieldInfo);
        }
        Sorting.sortMemberTypes(this);
        if (this.memberTypes != null) {
            i = 0;
            count = this.memberTypes.length;
            while (i < count) {
                if (flowContext != null) {
                    this.memberTypes[i].analyseCode(this.scope, flowContext, nonStaticFieldInfo.copy().setReachMode(flowInfo.reachMode()));
                } else {
                    this.memberTypes[i].analyseCode(this.scope);
                }
                ++i;
            }
        }
        if (!(this.scope.compilerOptions().complianceLevel < 0x350000L || this.methods != null && this.methods.length != 0 && this.methods[0].isClinit())) {
            Clinit clinit = new Clinit(this.compilationResult);
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            int length = this.methods == null ? 0 : this.methods.length;
            AbstractMethodDeclaration[] methodDeclarations = new AbstractMethodDeclaration[length + 1];
            methodDeclarations[0] = clinit;
            if (this.methods != null) {
                System.arraycopy(this.methods, 0, methodDeclarations, 1, length);
            }
        }
        if ((this.compilationUnit == null || this.compilationUnit.parseMethodBodies) && this.methods != null) {
            UnconditionalFlowInfo outerInfo = flowInfo.unconditionalFieldLessCopy();
            FlowInfo constructorInfo = nonStaticFieldInfo.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo);
            SimpleSetOfCharArray jUnitMethodSourceValues = this.getJUnitMethodSourceValues();
            int i3 = 0;
            int count2 = this.methods.length;
            while (i3 < count2) {
                AbstractMethodDeclaration method = this.methods[i3];
                if (!method.ignoreFurtherInvestigation && this.needToProcess(method)) {
                    if (method.isInitializationMethod()) {
                        if (method.isStatic()) {
                            ((Clinit)method).analyseCode(this.scope, staticInitializerContext, staticFieldInfo.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(outerInfo));
                        } else {
                            ((ConstructorDeclaration)method).analyseCode(this.scope, initializerContext, constructorInfo.copy(), flowInfo.reachMode());
                        }
                    } else {
                        if (method.arguments == null && jUnitMethodSourceValues.includes(method.selector) && method.binding != null) {
                            method.binding.modifiers |= 0x8000000;
                        }
                        ((MethodDeclaration)method).analyseCode(this.scope, parentContext, flowInfo.copy());
                    }
                }
                ++i3;
            }
        }
        if (this.binding.isEnum() && !this.binding.isAnonymousType()) {
            this.enumValuesSyntheticfield = this.binding.addSyntheticFieldForEnumValues();
        }
        this.mergePrecedences();
        if (this.callinCallouts != null) {
            CompilerOptions.WeavingScheme weavingScheme = this.initializerScope.compilerOptions().weavingScheme;
            int i4 = 0;
            while (i4 < this.callinCallouts.length) {
                if (this.callinCallouts[i4].isReplaceCallin()) {
                    ((CallinMappingDeclaration)this.callinCallouts[i4]).analyseDetails(this, weavingScheme);
                }
                ++i4;
            }
        }
    }

    private boolean needToProcess(AbstractMethodDeclaration method) {
        return method.hasParsedStatements || method.isDefaultConstructor() || method.isClinit() || method.isAbstract() || method.isCopied;
    }

    private void mergePrecedences() {
        this.binding.precedences = PrecedenceDeclaration.mergePrecedences(this);
        PrecedenceBinding[] precedenceBindings = this.binding.precedences;
        if (precedenceBindings != PrecedenceBinding.NoPrecedences && this.isTeam() && (this.enclosingType == null || !this.enclosingType.isTeam())) {
            this.model = this.getTeamModel();
            int i = 0;
            while (i < precedenceBindings.length) {
                CallinCalloutBinding[] callins = precedenceBindings[i].callins(true);
                this.model.addAttribute(new CallinPrecedenceAttribute(this.binding, callins));
                ++i;
            }
        }
        if (this.isTeam() && (this.enclosingType == null || !this.enclosingType.isTeam())) {
            PrecedenceBinding.checkDuplicates(this);
        }
    }

    private SimpleSetOfCharArray getJUnitMethodSourceValues() {
        SimpleSetOfCharArray junitMethodSourceValues = new SimpleSetOfCharArray();
        AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
        int n = this.methods.length;
        int n2 = 0;
        while (n2 < n) {
            AbstractMethodDeclaration methodDeclaration = abstractMethodDeclarationArray[n2];
            junitMethodSourceValues.add(this.getJUnitMethodSourceValue(methodDeclaration));
            ++n2;
        }
        return junitMethodSourceValues;
    }

    private char[] getJUnitMethodSourceValue(AbstractMethodDeclaration methodDeclaration) {
        if (methodDeclaration.annotations != null) {
            Annotation[] annotationArray = methodDeclaration.annotations;
            int n = methodDeclaration.annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation annotation = annotationArray[n2];
                if (annotation.resolvedType != null && annotation.resolvedType.id == 93) {
                    MemberValuePair[] memberValuePairArray = annotation.memberValuePairs();
                    int n3 = memberValuePairArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MemberValuePair memberValuePair = memberValuePairArray[n4];
                        if (CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) {
                            return ((StringLiteral)memberValuePair.value).source;
                        }
                        ++n4;
                    }
                    return methodDeclaration.selector;
                }
                ++n2;
            }
        }
        return CharOperation.NO_CHAR;
    }

    public static final int kind(int flags) {
        switch (flags & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) != 0) {
            return;
        }
        NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
        MethodScope methodScope = currentScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedType.addSyntheticArgumentAndField(nestedType.enclosingType());
        }
        if (nestedType.isAnonymousType()) {
            NestedTypeBinding nestedEnclosing;
            SyntheticArgumentBinding syntheticEnclosingInstanceArgument;
            ReferenceBinding enclosing;
            ReferenceBinding superclassBinding = (ReferenceBinding)nestedType.superclass.erasure();
            if (!(superclassBinding.enclosingType() == null || superclassBinding.isStatic() || superclassBinding.isLocalType() && ((NestedTypeBinding)superclassBinding).getSyntheticField(superclassBinding.enclosingType(), true) == null && !superclassBinding.isMemberType())) {
                nestedType.addSyntheticArgument(superclassBinding.enclosingType());
            }
            if (!methodScope.isStatic && methodScope.isConstructorCall && currentScope.compilerOptions().complianceLevel >= 0x310000L && (enclosing = nestedType.enclosingType()).isNestedType() && (syntheticEnclosingInstanceArgument = (nestedEnclosing = (NestedTypeBinding)enclosing).getSyntheticArgument(nestedEnclosing.enclosingType(), true, false)) != null) {
                nestedType.addSyntheticArgumentAndField(syntheticEnclosingInstanceArgument);
            }
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope currentScope, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            NestedTypeBinding nestedType = (NestedTypeBinding)this.binding;
            nestedType.addSyntheticArgumentAndField(this.binding.enclosingType());
        }
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 2: 
            case 4: {
                return this.fields != null;
            }
            case 3: {
                return true;
            }
        }
        if (this.fields != null) {
            int i = this.fields.length;
            while (--i >= 0) {
                FieldDeclaration field = this.fields[i];
                if ((field.modifiers & 8) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void parseMethods(Parser parser, CompilationUnitDeclaration unit) {
        int i;
        int length;
        if (unit.ignoreMethodBodies) {
            return;
        }
        if (this.isTeam() || this.isRoleFile()) {
            parser.scanner.enterOTSource();
        }
        if (this.memberTypes != null) {
            length = this.memberTypes.length;
            i = 0;
            while (i < length) {
                TypeDeclaration typeDeclaration = this.memberTypes[i];
                if (!typeDeclaration.isRoleFile()) {
                    typeDeclaration.parseMethods(parser, unit);
                    this.bits |= typeDeclaration.bits & 0x80000;
                }
                ++i;
            }
        }
        if (this.methods != null) {
            length = this.methods.length;
            i = 0;
            while (i < length) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[i];
                abstractMethodDeclaration.parseStatements(parser, unit);
                this.bits |= abstractMethodDeclaration.bits & 0x80000;
                ++i;
            }
        }
        if (this.fields != null) {
            length = this.fields.length;
            i = 0;
            while (i < length) {
                FieldDeclaration fieldDeclaration = this.fields[i];
                switch (fieldDeclaration.getKind()) {
                    case 2: {
                        ((Initializer)fieldDeclaration).parseStatements(parser, this, unit);
                        this.bits |= fieldDeclaration.bits & 0x80000;
                    }
                }
                ++i;
            }
        }
        if (this.callinCallouts != null) {
            length = this.callinCallouts.length;
            i = 0;
            while (i < length) {
                this.callinCallouts[i].parseParamMappings(parser, unit);
                ++i;
            }
        }
    }

    @Override
    public StringBuffer print(int indent, StringBuffer output) {
        if (this.javadoc != null) {
            this.javadoc.print(indent, output);
        }
        if ((this.bits & 0x200) == 0) {
            TypeDeclaration.printIndent(indent, output);
            this.printHeader(0, output);
        }
        return this.printBody(indent, output);
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        int i;
        output.append(" {");
        if (this.precedences != null) {
            i = 0;
            while (i < this.precedences.length) {
                if (this.precedences[i] != null) {
                    output.append('\n');
                    this.precedences[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        if (this.memberTypes != null) {
            i = 0;
            while (i < this.memberTypes.length) {
                if (this.memberTypes[i] != null) {
                    output.append('\n');
                    this.memberTypes[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        if (this.fields != null) {
            int fieldI = 0;
            while (fieldI < this.fields.length) {
                if (this.fields[fieldI] != null) {
                    output.append('\n');
                    this.fields[fieldI].print(indent + 1, output);
                }
                ++fieldI;
            }
        }
        if (this.methods != null) {
            i = 0;
            while (i < this.methods.length) {
                if (this.methods[i] != null) {
                    output.append('\n');
                    this.methods[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        if (this.callinCallouts != null) {
            i = 0;
            while (i < this.callinCallouts.length) {
                if (this.callinCallouts[i] != null) {
                    output.append("\n");
                    this.callinCallouts[i].print(indent + 1, output);
                }
                ++i;
            }
        }
        output.append('\n');
        return TypeDeclaration.printIndent(indent, output).append('}');
    }

    public StringBuffer printHeader(int indent, StringBuffer output) {
        int i;
        TypeDeclaration.printModifiers(this.modifiers & 0xFFFF, output);
        if (this.annotations != null) {
            TypeDeclaration.printAnnotations(this.annotations, output);
            output.append(' ');
        }
        TypeDeclaration.printTypeKind(this.modifiers, output);
        switch (TypeDeclaration.kind(this.modifiers)) {
            case 1: {
                output.append("class ");
                break;
            }
            case 2: {
                output.append("interface ");
                break;
            }
            case 3: {
                output.append("enum ");
                break;
            }
            case 4: {
                output.append("@interface ");
            }
        }
        output.append(this.name);
        if (this.typeParameters != null) {
            output.append("<");
            i = 0;
            while (i < this.typeParameters.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.typeParameters[i].print(0, output);
                ++i;
            }
            output.append(">");
        }
        if (this.superclass != null) {
            output.append(" extends ");
            this.superclass.print(0, output);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 1: 
                case 3: {
                    output.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    output.append(" extends ");
                }
            }
            i = 0;
            while (i < this.superInterfaces.length) {
                if (i > 0) {
                    output.append(", ");
                }
                this.superInterfaces[i].print(0, output);
                ++i;
            }
        }
        if (this.baseclass != null) {
            output.append(" playedBy ");
            this.baseclass.print(0, output);
        }
        return output;
    }

    @Override
    public StringBuffer printStatement(int tab, StringBuffer output) {
        return this.print(tab, output);
    }

    public int record(FunctionalExpression expression) {
        return this.functionalExpressionsCount++;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void resolve() {
        StateHelper.startProcessing(this, 20, 0);
        if (this.isRoleFile() && this.isSourceRole()) {
            this.compilationUnit.reportNLSProblems();
        }
        if ((sourceType = this.binding) == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            block81: {
                block82: {
                    block78: {
                        block80: {
                            block79: {
                                if (CharOperation.equals(this.name, TypeConstants.VAR)) {
                                    if (this.scope.compilerOptions().sourceLevel < 0x360000L) {
                                        this.scope.problemReporter().varIsReservedTypeNameInFuture(this);
                                    } else {
                                        this.scope.problemReporter().varIsReservedTypeName(this);
                                    }
                                }
                                if (((annotationTagBits = sourceType.getAnnotationTagBits()) & 0x400000000000L) == 0L && (sourceType.modifiers & 0x100000) != 0 && this.scope.compilerOptions().sourceLevel >= 0x310000L) {
                                    this.scope.problemReporter().missingDeprecatedAnnotationForType(this);
                                }
                                if ((annotationTagBits & 0x800000000000000L) != 0L && !this.binding.isFunctionalInterface(this.scope)) {
                                    this.scope.problemReporter().notAFunctionalInterface(this);
                                }
                                v0 = hasOverrideAnnotation = (this.binding.tagBits & 0x2000000000000L) != 0L;
                                if (this.isSourceRole()) {
                                    v1 = hasTSuper = (this.binding.modifiers & 0x10000000) != 0 || this.roleModel.getTSuperRoleBindings().length > 0;
                                    if (hasOverrideAnnotation && !hasTSuper) {
                                        this.scope.problemReporter().roleMustOverride(this);
                                    } else if (hasTSuper && !hasOverrideAnnotation) {
                                        this.scope.problemReporter().missingOverrideAnnotationForRole(this);
                                    }
                                }
                                if ((this.bits & 8) != 0) {
                                    this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                                }
                                v2 = needSerialVersion = this.scope.compilerOptions().getSeverity(0x20000008) != 256 && sourceType.isClass() != false && sourceType.findSuperTypeOriginatingFrom(56, false) == null && sourceType.findSuperTypeOriginatingFrom(37, false) != null;
                                if (!needSerialVersion) break block78;
                                compilationUnitScope = this.scope.compilationUnitScope();
                                methodBinding = sourceType.getExactMethod(TypeConstants.WRITEREPLACE, Binding.NO_TYPES, compilationUnitScope);
                                if (methodBinding == null || !methodBinding.isValidBinding() || methodBinding.returnType.id != 1) ** GOTO lbl-1000
                                throwsExceptions = methodBinding.thrownExceptions;
                                if (methodBinding.thrownExceptions.length == 1 && throwsExceptions[0].id == 57) {
                                    v3 = false;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v3 = needSerialVersion = true;
                                }
                                if (!needSerialVersion) break block78;
                                hasWriteObjectMethod = false;
                                hasReadObjectMethod = false;
                                argumentTypeBinding = this.scope.getType(TypeConstants.JAVA_IO_OBJECTOUTPUTSTREAM, 3);
                                if (!argumentTypeBinding.isValidBinding()) break block79;
                                methodBinding = sourceType.getExactMethod(TypeConstants.WRITEOBJECT, new TypeBinding[]{argumentTypeBinding}, compilationUnitScope);
                                if (methodBinding == null || !methodBinding.isValidBinding() || methodBinding.modifiers != 2 || methodBinding.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                                throwsExceptions = methodBinding.thrownExceptions;
                                if (methodBinding.thrownExceptions.length == 1 && throwsExceptions[0].id == 58) {
                                    v4 = true;
                                } else lbl-1000:
                                // 2 sources

                                {
                                    v4 = hasWriteObjectMethod = false;
                                }
                            }
                            if (!(argumentTypeBinding = this.scope.getType(TypeConstants.JAVA_IO_OBJECTINPUTSTREAM, 3)).isValidBinding()) break block80;
                            methodBinding = sourceType.getExactMethod(TypeConstants.READOBJECT, new TypeBinding[]{argumentTypeBinding}, compilationUnitScope);
                            if (methodBinding == null || !methodBinding.isValidBinding() || methodBinding.modifiers != 2 || methodBinding.returnType != TypeBinding.VOID) ** GOTO lbl-1000
                            throwsExceptions = methodBinding.thrownExceptions;
                            if (methodBinding.thrownExceptions.length == 1 && throwsExceptions[0].id == 58) {
                                v5 = true;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v5 = false;
                            }
                            hasReadObjectMethod = v5;
                        }
                        v6 = needSerialVersion = hasWriteObjectMethod == false || hasReadObjectMethod == false;
                    }
                    if (sourceType.findSuperTypeOriginatingFrom(21, true) != null) {
                        current /* !! */  = sourceType;
                        do {
                            if (current /* !! */ .isGenericType()) {
                                this.scope.problemReporter().genericTypeCannotExtendThrowable(this);
                                break;
                            }
                            if (current /* !! */ .isStatic()) break;
                            if (!current /* !! */ .isLocalType()) continue;
                            nestedType = (NestedTypeBinding)current /* !! */ .erasure();
                            if (nestedType.scope.methodScope().isStatic) break;
                        } while ((current /* !! */  = current /* !! */ .enclosingType()) != null);
                    }
                    if (this.precedences != null && this.precedences.length > 0) {
                        if (this.isTeam() || this.isRole()) {
                            this.binding.precedences = new PrecedenceBinding[this.precedences.length];
                            i = this.precedences.length - 1;
                            while (i >= 0) {
                                this.binding.precedences[i] = this.precedences[i].resolve(this);
                                --i;
                            }
                        } else {
                            this.scope.problemReporter().precedenceInRegularClass(this, this.precedences);
                        }
                    }
                    localMaxFieldCount = 0;
                    lastVisibleFieldID = -1;
                    hasEnumConstants = false;
                    enumConstantsWithoutBody = null;
                    resolvedMemberCount = 0;
                    if (this.memberTypes != null) {
                        resolvedMemberCount = this.memberTypes.length;
                        i = 0;
                        while (i < this.memberTypes.length) {
                            this.memberTypes[i].resolve(this.scope);
                            ++i;
                        }
                    }
                    fieldsAndMethods = (config = Config.getConfig()) != null && config.verifyMethods != false;
                    hasFieldInit = false;
                    if (!fieldsAndMethods) break block81;
                    if (this.fields == null) break block82;
                    i = 0;
                    count = this.fields.length;
                    while (i < count) {
                        field = this.fields[i];
                        switch (field.getKind()) {
                            case 3: {
                                hasEnumConstants = true;
                                if (!(field.initialization instanceof QualifiedAllocationExpression)) {
                                    if (enumConstantsWithoutBody == null) {
                                        enumConstantsWithoutBody = new FieldDeclaration[count];
                                    }
                                    enumConstantsWithoutBody[i] = field;
                                }
                            }
                            case 1: {
                                fieldBinding = field.binding;
                                if (fieldBinding == null) {
                                    if (field.initialization != null) {
                                        field.initialization.resolve(field.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                                    }
                                    this.ignoreFurtherInvestigation = true;
                                    break;
                                }
                                if (needSerialVersion && (fieldBinding.modifiers & 24) == 24 && CharOperation.equals(TypeConstants.SERIALVERSIONUID, fieldBinding.name) && TypeBinding.equalsEquals(TypeBinding.LONG, fieldBinding.type)) {
                                    needSerialVersion = false;
                                }
                                ++localMaxFieldCount;
                                lastVisibleFieldID = field.binding.id;
                                if (field.initialization != null) {
                                    hasFieldInit = true;
                                }
                                ** GOTO lbl127
                            }
                            case 2: {
                                ((Initializer)field).lastVisibleFieldID = lastVisibleFieldID + 1;
                            }
lbl127:
                            // 3 sources

                            default: {
                                field.resolve(field.isStatic() != false ? this.staticInitializerScope : this.initializerScope);
                            }
                        }
                        ++i;
                    }
                }
                if (this.typeParameters != null) {
                    TypeValueParameter.updateMaxFieldCount(this);
                }
                if (hasFieldInit && this.isRole()) {
                    WordValueAttribute.addClassFlags(this.getRoleModel(), 128);
                }
            }
            if (this.maxFieldCount < localMaxFieldCount) {
                this.maxFieldCount = localMaxFieldCount;
            }
            if (needSerialVersion) {
                javaxRmiCorbaStub = this.scope.getType(TypeConstants.JAVAX_RMI_CORBA_STUB, 4);
                if (javaxRmiCorbaStub.isValidBinding()) {
                    superclassBinding = this.binding.superclass;
                    while (superclassBinding != null) {
                        if (TypeBinding.equalsEquals(superclassBinding, javaxRmiCorbaStub)) {
                            needSerialVersion = false;
                            break;
                        }
                        superclassBinding = superclassBinding.superclass();
                    }
                }
                if (needSerialVersion) {
                    this.scope.problemReporter().missingSerialVersion(this);
                }
            }
            switch (TypeDeclaration.kind(this.modifiers)) {
                case 4: {
                    if (this.superclass != null) {
                        this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperclass(this);
                    }
                    if (this.superInterfaces == null) break;
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperinterfaces(this);
                    break;
                }
                case 3: {
                    if (!this.binding.isAbstract()) break;
                    if (!hasEnumConstants) {
                        i = 0;
                        count = this.methods.length;
                        while (i < count) {
                            methodDeclaration = this.methods[i];
                            if (methodDeclaration.isAbstract() && methodDeclaration.binding != null) {
                                this.scope.problemReporter().enumAbstractMethodMustBeImplemented(methodDeclaration);
                            }
                            ++i;
                        }
                    } else {
                        if (enumConstantsWithoutBody == null) break;
                        i = 0;
                        count = this.methods.length;
                        while (i < count) {
                            methodDeclaration = this.methods[i];
                            if (methodDeclaration.isAbstract() && methodDeclaration.binding != null) {
                                f = 0;
                                l = enumConstantsWithoutBody.length;
                                while (f < l) {
                                    if (enumConstantsWithoutBody[f] != null) {
                                        this.scope.problemReporter().enumConstantMustImplementAbstractMethod(methodDeclaration, enumConstantsWithoutBody[f]);
                                    }
                                    ++f;
                                }
                            }
                            ++i;
                        }
                    }
                    break;
                }
            }
            missingAbstractMethodslength = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            v7 = methodsLength = this.methods == null ? 0 : this.methods.length;
            if (methodsLength + missingAbstractMethodslength > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (StateMemento.hasMethodResolveStarted(this.binding)) {
                this.scope.problemReporter().abortDueToInternalError("circular compilation dependency");
                return;
            }
            StateMemento.methodResolveStart(this.binding);
            if (this.memberTypes != null && this.memberTypes.length > resolvedMemberCount && this.teamModel != null) {
                Dependencies.lateRolesCatchup(this.teamModel);
            }
            if (fieldsAndMethods && this.methods != null) {
                i = 0;
                count = this.methods.length;
                while (i < count) {
                    this.methods[i].resolve(this.scope);
                    ++i;
                }
            }
            if (this.javadoc != null) {
                if (this.scope != null && this.name != TypeConstants.PACKAGE_INFO_NAME) {
                    this.javadoc.resolve(this.scope);
                }
            } else if (!sourceType.isLocalType()) {
                visibility = sourceType.modifiers & 7;
                reporter = this.scope.problemReporter();
                severity = reporter.computeSeverity(-1610612250);
                if (this.isGenerated || this.isPurelyCopied) {
                    severity = 256;
                }
                if (severity != 256) {
                    if (this.enclosingType != null) {
                        visibility = Util.computeOuterMostVisibility(this.enclosingType, visibility);
                    }
                    javadocModifiers = this.binding.modifiers & -8 | visibility;
                    reporter.javadocMissing(this.sourceStart, this.sourceEnd, severity, javadocModifiers);
                }
            }
            this.updateNestInfo();
            fieldsDecls = this.fields;
            if (fieldsDecls != null) {
                var20_37 = fieldsDecls;
                var19_36 = fieldsDecls.length;
                severity = 0;
                while (severity < var19_36) {
                    fieldDeclaration = var20_37[severity];
                    fieldDeclaration.resolveJavadoc(this.initializerScope);
                    ++severity;
                }
            }
            if ((methodDecls = this.methods) != null) {
                var21_39 = methodDecls;
                var20_38 = methodDecls.length;
                var19_36 = 0;
                while (var19_36 < var20_38) {
                    methodDeclaration = var21_39[var19_36];
                    methodDeclaration.resolveJavadoc();
                    ++var19_36;
                }
            }
        }
        catch (AbortType v8) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    @Override
    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            TypeBinding existing = blockScope.getType(this.name);
            if (existing instanceof ReferenceBinding && existing != this.binding && existing.isValidBinding()) {
                ReferenceBinding existingType = (ReferenceBinding)existing;
                if (existingType instanceof TypeVariableBinding) {
                    blockScope.problemReporter().typeHiding(this, (TypeVariableBinding)existingType);
                    Scope outerScope = blockScope.parent;
                    while (outerScope != null) {
                        TypeBinding existing2 = outerScope.getType(this.name);
                        if (existing2 instanceof TypeVariableBinding && existing2.isValidBinding()) {
                            TypeVariableBinding tvb = (TypeVariableBinding)existingType;
                            Binding declaringElement = tvb.declaringElement;
                            if (declaringElement instanceof ReferenceBinding && CharOperation.equals(((ReferenceBinding)declaringElement).sourceName(), this.name)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                        } else {
                            if (existing2 instanceof ReferenceBinding && existing2.isValidBinding() && outerScope.isDefinedInType((ReferenceBinding)existing2)) {
                                blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                                break;
                            }
                            if (existing2 == null) break;
                        }
                        outerScope = outerScope.parent;
                    }
                } else if (existingType instanceof LocalTypeBinding && ((LocalTypeBinding)existingType).scope.methodScope() == blockScope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (existingType instanceof LocalTypeBinding && blockScope.isLambdaSubscope() && blockScope.enclosingLambdaScope().enclosingMethodScope() == ((LocalTypeBinding)existingType).scope.methodScope()) {
                    blockScope.problemReporter().duplicateNestedType(this);
                } else if (blockScope.isDefinedInType(existingType)) {
                    blockScope.problemReporter().typeCollidesWithEnclosingType(this);
                } else if (blockScope.isDefinedInSameUnit(existingType)) {
                    blockScope.problemReporter().typeHiding(this, existingType);
                }
            }
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            Dependencies.ensureBindingState(this.binding, 19);
            this.resolve();
            this.updateMaxFieldCount();
        }
    }

    public void resolve(ClassScope upperScope) {
        if (this.isRoleFile() && this.roleModel.getState() >= 20) {
            return;
        }
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            upperScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.updateMaxFieldCount();
    }

    public void resolve(CompilationUnitScope upperScope) {
        this.resolve();
        this.updateMaxFieldCount();
    }

    @Override
    public void tagAsHavingErrors() {
        if (this.isRole() && this.roleModel != null) {
            this.roleModel.setErrorFlag(true);
        } else {
            this.ignoreFurtherInvestigation = true;
        }
    }

    @Override
    public void tagAsHavingIgnoredMandatoryErrors(int problemId) {
    }

    @Override
    public void resetErrorFlag() {
        if (this.isRole() && this.roleModel != null) {
            this.roleModel.setErrorFlag(false);
        } else {
            this.ignoreFurtherInvestigation = false;
        }
    }

    public void addResolvedPrecedence(char[] roleName, PrecedenceBinding precBinding) {
        if (this.enclosingType != null) {
            this.enclosingType.addResolvedPrecedence(this.name, precBinding);
            return;
        }
        if (this.binding.precedences == PrecedenceBinding.NoPrecedences) {
            this.binding.precedences = new PrecedenceBinding[]{precBinding};
        } else {
            int len = this.binding.precedences.length;
            this.binding.precedences = new PrecedenceBinding[len + 1];
            System.arraycopy(this.binding.precedences, 0, this.binding.precedences, 1, len);
            this.binding.precedences[0] = precBinding;
        }
    }

    public void traverse(ASTVisitor visitor, CompilationUnitScope unitScope) {
        try {
            if (visitor.visit(this, unitScope)) {
                int length;
                int i;
                if (this.javadoc != null) {
                    this.javadoc.traverse(visitor, this.scope);
                }
                if (this.annotations != null) {
                    int annotationsLength = this.annotations.length;
                    i = 0;
                    while (i < annotationsLength) {
                        this.annotations[i].traverse(visitor, this.staticInitializerScope);
                        ++i;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.baseclass != null) {
                    this.baseclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    length = this.superInterfaces.length;
                    i = 0;
                    while (i < length) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.typeParameters != null) {
                    length = this.typeParameters.length;
                    i = 0;
                    while (i < length) {
                        this.typeParameters[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    length = this.memberTypes.length;
                    i = 0;
                    while (i < length) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    length = this.fields.length;
                    i = 0;
                    while (i < length) {
                        FieldDeclaration field = this.fields[i];
                        if (field.isStatic()) {
                            field.traverse(visitor, this.staticInitializerScope);
                        } else {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    length = this.methods.length;
                    i = 0;
                    while (i < length) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.callinCallouts != null) {
                    int methodBindingsLength = this.callinCallouts.length;
                    int idx = 0;
                    while (idx < methodBindingsLength) {
                        this.callinCallouts[idx].traverse(visitor, this.scope);
                        ++idx;
                    }
                }
            }
            visitor.endVisit(this, unitScope);
        }
        catch (AbortType abortType) {}
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        try {
            if (visitor.visit(this, blockScope)) {
                int length;
                int i;
                if (this.javadoc != null) {
                    this.javadoc.traverse(visitor, this.scope);
                }
                if (this.annotations != null) {
                    int annotationsLength = this.annotations.length;
                    i = 0;
                    while (i < annotationsLength) {
                        this.annotations[i].traverse(visitor, this.staticInitializerScope);
                        ++i;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    length = this.superInterfaces.length;
                    i = 0;
                    while (i < length) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.typeParameters != null) {
                    length = this.typeParameters.length;
                    i = 0;
                    while (i < length) {
                        this.typeParameters[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    length = this.memberTypes.length;
                    i = 0;
                    while (i < length) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    length = this.fields.length;
                    i = 0;
                    while (i < length) {
                        FieldDeclaration field = this.fields[i];
                        if (!field.isStatic() || field.isFinal()) {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    length = this.methods.length;
                    i = 0;
                    while (i < length) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {}
    }

    public void traverse(ASTVisitor visitor, ClassScope classScope) {
        try {
            if (visitor.visit(this, classScope)) {
                int length;
                int i;
                if (this.javadoc != null) {
                    this.javadoc.traverse(visitor, this.scope);
                }
                if (this.annotations != null) {
                    int annotationsLength = this.annotations.length;
                    i = 0;
                    while (i < annotationsLength) {
                        this.annotations[i].traverse(visitor, this.staticInitializerScope);
                        ++i;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(visitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    length = this.superInterfaces.length;
                    i = 0;
                    while (i < length) {
                        this.superInterfaces[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.typeParameters != null) {
                    length = this.typeParameters.length;
                    i = 0;
                    while (i < length) {
                        this.typeParameters[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.memberTypes != null) {
                    length = this.memberTypes.length;
                    i = 0;
                    while (i < length) {
                        this.memberTypes[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.fields != null) {
                    length = this.fields.length;
                    i = 0;
                    while (i < length) {
                        FieldDeclaration field = this.fields[i];
                        if (field.isStatic()) {
                            field.traverse(visitor, this.staticInitializerScope);
                        } else {
                            field.traverse(visitor, this.initializerScope);
                        }
                        ++i;
                    }
                }
                if (this.methods != null) {
                    length = this.methods.length;
                    i = 0;
                    while (i < length) {
                        this.methods[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
                if (this.callinCallouts != null) {
                    int callinCalloutsLength = this.callinCallouts.length;
                    i = 0;
                    while (i < callinCalloutsLength) {
                        this.callinCallouts[i].traverse(visitor, this.scope);
                        ++i;
                    }
                }
            }
            visitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {}
    }

    void updateMaxFieldCount() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration outerMostType = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > outerMostType.maxFieldCount) {
            outerMostType.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = outerMostType.maxFieldCount;
        }
    }

    private SourceTypeBinding findNestHost() {
        ClassScope classScope = this.scope.enclosingTopMostClassScope();
        return classScope != null ? classScope.referenceContext.binding : null;
    }

    void updateNestInfo() {
        if (this.binding == null) {
            return;
        }
        SourceTypeBinding nestHost = this.findNestHost();
        if (nestHost != null && !this.binding.equals(nestHost)) {
            this.binding.setNestHost(nestHost);
            nestHost.addNestMember(this.binding);
        }
    }

    public boolean isPackageInfo() {
        return CharOperation.equals(this.name, TypeConstants.PACKAGE_INFO_NAME);
    }

    public boolean isSecondary() {
        return (this.bits & 0x1000) != 0;
    }

    public void pushDownBindingProblem() {
        this.ignoreFurtherInvestigation = false;
        if (this.callinCallouts != null) {
            int i = 0;
            while (i < this.callinCallouts.length) {
                this.callinCallouts[i].ignoreFurtherInvestigation = true;
                ++i;
            }
        }
        this.binding.callinCallouts = Binding.NO_CALLIN_CALLOUT_BINDINGS;
    }

    public void removeDetails() {
        this.fields = null;
        this.methods = null;
        this.callinCallouts = null;
        if (this.memberTypes != null) {
            int i = 0;
            while (i < this.memberTypes.length) {
                this.memberTypes[i].removeDetails();
                ++i;
            }
        }
    }

    public void cleanupModels() {
        if (this.roleModel != null) {
            this.roleModel.cleanup();
            this.roleModel.setState(25);
        }
        if (this.teamModel != null) {
            this.teamModel.cleanup();
            this.teamModel.setState(25);
        }
        if (this.model != null) {
            this.model.cleanup();
            this.model.setState(25);
        }
    }
}

