/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.objectteams.otdt.internal.core.compiler.ast;

import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.ThisReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.objectteams.otdt.core.compiler.IOTConstants;
import org.eclipse.objectteams.otdt.internal.core.compiler.model.RoleModel;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstEdit;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.AstGenerator;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TSuperHelper;
import org.eclipse.objectteams.otdt.internal.core.compiler.util.TypeAnalyzer;

public class RoleInitializationMethod
extends MethodDeclaration
implements IOTConstants {
    public RoleInitializationMethod(CompilationResult compilationResult) {
        super(compilationResult);
        this.returnType = TypeReference.baseTypeReference(6, 0);
        this.selector = INIT_METHOD_NAME;
        this.bits |= 0x40;
        this.isGenerated = true;
        this.modifiers = 2;
    }

    public void analyseCode(ClassScope classScope, InitializationFlowContext initializationContext, FlowInfo info) {
        if (this.statements != null) {
            if (this.binding != null) {
                this.binding.modifiers |= 0x8000000;
            }
            super.analyseCode(classScope, initializationContext, info);
        }
    }

    public void parseStatements(Parser parser, CompilationUnitDeclaration unit) {
        this.statements = new Statement[0];
    }

    public void resolveStatements() {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        MethodBinding tsuperInit = this.getTSuperInit(this.scope.referenceType().getRoleModel());
        if (tsuperInit != null) {
            AstGenerator gen = new AstGenerator(this.sourceStart, this.sourceEnd);
            MessageSend tsuperCall = gen.messageSend(ThisReference.implicitThis(), this.selector, null);
            tsuperCall.arguments = TSuperHelper.addMarkerArgument(null, tsuperCall, tsuperCall.arguments, this.scope);
            if (this.statements == null) {
                this.setStatements(new Statement[]{tsuperCall});
            } else {
                int len = this.statements.length;
                Statement[] newStatements = new Statement[len + 1];
                System.arraycopy(this.statements, 0, newStatements, 0, len);
                newStatements[len] = tsuperCall;
                this.setStatements(newStatements);
            }
            super.resolveStatements();
        } else {
            this.setStatements(new Statement[0]);
        }
    }

    protected void endOfMethodHook(ClassFile classfile) {
        TypeDeclaration declaringType = this.scope.classScope().referenceContext;
        if (declaringType.fields != null) {
            int i = 0;
            int max = declaringType.fields.length;
            while (i < max) {
                FieldDeclaration fieldDecl = declaringType.fields[i];
                if (!fieldDecl.isStatic()) {
                    fieldDecl.generateCode(this.scope, classfile.codeStream);
                }
                ++i;
            }
        }
    }

    public static void setupRoleInitializationMethod(RoleModel role) {
        if (TypeAnalyzer.isTopConfined(role.getBinding())) {
            return;
        }
        TypeDeclaration roleClassDeclaration = role.getAst();
        AstGenerator gen = new AstGenerator(roleClassDeclaration.sourceStart, roleClassDeclaration.sourceEnd);
        RoleInitializationMethod initMethod = gen.roleInitializationMethod(roleClassDeclaration.compilationResult);
        AstEdit.addMethod(roleClassDeclaration, initMethod);
        if (!role.getBinding().isDirectRole()) {
            initMethod.resolve(role.getAst().scope);
        }
    }

    private MethodBinding getTSuperInit(RoleModel role) {
        if (!role.getBinding().isDirectRole()) {
            return null;
        }
        ReferenceBinding tsuperRole = role.getTSuperRoleBinding();
        if (tsuperRole != null) {
            if (TypeAnalyzer.isSourceTypeWithErrors(tsuperRole)) {
                return null;
            }
            MethodBinding[] tsuperInits = tsuperRole.getMethods(INIT_METHOD_NAME);
            if (tsuperInits != null && tsuperInits.length >= 1) {
                int i = 0;
                while (i < tsuperInits.length) {
                    if (tsuperInits[i].parameters.length == 0) {
                        return tsuperInits[i];
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public static Statement genInvokeInitMethod(Expression receiver, ReferenceBinding receiverType, AstGenerator gen) {
        if (TypeAnalyzer.isTopConfined(receiverType)) {
            return gen.emptyStatement();
        }
        return gen.messageSend(receiver, INIT_METHOD_NAME, null);
    }
}

