/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.widgets.figureparts;

import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class PolarPoint {
    public int r;
    public double theta;

    public PolarPoint(int r, double theta) {
        this.r = r;
        this.theta = theta;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.r;
        long temp = Double.doubleToLongBits(this.theta);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolarPoint other = (PolarPoint)obj;
        if (this.r != other.r) {
            return false;
        }
        return Double.doubleToLongBits(this.theta) == Double.doubleToLongBits(other.theta);
    }

    public Point toPoint() {
        int x = (int)((double)this.r * Math.cos(this.theta));
        int y = (int)((double)(-this.r) * Math.sin(this.theta));
        return new Point(x, y);
    }

    public Point toAbsolutePoint(Rectangle rect) {
        Point p = this.toPoint();
        return p.translate(rect.width / 2, rect.height / 2).translate(rect.x, rect.y);
    }

    public Point toRelativePoint(Rectangle rect) {
        Point p = this.toPoint();
        return p.translate(rect.width / 2, rect.height / 2);
    }

    public static PolarPoint point2PolarPoint(Point pole, Point point) {
        int x = point.x - pole.x;
        int y = point.y - pole.y;
        double r = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0));
        double theta = Math.acos((double)x / r);
        if (y > 0) {
            theta = Math.PI * 2 - theta;
        }
        return new PolarPoint((int)r, theta);
    }

    public void rotateAxis(double axisDirection, boolean inRadians) {
        if (!inRadians) {
            axisDirection = axisDirection * Math.PI / 180.0;
        }
        this.theta -= axisDirection;
        if (this.theta < 0.0) {
            this.theta += Math.PI * 2;
        }
    }

    public String toString() {
        return "(" + this.r + ", " + this.theta * 180.0 / Math.PI + ")";
    }
}

