/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.ctreecombo;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.nebula.widgets.ctreecombo.CTreeCombo;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class CTreeComboItem
extends Item {
    static final String DATA_ID = "org.eclipse.nebula.widgets.ctreecombo.CTreeComboItem";
    private CTreeCombo parent;
    private CTreeComboItem parentItem;
    private List<CTreeComboItem> childItems = new ArrayList<CTreeComboItem>();
    private ArrayList<Color> backgroundColors = new ArrayList();
    private ArrayList<Color> foregroundColors = new ArrayList();
    private ArrayList<Font> fonts = new ArrayList();
    private ArrayList<Image> images = new ArrayList();
    private ArrayList<String> texts = new ArrayList();
    private ArrayList<Rectangle> bounds = new ArrayList();
    private ArrayList<Rectangle> textbounds = new ArrayList();
    private ArrayList<Rectangle> imageBounds = new ArrayList();
    private Color foreground;
    private Color background;
    private Font font;
    private Rectangle bound;
    private TreeItem realTreeItem;

    public CTreeComboItem(CTreeComboItem parentItem, int style, int index) {
        super((Widget)parentItem.parent, style);
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parentItem.childItems.add(index, this);
        if (parentItem.realTreeItem != null && !parentItem.realTreeItem.isDisposed()) {
            this.setRealTreeItem(new TreeItem(parentItem.realTreeItem, style, index));
        }
    }

    public CTreeComboItem(CTreeComboItem parentItem, int style) {
        super((Widget)parentItem.parent, style);
        this.parent = parentItem.parent;
        this.parentItem = parentItem;
        this.parentItem.childItems.add(this);
        if (parentItem.realTreeItem != null && !parentItem.realTreeItem.isDisposed()) {
            this.setRealTreeItem(new TreeItem(parentItem.realTreeItem, style));
        }
    }

    public CTreeComboItem(CTreeCombo parent, int style, int index) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parent.items.add(index, this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeItem(new TreeItem(this.parent.tree, style, index));
        }
    }

    public CTreeComboItem(CTreeCombo parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        this.parent.items.add(this);
        if (this.parent.tree != null && !this.parent.tree.isDisposed()) {
            this.setRealTreeItem(new TreeItem(this.parent.tree, style));
        }
    }

    public void dispose() {
        super.dispose();
        if (this.realTreeItem != null && !this.realTreeItem.isDisposed()) {
            this.realTreeItem.dispose();
        }
        if (this.parentItem != null && !this.parentItem.isDisposed()) {
            this.parentItem.childItems.remove((Object)this);
        }
        for (CTreeComboItem child : this.childItems) {
            child.dispose();
        }
    }

    void setRealTreeItem(TreeItem realTreeItem) {
        this.realTreeItem = realTreeItem;
        this.realTreeItem.setData(DATA_ID, (Object)this);
    }

    TreeItem getRealTreeItem() {
        return this.realTreeItem;
    }

    public CTreeComboItem[] getItems() {
        this.checkWidget();
        return this.childItems.toArray(new CTreeComboItem[0]);
    }

    private boolean checkRealItem() {
        return this.realTreeItem != null && !this.realTreeItem.isDisposed();
    }

    public void setImage(Image image) {
        super.setImage(image);
    }

    public void setText(String string) {
        super.setText(string);
    }

    public Rectangle getBounds(int index) {
        this.checkWidget();
        if (index < 0 || index > this.bounds.size() - 1) {
            SWT.error((int)5);
        }
        return this.bounds.get(index);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        return this.bound;
    }

    public CTreeCombo getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Color getBackground() {
        this.checkWidget();
        return this.background;
    }

    public Color getBackground(int index) {
        this.checkWidget();
        if (index < 0 || index > this.backgroundColors.size() - 1) {
            SWT.error((int)5);
        }
        return this.backgroundColors.get(index);
    }

    public Font getFont() {
        this.checkWidget();
        return this.font;
    }

    public Font getFont(int index) {
        this.checkWidget();
        if (index < 0 || index > this.fonts.size() - 1) {
            SWT.error((int)5);
        }
        return this.fonts.get(index);
    }

    public Color getForeground() {
        this.checkWidget();
        return this.foreground;
    }

    public Color getForeground(int index) {
        this.checkWidget();
        if (index < 0 || index > this.foregroundColors.size() - 1) {
            SWT.error((int)5);
        }
        return this.foregroundColors.get(index);
    }

    public Image getImage(int index) {
        this.checkWidget();
        if (index < 0 || index > this.images.size() - 1) {
            SWT.error((int)5);
        }
        return this.images.get(index);
    }

    public String getText(int index) {
        this.checkWidget();
        if (index < 0 || index > this.texts.size() - 1) {
            SWT.error((int)5);
        }
        return this.texts.get(index);
    }

    public void setBackground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.ensureArraySizes(index);
        this.backgroundColors.set(index, color);
    }

    private void ensureArraySizes(int index) {
        this.backgroundColors.ensureCapacity(index);
        this.foregroundColors.ensureCapacity(index);
        this.fonts.ensureCapacity(index);
        this.images.ensureCapacity(index);
        this.texts.ensureCapacity(index);
        this.bounds.ensureCapacity(index);
        this.textbounds.ensureCapacity(index);
        this.imageBounds.ensureCapacity(index);
    }

    public void setBackground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.background = color;
    }

    public void setFont(Font font) {
        this.checkWidget();
        this.font = font;
    }

    public void setFont(int index, Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            SWT.error((int)5);
        }
        this.ensureArraySizes(index);
        this.fonts.set(index, font);
    }

    public void setForeground(int index, Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.ensureArraySizes(index);
        this.foregroundColors.set(index, color);
    }

    public void setForeground(Color color) {
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            SWT.error((int)5);
        }
        this.foreground = color;
    }

    public void setImage(int index, Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            SWT.error((int)5);
        }
        this.ensureArraySizes(index);
        this.images.set(index, image);
    }

    public void setText(int index, String string) {
        this.checkWidget();
        this.ensureArraySizes(index);
        this.texts.set(index, string == null ? "" : string);
    }

    public CTreeComboItem getParentItem() {
        this.checkWidget();
        return this.parentItem;
    }

    public boolean getExpanded() {
        this.checkWidget();
        if (this.checkRealItem()) {
            return this.realTreeItem.getExpanded();
        }
        return false;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.childItems.size();
    }

    public CTreeComboItem getItem(int index) {
        this.checkWidget();
        return this.childItems.get(index);
    }

    public int indexOf(CTreeComboItem item) {
        this.checkWidget();
        return this.childItems.indexOf((Object)item);
    }

    public Rectangle getTextBounds(int index) {
        this.checkWidget();
        if (index < 0 || index > this.textbounds.size() - 1) {
            SWT.error((int)5);
        }
        return this.textbounds.get(index);
    }

    public Rectangle getImageBounds(int index) {
        this.checkWidget();
        if (index < 0 || index > this.imageBounds.size() - 1) {
            SWT.error((int)5);
        }
        return this.imageBounds.get(index);
    }

    public void setExpanded(boolean expand) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setExpanded(expand);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        if (this.checkRealItem()) {
            this.realTreeItem.setItemCount(count);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        this.realTreeItem.clear(index, all);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.realTreeItem.clearAll(all);
    }

    public void buildRealTreeItem(Tree tree, int numberOfColumns) {
        TreeItem ti = this.parentItem != null && this.parentItem.realTreeItem != null ? new TreeItem(this.parentItem.realTreeItem, this.getStyle()) : new TreeItem(tree, this.getStyle());
        if (this.getImage() != null) {
            ti.setImage(this.getImage());
        }
        if (this.getText() != null) {
            ti.setText(this.getText());
        }
        if (this.getBackground() != null) {
            ti.setBackground(this.getBackground());
        }
        if (this.getForeground() != null) {
            ti.setForeground(this.getForeground());
        }
        if (this.getFont() != null) {
            ti.setFont(this.getFont());
        }
        int i = 0;
        while (i < numberOfColumns) {
            if (this.getFont(i) != null) {
                ti.setFont(i, this.getFont(i));
            }
            if (this.getBackground(i) != null) {
                ti.setBackground(i, this.getBackground(i));
            }
            if (this.getForeground(i) != null) {
                ti.setForeground(i, this.getForeground(i));
            }
            if (this.getImage(i) != null) {
                ti.setImage(i, this.getImage(i));
            }
            if (this.getText(i) != null) {
                ti.setText(i, this.getText(i));
            }
            ++i;
        }
        this.setRealTreeItem(ti);
    }
}

