/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.example;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.XPromptChange;
import org.eclipse.nebula.widgets.xviewer.XViewer;
import org.eclipse.nebula.widgets.xviewer.example.MyXViewerFactory;
import org.eclipse.nebula.widgets.xviewer.example.model.ISomeTask;
import org.eclipse.nebula.widgets.xviewer.example.model.SomeTask;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class MyXViewer
extends XViewer {
    private final Set<ISomeTask> runList = new HashSet<ISomeTask>();

    public MyXViewer(Tree tree) {
        super(tree, (IXViewerFactory)new MyXViewerFactory());
    }

    public MyXViewer(Shell shell_1, int i) {
        super((Composite)shell_1, i, (IXViewerFactory)new MyXViewerFactory());
    }

    public MyXViewer(Composite parent, int i) {
        super(parent, i, (IXViewerFactory)new MyXViewerFactory());
    }

    public boolean isScheduled(ISomeTask autoRunTask) {
        return true;
    }

    public boolean isRun(ISomeTask autoRunTask) {
        return this.runList.contains(autoRunTask);
    }

    public void setRun(ISomeTask autoRunTask, boolean run) {
        if (run) {
            this.runList.add(autoRunTask);
        } else {
            this.runList.remove(autoRunTask);
        }
    }

    public boolean handleLeftClickInIconArea(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn.getData().equals(MyXViewerFactory.Run_Col)) {
            this.setRun((ISomeTask)treeItem.getData(), !this.isRun((ISomeTask)treeItem.getData()));
            this.update(treeItem.getData(), null);
            return true;
        }
        return super.handleLeftClickInIconArea(treeColumn, treeItem);
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        if (treeColumn.getData().equals(MyXViewerFactory.Last_Run_Date)) {
            Date promptChangeDate = XPromptChange.promptChangeDate((String)MyXViewerFactory.Last_Run_Date.getName(), (Date)new Date());
            System.out.println("promptChangeDate " + String.valueOf(promptChangeDate));
            SomeTask task = (SomeTask)treeItem.getData();
            task.setLastRunDate(promptChangeDate);
            this.refresh();
        }
        return super.handleAltLeftClick(treeColumn, treeItem);
    }
}

