/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.effects.stw.example;

import org.eclipse.nebula.effects.stw.Transition;
import org.eclipse.nebula.effects.stw.TransitionListener;
import org.eclipse.nebula.effects.stw.TransitionManager;
import org.eclipse.nebula.effects.stw.transitions.CubicRotationTransition;
import org.eclipse.nebula.effects.stw.transitions.FadeTransition;
import org.eclipse.nebula.effects.stw.transitions.SlideTransition;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractSTWDemoFrame {
    public static final String[] DIRECTIONS_NAMES = new String[]{"Left", "Right", "Up", "Down", "Right/Left", "Down/Up", "Random right and left", "Random up and down", "Random"};
    public static final int DIR_LEFT = 0;
    public static final int DIR_RIGHT = 1;
    public static final int DIR_UP = 2;
    public static final int DIR_DOWN = 3;
    public static final int DIR_RIGHT_LEFT = 4;
    public static final int DIR_DOWN_UP = 5;
    public static final int DIR_RANDOM_RIGHT_AND_LEFT = 6;
    public static final int DIR_RANDOM_UP_AND_DOWN = 7;
    public static final int DIR_RANDOM = 8;
    private int _selectedDirection = 8;
    protected Composite _containerComposite = null;
    protected TransitionManager _tm = null;
    public static final int TRANSITION_FADE = 0;
    public static final int TRANSITION_SLIDE = 1;
    public static final int TRANSITION_CUBIC_ROTATION = 2;
    private Transition[] _transitions;

    public void init(Composite parent) {
        this._containerComposite = new Composite(parent, 0);
        this.init();
        this._transitions = new Transition[]{new FadeTransition(this._tm), new SlideTransition(this._tm), new CubicRotationTransition(this._tm)};
        this._tm.setTransition(this._transitions[0]);
        this._tm.addTransitionListener(new TransitionListener(){

            public void transitionFinished(TransitionManager transition) {
                System.out.println("End Of Transition! current item: " + transition.getTransitionable().getSelection());
            }
        });
    }

    protected abstract void init();

    protected abstract void initImages();

    public Composite getContainerComposiste() {
        return this._containerComposite;
    }

    public TransitionManager getTransitionManager() {
        return this._tm;
    }

    public Transition getTransitionEffect(int transition) {
        return this._transitions[transition];
    }

    public void selectDirection(int direction) {
        if (direction >= 0 && direction < DIRECTIONS_NAMES.length) {
            this._selectedDirection = direction;
        }
    }

    protected double getSelectedDirection(int toIndex, int fromIndex) {
        switch (this._selectedDirection) {
            case 1: {
                return 0.0;
            }
            case 0: {
                return 180.0;
            }
            case 2: {
                return 90.0;
            }
            case 3: {
                return 270.0;
            }
            case 4: {
                return toIndex > fromIndex ? 0.0 : 180.0;
            }
            case 5: {
                return toIndex > fromIndex ? 270.0 : 90.0;
            }
            case 6: {
                return Math.random() > 0.5 ? 0.0 : 180.0;
            }
            case 7: {
                return Math.random() > 0.5 ? 270.0 : 90.0;
            }
        }
        if (Math.random() > 0.5) {
            return Math.random() > 0.5 ? 0.0 : 180.0;
        }
        return Math.random() > 0.5 ? 270.0 : 90.0;
    }
}

