/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable.editor;

import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.PTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class PTBaseTextEditor
extends PTEditor {
    protected Text text;

    @Override
    public ControlEditor render(PTWidget widget, Item item, PTProperty property) {
        Object editor = widget.getWidget() instanceof Table ? new TableEditor((Table)widget.getWidget()) : new TreeEditor((Tree)widget.getWidget());
        widget.updateDescriptionPanel(property);
        this.text = new Text(widget.getWidget(), this.getStyle());
        this.addVerifyListeners();
        this.text.setText(StringUtil.safeToString((Object)property.getValue()));
        this.text.addListener(24, event -> property.setValue(this.convertValue()));
        this.text.addListener(15, event -> widget.updateDescriptionPanel(property));
        editor.grabHorizontal = true;
        if (widget.getWidget() instanceof Table) {
            editor.setEditor((Control)this.text, (TableItem)item, 1);
        } else {
            ((TreeEditor)editor).setEditor((Control)this.text, (TreeItem)item, 1);
        }
        this.text.setEnabled(property.isEnabled());
        return editor;
    }

    public abstract void addVerifyListeners();

    public abstract Object convertValue();

    public abstract int getStyle();
}

