/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.opal.propertytable;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.nebula.widgets.opal.commons.ResourceManager;
import org.eclipse.nebula.widgets.opal.commons.StringUtil;
import org.eclipse.nebula.widgets.opal.propertytable.AbstractPTWidget;
import org.eclipse.nebula.widgets.opal.propertytable.PTProperty;
import org.eclipse.nebula.widgets.opal.propertytable.editor.PTStringEditor;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class PTWidgetTable
extends AbstractPTWidget {
    private Table table;

    PTWidgetTable() {
    }

    @Override
    protected void buildWidget(Composite parent) {
        this.table = new Table(parent, 65536);
        this.table.setLinesVisible(true);
        this.table.setHeaderVisible(true);
        this.table.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        final TableColumn propertyColumn = new TableColumn(this.table, 0);
        propertyColumn.setText(ResourceManager.getLabel((String)"property"));
        final TableColumn valueColumn = new TableColumn(this.table, 0);
        valueColumn.setText(ResourceManager.getLabel((String)"value"));
        this.fillData();
        this.table.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = PTWidgetTable.this.table.getParent().getClientArea();
                Point size = PTWidgetTable.this.table.computeSize(-1, -1);
                ScrollBar vBar = PTWidgetTable.this.table.getVerticalBar();
                int width = area.width - PTWidgetTable.this.table.computeTrim((int)0, (int)0, (int)0, (int)0).width - vBar.getSize().x;
                if (size.y > area.height + PTWidgetTable.this.table.getHeaderHeight()) {
                    Point vBarSize = vBar.getSize();
                    width -= vBarSize.x;
                }
                propertyColumn.pack();
                valueColumn.setWidth(width - propertyColumn.getWidth());
                PTWidgetTable.this.table.removeControlListener((ControlListener)this);
            }
        });
        this.table.addListener(13, event -> {
            if (this.table.getSelectionCount() == 0 || this.table.getSelection()[0] == null) {
                return;
            }
            this.updateDescriptionPanel(this.table.getSelection()[0].getData());
        });
    }

    private void fillData() {
        ArrayList<PTProperty> props;
        if (this.getParentPropertyTable().sorted) {
            props = new ArrayList<PTProperty>(this.getParentPropertyTable().getPropertiesAsList());
            Collections.sort(props, (o1, o2) -> {
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1.getName() == null && o2.getName() != null) {
                    return -1;
                }
                if (o1.getName() != null && o2.getName() == null) {
                    return 1;
                }
                return o1.getName().compareTo(o2.getName());
            });
        } else {
            props = new ArrayList<PTProperty>(this.getParentPropertyTable().getPropertiesAsList());
        }
        ArrayList editors = new ArrayList();
        for (PTProperty p : props) {
            TableItem item = new TableItem(this.table, 0);
            item.setData((Object)p);
            item.setText(0, StringUtil.safeToString((Object)p.getDisplayName()));
            if (p.getEditor() == null) {
                p.setEditor(new PTStringEditor());
            }
            ControlEditor editor = p.getEditor().render(this, (Item)item, p);
            item.addListener(12, event -> {
                if (editor.getEditor() != null) {
                    editor.getEditor().dispose();
                }
                editor.dispose();
            });
            if (!p.isEnabled()) {
                item.setForeground(this.table.getDisplay().getSystemColor(15));
            }
            p.setAssociatedItem((Item)item);
        }
        this.table.setData(editors);
    }

    @Override
    public void refillData() {
        try {
            this.table.setRedraw(false);
            TableItem[] tableItemArray = this.table.getItems();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                item.dispose();
                ++n2;
            }
            if (this.table.getData() != null) {
                List list = (List)this.table.getData();
                for (ControlEditor c : list) {
                    c.dispose();
                }
                list.clear();
                this.table.setData(null);
            }
            this.fillData();
        }
        finally {
            this.table.setRedraw(true);
            this.table.redraw();
            this.table.update();
        }
    }

    @Override
    public Composite getWidget() {
        return this.table;
    }
}

