/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.page;

import org.eclipse.nebula.paperclips.core.PaperClips;
import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.nebula.paperclips.core.page.PageDecoration;
import org.eclipse.nebula.paperclips.core.page.PageIterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;

public class PagePrint
implements Print {
    private static final int DEFAULT_GAP = 1;
    PageDecoration header;
    int headerGap = 1;
    Print body;
    int footerGap = 1;
    PageDecoration footer;

    public PagePrint(PageDecoration header, int headerGap, Print body) {
        this(header, headerGap, body, 1, null);
    }

    public PagePrint(PageDecoration header, Print body) {
        this(header, 1, body);
    }

    public PagePrint(Print body) {
        this(null, body, null);
    }

    public PagePrint(Print body, PageDecoration footer) {
        this(body, 1, footer);
    }

    public PagePrint(Print body, int footerGap, PageDecoration footer) {
        this(null, 1, body, footerGap, footer);
    }

    public PagePrint(PageDecoration header, Print body, PageDecoration footer) {
        this(header, 1, body, 1, footer);
    }

    public PagePrint(PageDecoration header, int headerGap, Print body, int footerGap, PageDecoration footer) {
        this.setHeader(header);
        this.setHeaderGap(headerGap);
        this.setBody(body);
        this.setFooterGap(footerGap);
        this.setFooter(footer);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.body == null ? 0 : this.body.hashCode());
        result = 31 * result + (this.footer == null ? 0 : this.footer.hashCode());
        result = 31 * result + this.footerGap;
        result = 31 * result + (this.header == null ? 0 : this.header.hashCode());
        result = 31 * result + this.headerGap;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PagePrint other = (PagePrint)obj;
        if (this.body == null ? other.body != null : !this.body.equals(other.body)) {
            return false;
        }
        if (this.footer == null ? other.footer != null : !this.footer.equals(other.footer)) {
            return false;
        }
        if (this.footerGap != other.footerGap) {
            return false;
        }
        if (this.header == null ? other.header != null : !this.header.equals(other.header)) {
            return false;
        }
        return this.headerGap == other.headerGap;
    }

    public PageDecoration getHeader() {
        return this.header;
    }

    public void setHeader(PageDecoration header) {
        this.header = header;
    }

    public int getHeaderGap() {
        return this.headerGap;
    }

    public void setHeaderGap(int points) {
        this.headerGap = PagePrint.checkGap(points);
    }

    public Print getBody() {
        return this.body;
    }

    public void setBody(Print body) {
        Util.notNull(body);
        this.body = body;
    }

    public PageDecoration getFooter() {
        return this.footer;
    }

    public void setFooter(PageDecoration footer) {
        this.footer = footer;
    }

    public int getFooterGap() {
        return this.footerGap;
    }

    public void setFooterGap(int points) {
        this.footerGap = PagePrint.checkGap(points);
    }

    private static int checkGap(int gap) {
        if (gap < 0) {
            PaperClips.error(5, "Gap must be >= 0 (value is " + gap + ")");
        }
        return gap;
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        if (this.header == null && this.footer == null) {
            return this.body.iterator(device, gc);
        }
        return new PageIterator(this, device, gc);
    }
}

