/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.paperclips.core.page;

import org.eclipse.nebula.paperclips.core.Print;
import org.eclipse.nebula.paperclips.core.PrintIterator;
import org.eclipse.nebula.paperclips.core.internal.util.PaperClipsUtil;
import org.eclipse.nebula.paperclips.core.internal.util.Util;
import org.eclipse.nebula.paperclips.core.page.DefaultPageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumber;
import org.eclipse.nebula.paperclips.core.page.PageNumberFormat;
import org.eclipse.nebula.paperclips.core.page.PageNumberIterator;
import org.eclipse.nebula.paperclips.core.text.TextStyle;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;

public class PageNumberPrint
implements Print {
    public static final FontData DEFAULT_FONT_DATA = new FontData();
    public static final int DEFAULT_ALIGN = 16384;
    public static final TextStyle DEFAULT_TEXT_STYLE = new TextStyle().font(DEFAULT_FONT_DATA).align(16384);
    PageNumber pageNumber;
    TextStyle textStyle;
    PageNumberFormat format;

    public PageNumberPrint(PageNumber pageNumber) {
        this(pageNumber, DEFAULT_TEXT_STYLE);
    }

    public PageNumberPrint(PageNumber pageNumber, FontData fontData) {
        this(pageNumber, DEFAULT_TEXT_STYLE.font(fontData));
    }

    public PageNumberPrint(PageNumber pageNumber, int align) {
        this(pageNumber, DEFAULT_TEXT_STYLE.align(align));
    }

    public PageNumberPrint(PageNumber pageNumber, FontData fontData, int align) {
        this(pageNumber, DEFAULT_TEXT_STYLE.font(fontData).align(align));
    }

    public PageNumberPrint(PageNumber pageNumber, TextStyle textStyle) {
        this.setPageNumber(pageNumber);
        this.setTextStyle(textStyle);
        this.setPageNumberFormat(new DefaultPageNumberFormat());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pageNumber == null ? 0 : this.pageNumber.hashCode());
        result = 31 * result + (this.textStyle == null ? 0 : this.textStyle.hashCode());
        result = 31 * result + (this.format == null ? 0 : this.format.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PageNumberPrint other = (PageNumberPrint)obj;
        if (this.pageNumber == null ? other.pageNumber != null : !this.pageNumber.equals(other.pageNumber)) {
            return false;
        }
        if (this.textStyle == null ? other.textStyle != null : !this.textStyle.equals(other.textStyle)) {
            return false;
        }
        return !(this.format == null ? other.format != null : !this.format.equals(other.format));
    }

    public void setPageNumber(PageNumber pageNumber) {
        Util.notNull(pageNumber);
        this.pageNumber = pageNumber;
    }

    public PageNumber getPageNumber() {
        return this.pageNumber;
    }

    public void setFontData(FontData fontData) {
        Util.notNull(fontData);
        this.setTextStyle(this.textStyle.font(fontData));
    }

    public FontData getFontData() {
        return this.textStyle.getFontData();
    }

    public void setAlign(int align) {
        this.setTextStyle(this.textStyle.align(this.checkAlign(align)));
    }

    public int getAlign() {
        return this.textStyle.getAlignment();
    }

    private int checkAlign(int align) {
        return PaperClipsUtil.firstMatch(align, new int[]{16384, 0x1000000, 131072}, 16384);
    }

    public TextStyle getTextStyle() {
        return this.textStyle;
    }

    public void setTextStyle(TextStyle textStyle) {
        Util.notNull(textStyle);
        this.textStyle = textStyle;
    }

    public void setPageNumberFormat(PageNumberFormat format) {
        Util.notNull(format);
        this.format = format;
    }

    public PageNumberFormat getPageNumberFormat() {
        return this.format;
    }

    public void setRGB(RGB foreground) {
        Util.notNull(foreground);
        this.setTextStyle(this.textStyle.foreground(foreground));
    }

    public RGB getRGB() {
        return this.textStyle.getForeground();
    }

    @Override
    public PrintIterator iterator(Device device, GC gc) {
        return new PageNumberIterator(this, device, gc);
    }
}

